/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.filter;

import fr.ifremer.coselmar.persistence.CoselmarPersistenceContext;
import fr.ifremer.coselmar.services.CoselmarRestRequestContext;
import fr.ifremer.coselmar.services.CoselmarRestUtil;
import fr.ifremer.coselmar.services.CoselmarServicesApplicationContext;
import fr.ifremer.coselmar.services.CoselmarServicesContext;
import fr.ifremer.coselmar.services.filter.CoselmarTopiaTransactionFilter;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.WebMotionFilter;
import org.debux.webmotion.server.call.Call;
import org.debux.webmotion.server.call.HttpContext;
import org.debux.webmotion.server.render.Render;
import org.debux.webmotion.server.render.RenderStatus;

public class CoselmarRestRequestFilter
extends WebMotionFilter {
    public static final String REQUEST_PERMISSION_PARAMETER = "permission";
    public static final String REQUEST_HEADER_SESSION_TOKEN = "X-Coselmar-Session-Token";
    private static final Log log = LogFactory.getLog(CoselmarRestRequestFilter.class);

    public void inject(Call call, HttpContext context) {
        Render render;
        this.prepareRequestContext(context);
        if ("OPTIONS".equals(context.getMethod()) && (render = call.getRender()) instanceof RenderStatus && 200 == ((RenderStatus)render).getCode()) {
            CoselmarRestUtil.addOptionCorsHeaders((HttpContext)context);
        }
        CoselmarRestUtil.prepareResponse((HttpContext)context);
        this.doProcess();
    }

    protected CoselmarRestRequestContext prepareRequestContext(HttpContext context) {
        Locale locale = this.getUserLocale(context);
        CoselmarServicesApplicationContext applicationContext = CoselmarServicesApplicationContext.getApplicationContext((ServletContext)context.getServletContext());
        CoselmarPersistenceContext persistenceContext = (CoselmarPersistenceContext)CoselmarTopiaTransactionFilter.getPersistenceContext((ServletRequest)context.getRequest());
        CoselmarServicesContext serviceContext = applicationContext.newServiceContext(persistenceContext, locale);
        CoselmarRestRequestContext requestContext = new CoselmarRestRequestContext();
        requestContext.setServicesContext(serviceContext);
        CoselmarRestRequestContext.setRequestContext((HttpContext)context, (CoselmarRestRequestContext)requestContext);
        return requestContext;
    }

    protected Locale getUserLocale(HttpContext context) {
        String language = context.getHeader("Accept-Language");
        if (log.isInfoEnabled()) {
            log.info((Object)("Found Accept-Language: " + language));
        }
        if (language != null) {
            String[] allLanguage = language.split(",");
            int i = 0;
            do {
                if ((language = allLanguage[i].substring(0, 2)).equals("fr") || language.equals("en")) continue;
                language = null;
            } while (language == null && ++i < allLanguage.length);
        }
        if (language == null) {
            language = Locale.FRENCH.getLanguage();
            if (log.isInfoEnabled()) {
                log.info((Object)("Use default language: " + language));
            }
        }
        Locale locale = new Locale(language);
        return locale;
    }
}

