package fr.ifremer.common.synchro.type;

/*
 * #%L
 * Ifremer shared :: Application
 * $Id: ApplicationProgressionModel.java 1379 2013-11-24 22:44:33Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0.1/application/src/main/java/fr/ifremer/shared/application/type/ApplicationProgressionModel.java $
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.beans.PropertyChangeSupport;

/**
 * Simple model for a progression long task.
 *
 * @author tchemit (chemit@codelutin.com)
 * @since 1.0
 */
public class ProgressionModel extends PropertyChangeSupport {

	private static final long serialVersionUID = 1L;

	/** Constant <code>PROPERTY_TOTAL="total"</code> */
	public static final String PROPERTY_TOTAL = "total";

	/** Constant <code>PROPERTY_CURRENT="current"</code> */
	public static final String PROPERTY_CURRENT = "current";

	/** Constant <code>PROPERTY_RATE="rate"</code> */
	public static final String PROPERTY_RATE = "rate";

	/** Constant <code>PROPERTY_MESSAGE="message"</code> */
	public static final String PROPERTY_MESSAGE = "message";

	protected int total;

	protected int current;

	protected float rate;

	protected String message;

	/**
	 * Constructs a <code>ApplicationProgressionModel</code> object.
	 *
	 * @param sourceBean
	 *            The bean to be given as the source for any events.
	 */
	public ProgressionModel(Object sourceBean) {
		super(sourceBean);
	}

	/**
	 * <p>Getter for the field <code>total</code>.</p>
	 *
	 * @return a int.
	 */
	public int getTotal() {
		return total;
	}

	/**
	 * <p>Setter for the field <code>total</code>.</p>
	 *
	 * @param total a int.
	 */
	public void setTotal(int total) {
		Object oldValue = getTotal();
		this.total = total;
		firePropertyChange(PROPERTY_TOTAL, oldValue, total);
		setCurrent(0);
	}

	/**
	 * <p>adaptTotal.</p>
	 *
	 * @param total a int.
	 */
	public void adaptTotal(int total) {
		int current = getCurrent();
		setTotal(total);
		increments(current);
		Object oldValue = getTotal();
		this.total = total;
		firePropertyChange(PROPERTY_TOTAL, oldValue, total);
		setCurrent(current);
	}

	/**
	 * <p>Getter for the field <code>current</code>.</p>
	 *
	 * @return a int.
	 */
	public int getCurrent() {
		return current;
	}

	/**
	 * <p>Setter for the field <code>current</code>.</p>
	 *
	 * @param current a int.
	 */
	public void setCurrent(int current) {
		Object oldValue = getCurrent();
		this.current = current;
		firePropertyChange(PROPERTY_CURRENT, oldValue, current);
	}

	/**
	 * <p>increments.</p>
	 *
	 * @param nb a int.
	 */
	public void increments(int nb) {
		if (nb != 0) {
			setCurrent(current + nb);
			setRate(getCurrent() / getTotal());
		}
	}

	/**
	 * <p>Getter for the field <code>rate</code>.</p>
	 *
	 * @return a float.
	 */
	public float getRate() {
		return rate;
	}

	/**
	 * <p>Setter for the field <code>rate</code>.</p>
	 *
	 * @param rate a float.
	 */
	public void setRate(float rate) {
		Object oldValue = getRate();
		this.rate = rate;
		firePropertyChange(PROPERTY_RATE, oldValue, rate);
	}

	/**
	 * <p>Getter for the field <code>message</code>.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * <p>increments.</p>
	 *
	 * @param message a {@link java.lang.String} object.
	 */
	public void increments(String message) {
		increments(1);
		setMessage(message);
	}

	/**
	 * <p>Setter for the field <code>message</code>.</p>
	 *
	 * @param message a {@link java.lang.String} object.
	 */
	public void setMessage(String message) {
		Object oldValue = getMessage();
		this.message = message;
		firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
	}
}
