package fr.ifremer.common.synchro.service;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

/**
 * <p>
 * Use to store security data, used by the synchronization process, specially in
 * {@link fr.ifremer.common.synchro.intercept.SynchroInterceptor} subclasses.
 * </p>
 * <p>
 * See example in adagio synchro module
 * </p>
 *
 * @author Benoit Lavenier (benoit.lavenier@e-is.pro)
 * @since 3.5.3
 */
public class SynchroSecurityContext {

	private Integer userId = -1;

	private Integer sessionId = -1;

	/**
	 * <p>Constructor for SynchroSecurityContext.</p>
	 *
	 * @param userId a {@link java.lang.Integer} object.
	 */
	public SynchroSecurityContext(Integer userId) {
		this.userId = userId;
	}

	/**
	 * <p>Constructor for SynchroSecurityContext.</p>
	 *
	 * @param userId a {@link java.lang.Integer} object.
	 * @param sessionId a {@link java.lang.Integer} object.
	 */
	public SynchroSecurityContext(Integer userId, Integer sessionId) {
		this.userId = userId;
		this.sessionId = sessionId;
	}

	/**
	 * <p>Getter for the field <code>userId</code>.</p>
	 *
	 * @return a {@link java.lang.Integer} object.
	 */
	public Integer getUserId() {
		return userId;
	}

	/**
	 * <p>Setter for the field <code>userId</code>.</p>
	 *
	 * @param userId a {@link java.lang.Integer} object.
	 */
	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	/**
	 * <p>Getter for the field <code>sessionId</code>.</p>
	 *
	 * @return a {@link java.lang.Integer} object.
	 */
	public Integer getSessionId() {
		return this.sessionId;
	}

	/**
	 * <p>Setter for the field <code>sessionId</code>.</p>
	 *
	 * @param sessionId a {@link java.lang.Integer} object.
	 */
	public void setSessionId(Integer sessionId) {
		this.sessionId = sessionId;
	}

	/**
	 * <p>isUserLogged.</p>
	 *
	 * @return a boolean.
	 */
	public boolean isUserLogged() {
		return sessionId != null && userId != null;
	}
}
