package fr.ifremer.common.synchro.intercept;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.common.synchro.SynchroBusinessException;

/**
 * <p>Abstract SynchroRejectRowException class.</p>
 *
 */
public abstract class SynchroRejectRowException
		extends
			SynchroBusinessException {

	private static final long serialVersionUID = 1L;

	/**
	 * <p>Constructor for SynchroRejectRowException.</p>
	 *
	 * @param message a {@link java.lang.String} object.
	 * @param cause a {@link java.lang.Throwable} object.
	 */
	public SynchroRejectRowException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * <p>Constructor for SynchroRejectRowException.</p>
	 *
	 * @param message a {@link java.lang.String} object.
	 */
	public SynchroRejectRowException(String message) {
		super(message);
	}

	/**
	 * <p>Constructor for SynchroRejectRowException.</p>
	 *
	 * @param cause a {@link java.lang.Throwable} object.
	 */
	public SynchroRejectRowException(Throwable cause) {
		super(cause);
	}

}
