package fr.ifremer.common.synchro.intercept;

import fr.ifremer.common.synchro.service.SynchroContext;

import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

/**
 * <p>SynchroOperationRepository interface.</p>
 *
 */
public interface SynchroOperationRepository {

	/**
	 * <p>addMissingColumnUpdate.</p>
	 *
	 * @param columnName a {@link java.lang.String} object.
	 * @param pk a {@link java.util.List} object.
	 * @param columnValue a {@link java.lang.Object} object.
	 */
	void addMissingColumnUpdate(String columnName, List<Object> pk,
			Object columnValue);

	/**
	 * <p>addMissingColumnUpdate.</p>
	 *
	 * @param columnName a {@link java.lang.String} object.
	 * @param pkStr a {@link java.lang.String} object.
	 * @param columnValue a {@link java.lang.Object} object.
	 */
	void addMissingColumnUpdate(String columnName, String pkStr,
			Object columnValue);

	/**
	 * <p>addAllMissingColumnUpdates.</p>
	 *
	 * @param missingUpdates a {@link java.util.Map} object.
	 */
	void addAllMissingColumnUpdates(
			Map<String, Map<String, Object>> missingUpdates);

	/**
	 * <p>addAllMissingUpdatesByPks.</p>
	 *
	 * @param missingUpdatesByPkStr a {@link java.util.Map} object.
	 */
	void addAllMissingUpdatesByPks(
			Map<String, Object[]> missingUpdatesByPkStr);

	/**
	 * <p>addChildToUpdateFromOneColumn.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnName a {@link java.lang.String} object.
	 * @param columnValue a {@link java.lang.Object} object.
	 */
	void addChildToUpdateFromOneColumn(String childTablename,
			String columnName, Object columnValue);

	/**
	 * <p>addChildrenToUpdateFromOneColumn.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnName a {@link java.lang.String} object.
	 * @param columnValues a {@link java.util.List} object.
	 */
	void addChildrenToUpdateFromOneColumn(String childTablename,
			String columnName, List<Object> columnValues);

	/**
	 * <p>addChildToUpdateFromManyColumns.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnNames a {@link java.util.Set} object.
	 * @param columnValues a {@link java.util.List} object.
	 */
	void addChildToUpdateFromManyColumns(String childTablename,
			Set<String> columnNames, List<Object> columnValues);

	/**
	 * <p>addChildrenToUpdateFromManyColumns.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnNames a {@link java.util.Set} object.
	 * @param columnValues a {@link java.util.List} object.
	 */
	void addChildrenToUpdateFromManyColumns(String childTablename,
			Set<String> columnNames, List<List<Object>> columnValues);

	/**
	 * <p>addChildToDeleteFromManyColumns.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnNames a {@link java.util.Set} object.
	 * @param columnValue a {@link java.util.List} object.
	 */
	void addChildToDeleteFromManyColumns(String childTablename,
			Set<String> columnNames, List<Object> columnValue);

	/**
	 * <p>addChildToDeleteFromOneColumn.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnName a {@link java.lang.String} object.
	 * @param columnValue a {@link java.lang.Object} object.
	 */
	void addChildToDeleteFromOneColumn(String childTablename,
			String columnName, Object columnValue);

	/**
	 * <p>addChildrenToDeleteFromOneColumn.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnName a {@link java.lang.String} object.
	 * @param columnValue a {@link java.util.List} object.
	 */
	void addChildrenToDeleteFromOneColumn(String childTablename,
			String columnName, List<Object> columnValue);

	/**
	 * <p>addChildrenToDeleteFromManyColumns.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnNames a {@link java.util.Set} object.
	 * @param columnValues a {@link java.util.List} object.
	 */
	void addChildrenToDeleteFromManyColumns(String childTablename,
			Set<String> columnNames, List<List<Object>> columnValues);

	/**
	 * <p>addChildToDetachFromOneColumn.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnName a {@link java.lang.String} object.
	 * @param columnValue a {@link java.lang.Object} object.
	 */
	void addChildToDetachFromOneColumn(String childTablename,
			String columnName, Object columnValue);

	/**
	 * <p>addChildToDetachFromManyColumn.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnNames a {@link java.util.Set} object.
	 * @param columnValue a {@link java.util.List} object.
	 */
	void addChildToDetachFromManyColumn(String childTablename,
			Set<String> columnNames, List<Object> columnValue);

	/**
	 * <p>addChildrenToDetachFromManyColumns.</p>
	 *
	 * @param childTablename a {@link java.lang.String} object.
	 * @param columnNames a {@link java.util.Set} object.
	 * @param columnValues a {@link java.util.List} object.
	 */
	void addChildrenToDetachFromManyColumns(String childTablename,
			Set<String> columnNames, List<List<Object>> columnValues);

	/**
	 * <p>addAllMissingDelete.</p>
	 *
	 * @param pk a {@link java.util.List} object.
	 */
	void addAllMissingDelete(List<List<Object>> pk);

	/**
	 * <p>addMissingDelete.</p>
	 *
	 * @param pk a {@link java.util.List} object.
	 */
	void addMissingDelete(List<Object> pk);

	/**
	 * <p>addMissingDelete.</p>
	 *
	 * @param pkStr a {@link java.lang.String} object.
	 */
	void addMissingDelete(String pkStr);

	/**
	 * <p>addAllMissingDetach.</p>
	 *
	 * @param pks a {@link java.util.List} object.
	 */
	void addAllMissingDetach(List<List<Object>> pks);

	/**
	 * <p>addMissingDetach.</p>
	 *
	 * @param pk a {@link java.util.List} object.
	 */
	void addMissingDetach(List<Object> pk);

	/**
	 * <p>addMissingDetach.</p>
	 *
	 * @param pkStr a {@link java.lang.String} object.
	 */
	void addMissingDetach(String pkStr);

	/**
	 * Give a access to the context of the current synchronization
	 *
	 * @return the result bean
	 */
	SynchroContext getSynchroContext();

}
