package fr.ifremer.common.synchro.intercept;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: ReferentialSynchroSpecificTableTask.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/synchro/specific/ReferentialSynchroSpecificTableTask.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.meta.event.SynchroTableListener;
import fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.List;

/**
 * Created on 4/10/14.
 *
 * @author Benoit Lavenier (benoit.lavenier@e-is.pro)
 * @since 3.5.3
 */
public interface SynchroInterceptor
		extends
			SynchroTableListener,
			Cloneable,
			Closeable {

	/**
	 * Method call just after the construction, to known if must be applied
	 *
	 * @param config
	 *            a not null database configuration
	 * @return a boolean.
	 */
	boolean apply(SynchroDatabaseConfiguration config);

	/**
	 * <p>setNext.</p>
	 *
	 * @param next a {@link fr.ifremer.common.synchro.intercept.SynchroInterceptor} object.
	 */
	void setNext(SynchroInterceptor next);

	/**
	 * <p>getNext.</p>
	 *
	 * @return a {@link fr.ifremer.common.synchro.intercept.SynchroInterceptor} object.
	 */
	SynchroInterceptor getNext();

	/**
	 * <p>clone.</p>
	 *
	 * @return a {@link fr.ifremer.common.synchro.intercept.SynchroInterceptor} object.
	 */
	SynchroInterceptor clone();

	/**
	 * Method on one row, when reading the row (but not necesserly writing it -
	 * e.g. read PK).
	 * <br>
	 * Main difference with onWrite() is :
	 * <ul>
	 * <li>this method could be called many time for a row (onWrite is called
	 * only once)
	 * <li>You should not throw exception, even if mandatory data are missing,
	 * because writing this row is not sure
	 * <li>The given row could be a fake row, with only needed field (e.g. ion
	 * ly fields need to get duplicate rows, by unique index)
	 * </ul>
	 *
	 * @param data an array of {@link java.lang.Object} objects.
	 * @param sourceDao a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 * @param targetDao a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 * @throws java.sql.SQLException if any.
	 */
	void onRead(Object[] data, SynchroTableDao sourceDao,
			SynchroTableDao targetDao) throws SQLException;

	/**
	 * Method call on each row, just before to write it (insert or update)
	 *
	 * @param data an array of {@link java.lang.Object} objects.
	 * @param pk a {@link java.util.List} object.
	 * @param sourceDao a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 * @param targetDao a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 * @param buffer a {@link fr.ifremer.common.synchro.intercept.SynchroOperationRepository} object.
	 * @param insert
	 *            true for a insertion, false for an update
	 * @throws java.sql.SQLException if any.
	 */
	void onWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao,
			SynchroTableDao targetDao, SynchroOperationRepository buffer,
			boolean insert) throws SQLException;

	/**
	 * Method call on each row to delete, just before deletion
	 *
	 * @param pk a {@link java.util.List} object.
	 * @param sourceDao a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 * @param targetDao a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 * @param buffer a {@link fr.ifremer.common.synchro.intercept.SynchroOperationRepository} object.
	 * @throws java.sql.SQLException if any.
	 */
	void onDelete(List<Object> pk, SynchroTableDao sourceDao,
			SynchroTableDao targetDao, SynchroOperationRepository buffer)
			throws SQLException;

	/**
	 * Method call on each row to detach (clean link to server)
	 *
	 * @param pk a {@link java.util.List} object.
	 * @param sourceDao a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 * @param targetDao a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 * @param buffer a {@link fr.ifremer.common.synchro.intercept.SynchroOperationRepository} object.
	 * @throws java.sql.SQLException if any.
	 */
	void onDetach(List<Object> pk, SynchroTableDao sourceDao,
			SynchroTableDao targetDao, SynchroOperationRepository buffer)
			throws SQLException;

	/**
	 * <p>enableOnRead.</p>
	 *
	 * @return a boolean.
	 */
	boolean enableOnRead();

	/**
	 * <p>enableOnWrite.</p>
	 *
	 * @return a boolean.
	 */
	boolean enableOnWrite();
}
