package fr.ifremer.common.synchro.intercept;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.List;

import org.nuiton.i18n.I18n;

import fr.ifremer.common.synchro.meta.SynchroTableMetadata;

/**
 * <p>SynchroDeletedRowException class.</p>
 *
 */
public class SynchroDeletedRowException extends SynchroRejectRowException {

	private static final long serialVersionUID = 1L;

	private final String sourcePkStr;
	private final String targetPkStr;
	private final String tableName;

	/**
	 * <p>Constructor for SynchroDeletedRowException.</p>
	 *
	 * @param tableName a {@link java.lang.String} object.
	 * @param sourcePk a {@link java.util.List} object.
	 * @param targetPk a {@link java.util.List} object.
	 */
	public SynchroDeletedRowException(String tableName, List<Object> sourcePk,
			List<Object> targetPk) {
		this(tableName, SynchroTableMetadata.toPkStr(sourcePk),
				SynchroTableMetadata.toPkStr(targetPk));
	}

	/**
	 * <p>Constructor for SynchroDeletedRowException.</p>
	 *
	 * @param tableName a {@link java.lang.String} object.
	 * @param sourcePkStr a {@link java.lang.String} object.
	 * @param targetPkStr a {@link java.lang.String} object.
	 */
	public SynchroDeletedRowException(String tableName, String sourcePkStr,
			String targetPkStr) {
		super(I18n.t("synchro.synchronize.reject.deleted.error",
				tableName, targetPkStr, sourcePkStr));
		this.tableName = tableName;
		this.sourcePkStr = sourcePkStr;
		this.targetPkStr = targetPkStr;
	}

	/**
	 * <p>Getter for the field <code>sourcePkStr</code>.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getSourcePkStr() {
		return sourcePkStr;
	}

	/**
	 * <p>Getter for the field <code>targetPkStr</code>.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getTargetPkStr() {
		return targetPkStr;
	}

	/**
	 * <p>Getter for the field <code>tableName</code>.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getTableName() {
		return tableName;
	}
}
