package fr.ifremer.common.synchro.dao;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

/**
 * <p>NotCloseablePreparedStatement class.</p>
 *
 */
public class NotCloseablePreparedStatement implements PreparedStatement {

	private final PreparedStatement delegate;

	/**
	 * <p>Constructor for NotCloseablePreparedStatement.</p>
	 *
	 * @param delegate a {@link java.sql.PreparedStatement} object.
	 */
	public NotCloseablePreparedStatement(PreparedStatement delegate) {
		this.delegate = delegate;
	}

	/**
	 * <p>close.</p>
	 *
	 * @throws java.sql.SQLException if any.
	 */
	public void close() throws SQLException {
		// Do not close (cache manager will do it) : see DaoFactory
		// implementation
		// delegate.close();
	}

	/**
	 * <p>closeOnCompletion.</p>
	 *
	 * @throws java.sql.SQLException if any.
	 */
	public void closeOnCompletion() throws SQLException {
		// Do not close (cache manager will do it) : see DaoFactory
		// implementation
		// delegate.closeOnCompletion();
	}

	/* -- delegated methods -- */

	/** {@inheritDoc} */
	public <T> T unwrap(Class<T> iface) throws SQLException {
		return delegate.unwrap(iface);
	}

	/** {@inheritDoc} */
	public ResultSet executeQuery(String sql) throws SQLException {
		return delegate.executeQuery(sql);
	}

	/**
	 * <p>executeQuery.</p>
	 *
	 * @return a {@link java.sql.ResultSet} object.
	 * @throws java.sql.SQLException if any.
	 */
	public ResultSet executeQuery() throws SQLException {
		return delegate.executeQuery();
	}

	/** {@inheritDoc} */
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		return delegate.isWrapperFor(iface);
	}

	/** {@inheritDoc} */
	public int executeUpdate(String sql) throws SQLException {
		return delegate.executeUpdate(sql);
	}

	/**
	 * <p>executeUpdate.</p>
	 *
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int executeUpdate() throws SQLException {
		return delegate.executeUpdate();
	}

	/** {@inheritDoc} */
	public void setNull(int parameterIndex, int sqlType) throws SQLException {
		delegate.setNull(parameterIndex, sqlType);
	}

	/**
	 * <p>getMaxFieldSize.</p>
	 *
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int getMaxFieldSize() throws SQLException {
		return delegate.getMaxFieldSize();
	}

	/** {@inheritDoc} */
	public void setBoolean(int parameterIndex, boolean x) throws SQLException {
		delegate.setBoolean(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setByte(int parameterIndex, byte x) throws SQLException {
		delegate.setByte(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setMaxFieldSize(int max) throws SQLException {
		delegate.setMaxFieldSize(max);
	}

	/** {@inheritDoc} */
	public void setShort(int parameterIndex, short x) throws SQLException {
		delegate.setShort(parameterIndex, x);
	}

	/**
	 * <p>getMaxRows.</p>
	 *
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int getMaxRows() throws SQLException {
		return delegate.getMaxRows();
	}

	/** {@inheritDoc} */
	public void setInt(int parameterIndex, int x) throws SQLException {
		delegate.setInt(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setMaxRows(int max) throws SQLException {
		delegate.setMaxRows(max);
	}

	/** {@inheritDoc} */
	public void setLong(int parameterIndex, long x) throws SQLException {
		delegate.setLong(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setEscapeProcessing(boolean enable) throws SQLException {
		delegate.setEscapeProcessing(enable);
	}

	/** {@inheritDoc} */
	public void setFloat(int parameterIndex, float x) throws SQLException {
		delegate.setFloat(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setDouble(int parameterIndex, double x) throws SQLException {
		delegate.setDouble(parameterIndex, x);
	}

	/**
	 * <p>getQueryTimeout.</p>
	 *
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int getQueryTimeout() throws SQLException {
		return delegate.getQueryTimeout();
	}

	/** {@inheritDoc} */
	public void setQueryTimeout(int seconds) throws SQLException {
		delegate.setQueryTimeout(seconds);
	}

	/** {@inheritDoc} */
	public void setBigDecimal(int parameterIndex, BigDecimal x)
			throws SQLException {
		delegate.setBigDecimal(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setString(int parameterIndex, String x) throws SQLException {
		delegate.setString(parameterIndex, x);
	}

	/**
	 * <p>setBytes.</p>
	 *
	 * @param parameterIndex a int.
	 * @param x an array of byte.
	 * @throws java.sql.SQLException if any.
	 */
	public void setBytes(int parameterIndex, byte[] x) throws SQLException {
		delegate.setBytes(parameterIndex, x);
	}

	/**
	 * <p>cancel.</p>
	 *
	 * @throws java.sql.SQLException if any.
	 */
	public void cancel() throws SQLException {
		delegate.cancel();
	}

	/**
	 * <p>getWarnings.</p>
	 *
	 * @return a {@link java.sql.SQLWarning} object.
	 * @throws java.sql.SQLException if any.
	 */
	public SQLWarning getWarnings() throws SQLException {
		return delegate.getWarnings();
	}

	/** {@inheritDoc} */
	public void setDate(int parameterIndex, Date x) throws SQLException {
		delegate.setDate(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setTime(int parameterIndex, Time x) throws SQLException {
		delegate.setTime(parameterIndex, x);
	}

	/**
	 * <p>clearWarnings.</p>
	 *
	 * @throws java.sql.SQLException if any.
	 */
	public void clearWarnings() throws SQLException {
		delegate.clearWarnings();
	}

	/** {@inheritDoc} */
	public void setCursorName(String name) throws SQLException {
		delegate.setCursorName(name);
	}

	/** {@inheritDoc} */
	public void setTimestamp(int parameterIndex, Timestamp x)
			throws SQLException {
		delegate.setTimestamp(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setAsciiStream(int parameterIndex, InputStream x, int length)
			throws SQLException {
		delegate.setAsciiStream(parameterIndex, x, length);
	}

	/** {@inheritDoc} */
	public boolean execute(String sql) throws SQLException {
		return delegate.execute(sql);
	}

	/** {@inheritDoc} */
	@Deprecated
	public void setUnicodeStream(int parameterIndex, InputStream x, int length)
			throws SQLException {
		delegate.setUnicodeStream(parameterIndex, x, length);
	}

	/**
	 * <p>getResultSet.</p>
	 *
	 * @return a {@link java.sql.ResultSet} object.
	 * @throws java.sql.SQLException if any.
	 */
	public ResultSet getResultSet() throws SQLException {
		return delegate.getResultSet();
	}

	/**
	 * <p>setBinaryStream.</p>
	 *
	 * @param parameterIndex a int.
	 * @param x a {@link java.io.InputStream} object.
	 * @param length a int.
	 * @throws java.sql.SQLException if any.
	 */
	public void setBinaryStream(int parameterIndex, InputStream x, int length)
			throws SQLException {
		delegate.setBinaryStream(parameterIndex, x, length);
	}

	/**
	 * <p>getUpdateCount.</p>
	 *
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int getUpdateCount() throws SQLException {
		return delegate.getUpdateCount();
	}

	/**
	 * <p>getMoreResults.</p>
	 *
	 * @return a boolean.
	 * @throws java.sql.SQLException if any.
	 */
	public boolean getMoreResults() throws SQLException {
		return delegate.getMoreResults();
	}

	/**
	 * <p>clearParameters.</p>
	 *
	 * @throws java.sql.SQLException if any.
	 */
	public void clearParameters() throws SQLException {
		delegate.clearParameters();
	}

	/**
	 * <p>setObject.</p>
	 *
	 * @param parameterIndex a int.
	 * @param x a {@link java.lang.Object} object.
	 * @param targetSqlType a int.
	 * @throws java.sql.SQLException if any.
	 */
	public void setObject(int parameterIndex, Object x, int targetSqlType)
			throws SQLException {
		delegate.setObject(parameterIndex, x, targetSqlType);
	}

	/** {@inheritDoc} */
	public void setFetchDirection(int direction) throws SQLException {
		delegate.setFetchDirection(direction);
	}

	/**
	 * <p>getFetchDirection.</p>
	 *
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int getFetchDirection() throws SQLException {
		return delegate.getFetchDirection();
	}

	/** {@inheritDoc} */
	public void setObject(int parameterIndex, Object x) throws SQLException {
		delegate.setObject(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setFetchSize(int rows) throws SQLException {
		delegate.setFetchSize(rows);
	}

	/**
	 * <p>getFetchSize.</p>
	 *
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int getFetchSize() throws SQLException {
		return delegate.getFetchSize();
	}

	/**
	 * <p>getResultSetConcurrency.</p>
	 *
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int getResultSetConcurrency() throws SQLException {
		return delegate.getResultSetConcurrency();
	}

	/**
	 * <p>execute.</p>
	 *
	 * @return a boolean.
	 * @throws java.sql.SQLException if any.
	 */
	public boolean execute() throws SQLException {
		return delegate.execute();
	}

	/**
	 * <p>getResultSetType.</p>
	 *
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int getResultSetType() throws SQLException {
		return delegate.getResultSetType();
	}

	/** {@inheritDoc} */
	public void addBatch(String sql) throws SQLException {
		delegate.addBatch(sql);
	}

	/**
	 * <p>clearBatch.</p>
	 *
	 * @throws java.sql.SQLException if any.
	 */
	public void clearBatch() throws SQLException {
		delegate.clearBatch();
	}

	/**
	 * <p>addBatch.</p>
	 *
	 * @throws java.sql.SQLException if any.
	 */
	public void addBatch() throws SQLException {
		delegate.addBatch();
	}

	/**
	 * <p>executeBatch.</p>
	 *
	 * @return an array of int.
	 * @throws java.sql.SQLException if any.
	 */
	public int[] executeBatch() throws SQLException {
		return delegate.executeBatch();
	}

	/**
	 * <p>setCharacterStream.</p>
	 *
	 * @param parameterIndex a int.
	 * @param reader a {@link java.io.Reader} object.
	 * @param length a int.
	 * @throws java.sql.SQLException if any.
	 */
	public void setCharacterStream(int parameterIndex, Reader reader, int length)
			throws SQLException {
		delegate.setCharacterStream(parameterIndex, reader, length);
	}

	/** {@inheritDoc} */
	public void setRef(int parameterIndex, Ref x) throws SQLException {
		delegate.setRef(parameterIndex, x);
	}

	/**
	 * <p>setBlob.</p>
	 *
	 * @param parameterIndex a int.
	 * @param x a {@link java.sql.Blob} object.
	 * @throws java.sql.SQLException if any.
	 */
	public void setBlob(int parameterIndex, Blob x) throws SQLException {
		delegate.setBlob(parameterIndex, x);
	}

	/**
	 * <p>setClob.</p>
	 *
	 * @param parameterIndex a int.
	 * @param x a {@link java.sql.Clob} object.
	 * @throws java.sql.SQLException if any.
	 */
	public void setClob(int parameterIndex, Clob x) throws SQLException {
		delegate.setClob(parameterIndex, x);
	}

	/**
	 * <p>getConnection.</p>
	 *
	 * @return a {@link java.sql.Connection} object.
	 * @throws java.sql.SQLException if any.
	 */
	public Connection getConnection() throws SQLException {
		return delegate.getConnection();
	}

	/** {@inheritDoc} */
	public void setArray(int parameterIndex, Array x) throws SQLException {
		delegate.setArray(parameterIndex, x);
	}

	/**
	 * <p>getMetaData.</p>
	 *
	 * @return a {@link java.sql.ResultSetMetaData} object.
	 * @throws java.sql.SQLException if any.
	 */
	public ResultSetMetaData getMetaData() throws SQLException {
		return delegate.getMetaData();
	}

	/** {@inheritDoc} */
	public boolean getMoreResults(int current) throws SQLException {
		return delegate.getMoreResults(current);
	}

	/** {@inheritDoc} */
	public void setDate(int parameterIndex, Date x, Calendar cal)
			throws SQLException {
		delegate.setDate(parameterIndex, x, cal);
	}

	/**
	 * <p>getGeneratedKeys.</p>
	 *
	 * @return a {@link java.sql.ResultSet} object.
	 * @throws java.sql.SQLException if any.
	 */
	public ResultSet getGeneratedKeys() throws SQLException {
		return delegate.getGeneratedKeys();
	}

	/** {@inheritDoc} */
	public void setTime(int parameterIndex, Time x, Calendar cal)
			throws SQLException {
		delegate.setTime(parameterIndex, x, cal);
	}

	/**
	 * <p>executeUpdate.</p>
	 *
	 * @param sql a {@link java.lang.String} object.
	 * @param autoGeneratedKeys a int.
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int executeUpdate(String sql, int autoGeneratedKeys)
			throws SQLException {
		return delegate.executeUpdate(sql, autoGeneratedKeys);
	}

	/** {@inheritDoc} */
	public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal)
			throws SQLException {
		delegate.setTimestamp(parameterIndex, x, cal);
	}

	/** {@inheritDoc} */
	public void setNull(int parameterIndex, int sqlType, String typeName)
			throws SQLException {
		delegate.setNull(parameterIndex, sqlType, typeName);
	}

	/**
	 * <p>executeUpdate.</p>
	 *
	 * @param sql a {@link java.lang.String} object.
	 * @param columnIndexes an array of int.
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int executeUpdate(String sql, int[] columnIndexes)
			throws SQLException {
		return delegate.executeUpdate(sql, columnIndexes);
	}

	/** {@inheritDoc} */
	public void setURL(int parameterIndex, URL x) throws SQLException {
		delegate.setURL(parameterIndex, x);
	}

	/**
	 * <p>executeUpdate.</p>
	 *
	 * @param sql a {@link java.lang.String} object.
	 * @param columnNames an array of {@link java.lang.String} objects.
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int executeUpdate(String sql, String[] columnNames)
			throws SQLException {
		return delegate.executeUpdate(sql, columnNames);
	}

	/**
	 * <p>getParameterMetaData.</p>
	 *
	 * @return a {@link java.sql.ParameterMetaData} object.
	 * @throws java.sql.SQLException if any.
	 */
	public ParameterMetaData getParameterMetaData() throws SQLException {
		return delegate.getParameterMetaData();
	}

	/** {@inheritDoc} */
	public void setRowId(int parameterIndex, RowId x) throws SQLException {
		delegate.setRowId(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setNString(int parameterIndex, String value)
			throws SQLException {
		delegate.setNString(parameterIndex, value);
	}

	/**
	 * <p>execute.</p>
	 *
	 * @param sql a {@link java.lang.String} object.
	 * @param autoGeneratedKeys a int.
	 * @return a boolean.
	 * @throws java.sql.SQLException if any.
	 */
	public boolean execute(String sql, int autoGeneratedKeys)
			throws SQLException {
		return delegate.execute(sql, autoGeneratedKeys);
	}

	/** {@inheritDoc} */
	public void setNCharacterStream(int parameterIndex, Reader value,
			long length) throws SQLException {
		delegate.setNCharacterStream(parameterIndex, value, length);
	}

	/**
	 * <p>setNClob.</p>
	 *
	 * @param parameterIndex a int.
	 * @param value a {@link java.sql.NClob} object.
	 * @throws java.sql.SQLException if any.
	 */
	public void setNClob(int parameterIndex, NClob value) throws SQLException {
		delegate.setNClob(parameterIndex, value);
	}

	/** {@inheritDoc} */
	public void setClob(int parameterIndex, Reader reader, long length)
			throws SQLException {
		delegate.setClob(parameterIndex, reader, length);
	}

	/**
	 * <p>execute.</p>
	 *
	 * @param sql a {@link java.lang.String} object.
	 * @param columnIndexes an array of int.
	 * @return a boolean.
	 * @throws java.sql.SQLException if any.
	 */
	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		return delegate.execute(sql, columnIndexes);
	}

	/** {@inheritDoc} */
	public void setBlob(int parameterIndex, InputStream inputStream, long length)
			throws SQLException {
		delegate.setBlob(parameterIndex, inputStream, length);
	}

	/** {@inheritDoc} */
	public void setNClob(int parameterIndex, Reader reader, long length)
			throws SQLException {
		delegate.setNClob(parameterIndex, reader, length);
	}

	/**
	 * <p>execute.</p>
	 *
	 * @param sql a {@link java.lang.String} object.
	 * @param columnNames an array of {@link java.lang.String} objects.
	 * @return a boolean.
	 * @throws java.sql.SQLException if any.
	 */
	public boolean execute(String sql, String[] columnNames)
			throws SQLException {
		return delegate.execute(sql, columnNames);
	}

	/** {@inheritDoc} */
	public void setSQLXML(int parameterIndex, SQLXML xmlObject)
			throws SQLException {
		delegate.setSQLXML(parameterIndex, xmlObject);
	}

	/** {@inheritDoc} */
	public void setObject(int parameterIndex, Object x, int targetSqlType,
			int scaleOrLength) throws SQLException {
		delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
	}

	/**
	 * <p>getResultSetHoldability.</p>
	 *
	 * @return a int.
	 * @throws java.sql.SQLException if any.
	 */
	public int getResultSetHoldability() throws SQLException {
		return delegate.getResultSetHoldability();
	}

	/**
	 * <p>isClosed.</p>
	 *
	 * @return a boolean.
	 * @throws java.sql.SQLException if any.
	 */
	public boolean isClosed() throws SQLException {
		return delegate.isClosed();
	}

	/** {@inheritDoc} */
	public void setPoolable(boolean poolable) throws SQLException {
		delegate.setPoolable(poolable);
	}

	/**
	 * <p>isPoolable.</p>
	 *
	 * @return a boolean.
	 * @throws java.sql.SQLException if any.
	 */
	public boolean isPoolable() throws SQLException {
		return delegate.isPoolable();
	}

	/**
	 * <p>setAsciiStream.</p>
	 *
	 * @param parameterIndex a int.
	 * @param x a {@link java.io.InputStream} object.
	 * @param length a long.
	 * @throws java.sql.SQLException if any.
	 */
	public void setAsciiStream(int parameterIndex, InputStream x, long length)
			throws SQLException {
		delegate.setAsciiStream(parameterIndex, x, length);
	}

	/**
	 * <p>isCloseOnCompletion.</p>
	 *
	 * @return a boolean.
	 * @throws java.sql.SQLException if any.
	 */
	public boolean isCloseOnCompletion() throws SQLException {
		return delegate.isCloseOnCompletion();
	}

	/** {@inheritDoc} */
	public void setBinaryStream(int parameterIndex, InputStream x, long length)
			throws SQLException {
		delegate.setBinaryStream(parameterIndex, x, length);
	}

	/** {@inheritDoc} */
	public void setCharacterStream(int parameterIndex, Reader reader,
			long length) throws SQLException {
		delegate.setCharacterStream(parameterIndex, reader, length);
	}

	/** {@inheritDoc} */
	public void setAsciiStream(int parameterIndex, InputStream x)
			throws SQLException {
		delegate.setAsciiStream(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setBinaryStream(int parameterIndex, InputStream x)
			throws SQLException {
		delegate.setBinaryStream(parameterIndex, x);
	}

	/** {@inheritDoc} */
	public void setCharacterStream(int parameterIndex, Reader reader)
			throws SQLException {
		delegate.setCharacterStream(parameterIndex, reader);
	}

	/** {@inheritDoc} */
	public void setNCharacterStream(int parameterIndex, Reader value)
			throws SQLException {
		delegate.setNCharacterStream(parameterIndex, value);
	}

	/** {@inheritDoc} */
	public void setClob(int parameterIndex, Reader reader) throws SQLException {
		delegate.setClob(parameterIndex, reader);
	}

	/** {@inheritDoc} */
	public void setBlob(int parameterIndex, InputStream inputStream)
			throws SQLException {
		delegate.setBlob(parameterIndex, inputStream);
	}

	/** {@inheritDoc} */
	public void setNClob(int parameterIndex, Reader reader) throws SQLException {
		delegate.setNClob(parameterIndex, reader);
	}
}
