package fr.ifremer.common.synchro.dao;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Set;

import org.springframework.dao.DataIntegrityViolationException;

/**
 * <p>DataIntegrityViolationOnDeleteException class.</p>
 *
 */
public class DataIntegrityViolationOnDeleteException
		extends
			DataIntegrityViolationException {

	private static final long serialVersionUID = -3347826640266779734L;

	private final String tableName;
	private final String pkStr;
	private final Set<String> existingFkTableNames;

	/**
	 * <p>Constructor for DataIntegrityViolationOnDeleteException.</p>
	 *
	 * @param msg a {@link java.lang.String} object.
	 * @param tableName a {@link java.lang.String} object.
	 * @param pkStr a {@link java.lang.String} object.
	 * @param existingFkTableNames a {@link java.util.Set} object.
	 */
	public DataIntegrityViolationOnDeleteException(String msg,
			String tableName, String pkStr, Set<String> existingFkTableNames) {
		super(msg);
		this.tableName = tableName;
		this.pkStr = pkStr;
		this.existingFkTableNames = existingFkTableNames;
	}

	/**
	 * <p>Getter for the field <code>tableName</code>.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getTableName() {
		return tableName;
	}

	/**
	 * <p>Getter for the field <code>pkStr</code>.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getPkStr() {
		return pkStr;
	}

	/**
	 * <p>Getter for the field <code>existingFkTableNames</code>.</p>
	 *
	 * @return a {@link java.util.Set} object.
	 */
	public Set<String> getExistingFkTableNames() {
		return existingFkTableNames;
	}
}
