package fr.ifremer.common.synchro.dao;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.service.SynchroTableOperation;

import java.io.Closeable;

/**
 * <p>DaoFactory interface.</p>
 *
 */
public interface DaoFactory extends Closeable {
	/** Constant <code>DEFAULT_DAO_CACHE_SIZE=50</code> */
	public final static int DEFAULT_DAO_CACHE_SIZE = 50;
	/** Constant <code>DEFAULT_DAO_CACHE_DURATION_SECONDS=5 min</code> */
	public final static int DEFAULT_DAO_CACHE_DURATION_SECONDS = 5 * 60 /* 5min */;
	/** Constant <code>DEFAULT_STATEMENT_CACHE_SIZE=50</code> */
	public final static int DEFAULT_STATEMENT_CACHE_SIZE = 50;
	/** Constant <code>DEFAULT_STATEMENT_CACHE_DURATION_SECONDS=DEFAULT_DAO_CACHE_DURATION_SECONDS</code> */
	public final static int DEFAULT_STATEMENT_CACHE_DURATION_SECONDS = DEFAULT_DAO_CACHE_DURATION_SECONDS;
	/** Constant <code>DEFAULT_VALUE_CACHE_SIZE=1000</code> */
	public final static int DEFAULT_VALUE_CACHE_SIZE = 1000;
	/** Constant <code>DEFAULT_VALUE_CACHE_DURATION_SECONDS=1 min </code> */
	public final static int DEFAULT_VALUE_CACHE_DURATION_SECONDS = 60 /* 1 min */;

	/**
	 * <p>getSourceDao.</p>
	 *
	 * @param tableName a {@link java.lang.String} object.
	 * @return a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 */
	SynchroTableDao getSourceDao(String tableName);

	/**
	 * <p>getSourceDao.</p>
	 *
	 * @param table a {@link fr.ifremer.common.synchro.meta.SynchroTableMetadata} object.
	 * @return a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 */
	SynchroTableDao getSourceDao(SynchroTableMetadata table);


	/**
	 * <p>getTargetDao.</p>
	 *
	 * @param table a {@link fr.ifremer.common.synchro.meta.SynchroTableMetadata} object.
	 * @param sourceDao a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 * @param currentOperation a {@link fr.ifremer.common.synchro.service.SynchroTableOperation} object.
	 * @return a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 */
	SynchroTableDao getTargetDao(SynchroTableMetadata table,
			SynchroTableDao sourceDao, SynchroTableOperation currentOperation);

	/**
	 * <p>getTargetDao.</p>
	 *
	 * @param tableName a {@link java.lang.String} object.
	 * @param sourceDao a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 * @param currentOperation a {@link fr.ifremer.common.synchro.service.SynchroTableOperation} object.
	 * @return a {@link fr.ifremer.common.synchro.dao.SynchroTableDao} object.
	 */
	SynchroTableDao getTargetDao(String tableName, SynchroTableDao sourceDao, SynchroTableOperation currentOperation);

	/**
	 * <p>getDao.</p>
	 *
	 * @return a {@link fr.ifremer.common.synchro.dao.SynchroBaseDao} object.
	 */
	SynchroBaseDao getDao();
}
