package fr.ifremer.common.synchro.config;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: TuttiConfigurationOption.java 1441 2013-12-09 20:13:47Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/tutti/TuttiConfigurationOption.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.hibernate.dialect.HSQLDialect;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.version.Version;

import java.io.File;
import java.net.URL;
import java.util.Locale;

import static org.nuiton.i18n.I18n.n;

/**
 * All application configuration options.
 *
 * @author Benoit Lavenier (benoit.lavenier@e-is.pro)
 * @since 3.5.3
 */
public enum SynchroConfigurationOption implements ConfigOptionDef {

	// ------------------------------------------------------------------------//
	// -- READ-ONLY OPTIONS
	// ---------------------------------------------------//
	// ------------------------------------------------------------------------//

	BASEDIR("synchro.basedir", n("synchro.config.option.basedir.description"),
			"${user.home}/.synchro", File.class),

	DATA_DIRECTORY("synchro.data.directory",
			n("synchro.config.option.data.directory.description"),
			"${synchro.basedir}/data", File.class),

	I18N_DIRECTORY("synchro.i18n.directory",
			n("synchro.config.option.i18n.directory.description"),
			"${synchro.basedir}/i18n", File.class),

	TMP_DIRECTORY("synchro.tmp.directory",
			n("synchro.config.option.tmp.directory.description"),
			"${synchro.data.directory}/temp", File.class),

	DB_DIRECTORY("synchro.persistence.db.directory",
			n("synchro.config.option.persistence.db.directory.description"),
			"${synchro.data.directory}/db", File.class),

	DB_ATTACHMENT_DIRECTORY(
			"synchro.persistence.db.attachment.directory",
			n("synchro.config.option.persistence.db.attachment.directory.description"),
			"${synchro.data.directory}/meas_files", File.class),

	DB_CACHE_DIRECTORY(
			"synchro.persistence.db.cache.directory",
			n("synchro.config.option.persistence.db.cache.directory.description"),
			"${synchro.data.directory}/dbcache", File.class),

	DB_NAME("synchro.persistence.db.name",
			n("synchro.config.option.persistence.db.name.description"),
			"allegro", String.class),

	DB_HOST("synchro.persistence.db.host",
			n("synchro.config.option.persistence.db.host.description"), "",
			String.class),

	DB_PORT("synchro.persistence.db.port",
			n("synchro.config.option.persistence.db.port.description"), "",
			String.class),

	DB_VALIDATION_QUERY("synchro.persistence.db.validation-query",
			n("synchro.persistence.db.validation-query.description"),
			"SELECT COUNT(*) FROM STATUS", String.class),

	DB_COLUMN_ID("synchro.db.column.id",
			n("synchro.config.option.db.column.id.description"), "id",
			String.class),

	DB_COLUMN_UPDATE_DATE("synchro.db.column.updateDate",
			n("synchro.config.option.db.column.updateDate.description"),
			"update_date", String.class),

	DB_SEQUENCE_SUFFIX("synchro.db.sequence.suffix",
			n("synchro.config.option.db.sequence.suffix.description"), "_seq",
			String.class),

	DB_MAX_SQL_NAME_LENGTH("synchro.db.maxSqlNameLength",
			n("synchro.config.option.db.maxSqlNameLength.description"), "30",
			Integer.class),

	JDBC_USERNAME("synchro.persistence.jdbc.username",
			n("synchro.config.option.persistence.jdbc.username.description"),
			"sa", String.class),

	JDBC_PASSWORD("synchro.persistence.jdbc.password",
			n("synchro.config.option.persistence.jdbc.password.description"),
			"", String.class),

	JDBC_SCHEMA("synchro.persistence.jdbc.schema",
			n("synchro.config.option.persistence.jdbc.schema.description"),
			"PUBLIC", String.class),

	JDBC_CATALOG("synchro.persistence.jdbc.catalog",
			n("synchro.config.option.persistence.jdbc.catalog.description"),
			null, String.class),

	JDBC_URL(
			"synchro.persistence.jdbc.url",
			n("synchro.config.option.persistence.jdbc.url.description"),
			"jdbc:hsqldb:file:${synchro.persistence.db.directory}/${synchro.persistence.db.name}",
			String.class),

	JDBC_DRIVER("synchro.persistence.jdbc.driver",
			n("synchro.config.option.persistence.jdbc.driver.description"),
			"org.hsqldb.jdbcDriver", Class.class),

	HIBERNATE_DIALECT(
			"synchro.persistence.hibernate.dialect",
			n("synchro.config.option.persistence.hibernate.dialect.description"),
			HSQLDialect.class.getName(), Class.class),

	VERSION("synchro.persistence.version",
			n("synchro.config.option.persistence.version.description"), "3.6.3",
			Version.class),

	SITE_URL("synchro.site.url", n("synchro.config.option.site.url.description"),
			"http://www.ifremer.fr/sih-adagio", URL.class),

	ORGANIZATION_NAME("synchro.organizationName",
			n("synchro.config.option.organizationName.description"), "Ifremer",
			String.class),

	INCEPTION_YEAR("synchro.inceptionYear",
			n("synchro.config.option.inceptionYear.description"), "2011",
			Integer.class),

	// ------------------------------------------------------------------------//
	// -- DB use for IMPORT (READ-WRITE) OPTIONS
	// ------------------------------------------------------------------------//

	IMPORT_DB_NAME("synchro.import.db.name",
			n("synchro.config.option.import.db.name.description"),
			"allegro", String.class, false),

	IMPORT_DB_HOST("synchro.import.db.host",
			n("synchro.config.option.import.db.host.description"), "",
			String.class, false),

	IMPORT_DB_PORT("synchro.import.db.port",
			n("synchro.config.option.import.db.port.description"), "",
			String.class, false),

	IMPORT_JDBC_USERNAME("synchro.import.jdbc.username",
			n("synchro.config.option.import.jdbc.username.description"),
			"sa", String.class, false),

	IMPORT_JDBC_PASSWORD("synchro.import.jdbc.password",
			n("synchro.config.option.import.jdbc.password.description"),
			"", String.class, false),

	IMPORT_JDBC_SCHEMA("synchro.import.jdbc.schema",
			n("synchro.config.option.import.jdbc.schema.description"),
			null, String.class, false),

	IMPORT_JDBC_CATALOG("synchro.import.jdbc.catalog",
			n("synchro.config.option.import.jdbc.catalog.description"),
			null, String.class, false),

	IMPORT_JDBC_URL(
			"synchro.import.jdbc.url",
			n("synchro.config.option.import.jdbc.url.description"),
			"jdbc:hsqldb:file:${synchro.persistence.db.directory}/${synchro.import.db.name}",
			String.class, false),

	IMPORT_JDBC_DRIVER("synchro.import.jdbc.driver",
			n("synchro.config.option.import.jdbc.driver.description"),
			"org.hsqldb.jdbcDriver", Class.class, false),

	IMPORT_HIBERNATE_DIALECT(
			"synchro.import.hibernate.dialect",
			n("synchro.config.option.import.hibernate.dialect.description"),
			HSQLDialect.class.getName(), Class.class, false),

	IMPORT_JDBC_BATCH_SIZE(
			"synchro.import.jdbc.batch-size",
			n("synchro.config.option.import.jdbc.batch-size.description"),
			"1000", Integer.class, false),

	IMPORT_JDBC_FETCH_SIZE(
			"synchro.import.jdbc.fetch-size",
			n("synchro.config.option.import.jdbc.fetch-size.description"),
			"50", Integer.class, false),

	// ------------------------------------------------------------------------//
	// -- Client/Server (READ-WRITE) OPTIONS
	// ----------------------------------//
	// ------------------------------------------------------------------------//

	SERVER_PORT("synchro.server.port",
			n("synchro.config.option.server.port.description"), "8080",
			Integer.class, false),

	SERVER_SSL_KEYSTORE("synchro.server.ssl.keystore.file",
			n("synchro.config.option.server.ssl.keystore.file.description"),
			"my.keystore", File.class, false),

	// ------------------------------------------------------------------------//
	// -- READ-WRITE OPTIONS
	// --------------------------------------------------//
	// ------------------------------------------------------------------------//

	TEMP_QUERY_PARAMETER_USER_ID(
			"synchro.tempQueryParameter.userId.column",
			n("synchro.tempQueryParameter.userId.column.description"),
			"PERSON_FK", String.class, false),

	DB_BACKUP_DIRECTORY(
			"synchro.persistence.db.backup.directory",
			n("synchro.config.option.persistence.db.backup.directory.description"),
			"${synchro.data.directory}/dbbackup", File.class, false),

	I18N_LOCALE("synchro.i18n.locale",
			n("synchro.config.option.i18n.locale.description"), Locale.FRANCE
					.getCountry(), Locale.class, false),

	IMPORT_JDBC_BATCH_ENABLE(
			"synchro.jdbc.batch.enable",
			n("synchro.config.option.import.jdbc.batch.enable.description"),
			Boolean.TRUE.toString(), Boolean.class, false);

	/**
	 * Configuration key.
	 */
	private final String key;

	/**
	 * I18n key of option description
	 */
	private final String description;

	/**
	 * Type of option
	 */
	private final Class<?> type;

	/**
	 * Default value of option.
	 */
	private String defaultValue;

	/**
	 * Flag to not keep option value on disk
	 */
	private boolean isTransient;

	/**
	 * Flag to not allow option value modification
	 */
	private boolean isFinal;

	SynchroConfigurationOption(String key, String description,
			String defaultValue, Class<?> type, boolean isTransient) {
		this.key = key;
		this.description = description;
		this.defaultValue = defaultValue;
		this.type = type;
		this.isTransient = isTransient;
		this.isFinal = isTransient;
	}

	SynchroConfigurationOption(String key, String description,
			String defaultValue, Class<?> type) {
		this(key, description, defaultValue, type, true);
	}

	/** {@inheritDoc} */
	@Override
	public String getKey() {
		return key;
	}

	/** {@inheritDoc} */
	@Override
	public Class<?> getType() {
		return type;
	}

	/** {@inheritDoc} */
	@Override
	public String getDescription() {
		return description;
	}

	/** {@inheritDoc} */
	@Override
	public String getDefaultValue() {
		return defaultValue;
	}

	/** {@inheritDoc} */
	@Override
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	/** {@inheritDoc} */
	@Override
	public boolean isTransient() {
		return isTransient;
	}

	/** {@inheritDoc} */
	@Override
	public void setTransient(boolean newValue) {
		// not used
	}

	/** {@inheritDoc} */
	@Override
	public boolean isFinal() {
		return isFinal;
	}

	/** {@inheritDoc} */
	@Override
	public void setFinal(boolean newValue) {
		// not used
	}
}
