package fr.ifremer.common.synchro;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

/**
 * <p>SynchroTechnicalException class.</p>
 *
 */
public class SynchroTechnicalException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	/**
	 * <p>Constructor for SynchroTechnicalException.</p>
	 *
	 * @param message a {@link java.lang.String} object.
	 */
	public SynchroTechnicalException(String message) {
		super(message);
	}

	/**
	 * <p>Constructor for SynchroTechnicalException.</p>
	 *
	 * @param message a {@link java.lang.String} object.
	 * @param cause a {@link java.lang.Throwable} object.
	 */
	public SynchroTechnicalException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * <p>Constructor for SynchroTechnicalException.</p>
	 *
	 * @param cause a {@link java.lang.Throwable} object.
	 */
	public SynchroTechnicalException(Throwable cause) {
		super(cause);
	}
}
