/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service.referential;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.hibernate.TemporaryDataHelper;
import fr.ifremer.adagio.synchro.dao.administration.user.PersonSessionSynchroJdbcDao;
import fr.ifremer.adagio.synchro.dao.administration.user.PersonSessionSynchroJdbcDaoImpl;
import fr.ifremer.adagio.synchro.intercept.data.ObjectTypeHelper;
import fr.ifremer.adagio.synchro.meta.DatabaseColumns;
import fr.ifremer.adagio.synchro.meta.referential.ReferentialSynchroTables;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroContext;
import fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroService;
import fr.ifremer.common.synchro.SynchroTechnicalException;
import fr.ifremer.common.synchro.config.SynchroConfiguration;
import fr.ifremer.common.synchro.dao.DaoFactory;
import fr.ifremer.common.synchro.dao.Daos;
import fr.ifremer.common.synchro.dao.SynchroBaseDao;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.common.synchro.meta.SynchroMetadataUtils;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.service.SynchroContext;
import fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.service.SynchroResult;
import fr.ifremer.common.synchro.service.SynchroServiceImpl;
import fr.ifremer.common.synchro.service.SynchroTableOperation;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="referentialSynchroService2")
@Lazy
public class ReferentialSynchroServiceImpl
extends SynchroServiceImpl
implements ReferentialSynchroService {
    private static final Log log = LogFactory.getLog(ReferentialSynchroServiceImpl.class);
    private static boolean DISABLE_INTEGRITY_CONSTRAINTS = true;
    private static boolean ALLOW_MISSING_OPTIONAL_COLUMN = true;
    private static boolean ALLOW_ADDITIONAL_MANDATORY_COLUMN_IN_SOURCE_SCHEMA = true;
    private static boolean KEEP_WHERE_CLAUSE_ON_QUERIES_BY_FKS = true;
    private static final String TABLE_DELETED_ITEM_HISTORY = "DELETED_ITEM_HISTORY";
    private static final String TQP_DELETE_BY_COMPARISON_PREFIX = "DELETE#";
    private static final int TQP_DEFAULT_PERSON_ID = -1;
    private static int DAO_CACHE_SIZE = 2;
    @Resource
    private PersonSessionSynchroJdbcDao personSessionSynchroJdbcDao = null;

    @Autowired
    public ReferentialSynchroServiceImpl(DataSource dataSource, SynchroConfiguration config) {
        super(dataSource, config, DISABLE_INTEGRITY_CONSTRAINTS, ALLOW_MISSING_OPTIONAL_COLUMN, ALLOW_ADDITIONAL_MANDATORY_COLUMN_IN_SOURCE_SCHEMA, KEEP_WHERE_CLAUSE_ON_QUERIES_BY_FKS);
        this.setDaoCacheSize(DAO_CACHE_SIZE);
    }

    public ReferentialSynchroServiceImpl() {
        super(DISABLE_INTEGRITY_CONSTRAINTS, ALLOW_MISSING_OPTIONAL_COLUMN, ALLOW_ADDITIONAL_MANDATORY_COLUMN_IN_SOURCE_SCHEMA, KEEP_WHERE_CLAUSE_ON_QUERIES_BY_FKS);
        this.setDaoCacheSize(DAO_CACHE_SIZE);
        this.personSessionSynchroJdbcDao = new PersonSessionSynchroJdbcDaoImpl();
    }

    @Override
    public ReferentialSynchroContext createSynchroContext(File sourceDbDirectory, SynchroDirection direction, int userId, Timestamp lastSynchronizationDate, boolean enableDelete, boolean enableInsertUpdate) {
        SynchroContext delegate = super.createSynchroContext(sourceDbDirectory, ReferentialSynchroTables.getImportTablesIncludes());
        delegate.getTarget().putAllProperties((Map)AdagioConfiguration.getInstance().getConnectionProperties());
        ReferentialSynchroContext result = new ReferentialSynchroContext(delegate, direction, userId);
        result.setLastSynchronizationDate(lastSynchronizationDate);
        result.setEnableDelete(enableDelete);
        result.setEnableInsertOrUpdate(enableInsertUpdate);
        this.initContext(result);
        return result;
    }

    @Override
    public ReferentialSynchroContext createSynchroContext(Properties sourceConnectionProperties, SynchroDirection direction, int userId, Timestamp lastSynchronizationDate, boolean enableDelete, boolean enableInsertUpdate) {
        SynchroContext delegate = super.createSynchroContext(sourceConnectionProperties, ReferentialSynchroTables.getImportTablesIncludes());
        delegate.getTarget().putAllProperties((Map)AdagioConfiguration.getInstance().getConnectionProperties());
        ReferentialSynchroContext result = new ReferentialSynchroContext(delegate, direction, userId);
        result.setLastSynchronizationDate(lastSynchronizationDate);
        result.setEnableDelete(enableDelete);
        result.setEnableInsertOrUpdate(enableInsertUpdate);
        this.initContext(result);
        return result;
    }

    @Override
    public void prepare(SynchroContext synchroContext) {
        Preconditions.checkArgument((synchroContext != null && synchroContext instanceof ReferentialSynchroContext ? 1 : 0) != 0, (Object)String.format("The context must be a instance of %s", ReferentialSynchroContext.class.getName()));
        ReferentialSynchroContext referentialSynchroContext = (ReferentialSynchroContext)synchroContext;
        SynchroDirection direction = referentialSynchroContext.getDirection();
        SynchroResult result = referentialSynchroContext.getResult();
        SynchroDatabaseConfiguration target = synchroContext.getTarget();
        SynchroDatabaseConfiguration source = synchroContext.getSource();
        source.addColumnExclude("LOCATION_ASSOCIATION", "update_date");
        target.addColumnExclude("LOCATION_ASSOCIATION", "update_date");
        source.addColumnExclude("GEAR_ASSOCIATION", "update_date");
        target.addColumnExclude("GEAR_ASSOCIATION", "update_date");
        source.addColumnExclude("TAXON_GROUP_HISTORICAL_RECORD", "update_date");
        target.addColumnExclude("TAXON_GROUP_HISTORICAL_RECORD", "update_date");
        source.addColumnExclude("TAXON_GROUP_INFORMATION", "update_date");
        target.addColumnExclude("TAXON_GROUP_INFORMATION", "update_date");
        source.addColumnExclude("GEAR_CLASSIFICATION_ASSOCIATIO", "update_date");
        target.addColumnExclude("GEAR_CLASSIFICATION_ASSOCIATIO", "update_date");
        source.addColumnExclude("PERSON", "crypt_password");
        target.addColumnExclude("PERSON", "crypt_password");
        if (direction == SynchroDirection.IMPORT_SERVER2TEMP && referentialSynchroContext.getPersonSessionId() == null) {
            this.fillPersonSessionId(referentialSynchroContext, result);
            if (!result.isSuccess()) {
                return;
            }
        }
        super.prepare(synchroContext);
    }

    protected void prepareRootTable(DaoFactory sourceDaoFactory, DaoFactory targetDaoFactory, SynchroTableMetadata table, SynchroContext context, SynchroResult result) throws SQLException {
        ReferentialSynchroContext referentialContext = (ReferentialSynchroContext)context;
        if (referentialContext.isEnableInsertOrUpdate() && (referentialContext.isEnableDelete() || !TABLE_DELETED_ITEM_HISTORY.equalsIgnoreCase(table.getName()))) {
            super.prepareRootTable(sourceDaoFactory, targetDaoFactory, table, context, result);
        }
        if (referentialContext.isEnableDelete() && !TABLE_DELETED_ITEM_HISTORY.equalsIgnoreCase(table.getName())) {
            this.prepareRootTableDeletes(sourceDaoFactory, targetDaoFactory, table, context, result);
        }
    }

    @Override
    public void synchronize(SynchroContext context) {
        super.synchronize(context);
        SynchroResult result = context.getResult();
        if (result.isSuccess() && !result.getRejectedRows().isEmpty()) {
            log.warn((Object)I18n.t((String)"adagio.synchro.synchronizeReferential.rejects", (Object[])new Object[]{result.getRejectedRows().toString()}));
        }
    }

    @Override
    public boolean hasChangesOnVesselTables(SynchroResult result) {
        boolean hasVesselUpdate;
        Preconditions.checkNotNull((Object)result);
        boolean bl = hasVesselUpdate = result.getNbRows("VESSEL") > 0 || result.getNbRows("VESSEL_FEATURES") > 0 || result.getNbRows("VESSEL_OWNER") > 0 || result.getNbRows("PERSON_SESSION_VESSEL") > 0 || result.getNbRows("PERSON_SESSION_ITEM") > 0;
        if (hasVesselUpdate && log.isDebugEnabled()) {
            log.debug((Object)"Vessels data has been updated");
        }
        return hasVesselUpdate;
    }

    protected void initContext(SynchroContext context) {
        context.getTarget().setColumnUpdateDate(DatabaseColumns.UPDATE_DATE.name().toLowerCase());
        context.getSource().setColumnUpdateDate(DatabaseColumns.UPDATE_DATE.name().toLowerCase());
    }

    protected void prepareRootTableDeletes(DaoFactory sourceDaoFactory, DaoFactory targetDaoFactory, SynchroTableMetadata table, SynchroContext context, SynchroResult result) throws SQLException {
        String tableName = table.getName();
        Set<String> objectTypeFks = ObjectTypeHelper.getObjectTypeFromTableName(tableName, tableName);
        if (CollectionUtils.isEmpty(objectTypeFks)) {
            return;
        }
        SynchroTableDao dihSourceDao = sourceDaoFactory.getSourceDao(TABLE_DELETED_ITEM_HISTORY);
        ArrayList columnValues = Lists.newArrayListWithCapacity((int)objectTypeFks.size());
        for (String objectTypeFk : objectTypeFks) {
            columnValues.add(ImmutableList.of((Object)objectTypeFk));
        }
        Map<String, Object> bindings = this.createSelectBindingsForTable(context, TABLE_DELETED_ITEM_HISTORY);
        long count = dihSourceDao.countDataByFks((Set)ImmutableSet.of((Object)"OBJECT_TYPE_FK"), (List)columnValues, bindings);
        if (count > 0L) {
            result.addRows(tableName, (int)count);
        }
    }

    protected List<SynchroTableOperation> getRootOperations(DaoFactory sourceDaoFactory, DaoFactory targetDaoFactory, SynchroDatabaseMetadata dbMeta, SynchroContext context) throws SQLException {
        ArrayList result = Lists.newArrayList();
        ReferentialSynchroContext referentialContext = (ReferentialSynchroContext)context;
        if (referentialContext.isEnableInsertOrUpdate()) {
            List defaultOperations = super.getRootOperations(sourceDaoFactory, targetDaoFactory, dbMeta, context);
            result.addAll(defaultOperations);
        }
        if (referentialContext.isEnableDelete()) {
            Collection<SynchroTableOperation> deletedItemOperations = this.getRootDeleteOperations(sourceDaoFactory, targetDaoFactory, dbMeta, context);
            result.addAll(deletedItemOperations);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SynchroTableOperation> getRootDeleteOperations(DaoFactory sourceDaoFactory, DaoFactory targetDaoFactory, SynchroDatabaseMetadata dbMeta, SynchroContext context) throws SQLException {
        Preconditions.checkArgument((boolean)dbMeta.getConfiguration().isFullMetadataEnable());
        ArrayDeque result = Queues.newArrayDeque();
        SynchroTableDao dihSourceDao = sourceDaoFactory.getSourceDao(TABLE_DELETED_ITEM_HISTORY);
        Set includedReferentialTables = context.getTableNames();
        Map<String, Object> bindings = this.createSelectBindingsForTable(context, TABLE_DELETED_ITEM_HISTORY);
        ResultSet dihResultSet = null;
        ArrayList dihIdsToRemove = Lists.newArrayList();
        HashSet tableNamesWithDelete = Sets.newHashSet();
        boolean doDelete = !context.getTarget().isMirrorDatabase();
        SynchroTableOperation previousDeletedOperation = null;
        SynchroTableOperation previousDeletedChildrenOperation = null;
        try {
            log.debug((Object)I18n.t((String)"adagio.synchro.synchronizeReferential.deletedItems", (Object[])new Object[0]));
            dihResultSet = dihSourceDao.getData(bindings);
            while (dihResultSet.next()) {
                String objectType = dihResultSet.getString("OBJECT_TYPE_FK");
                String tableName = ObjectTypeHelper.getTableNameFromObjectType(objectType);
                boolean isReferentialTable = StringUtils.isNotBlank((CharSequence)tableName) && includedReferentialTables.contains(tableName.toUpperCase());
                if (!isReferentialTable) continue;
                SynchroTableDao targetDao = targetDaoFactory.getSourceDao(tableName);
                SynchroTableMetadata table = targetDao.getTable();
                String objectCode = dihResultSet.getString(DatabaseColumns.OBJECT_CODE.name());
                String objectId = dihResultSet.getString(DatabaseColumns.OBJECT_ID.name());
                String vesselCode = dihResultSet.getString(DatabaseColumns.VESSEL_FK.name());
                if (ReferentialSynchroTables.VESSEL.name().equalsIgnoreCase(tableName) && StringUtils.isBlank((CharSequence)objectCode) && StringUtils.isNotBlank((CharSequence)vesselCode)) {
                    objectCode = vesselCode;
                }
                if (StringUtils.isNotBlank((CharSequence)objectCode) || StringUtils.isNotBlank((CharSequence)objectId)) {
                    SynchroTableOperation operation;
                    if (!doDelete) continue;
                    List pk = StringUtils.isNotBlank((CharSequence)objectCode) && !table.isSimpleKey() ? SynchroTableMetadata.fromPkStr((String)objectCode) : (StringUtils.isNotBlank((CharSequence)objectCode) ? ImmutableList.of((Object)objectCode) : ImmutableList.of((Object)objectId));
                    boolean hasChildTables = table.hasChildJoins();
                    if (hasChildTables) {
                        SynchroTableOperation childrenOperation;
                        if (previousDeletedChildrenOperation == null || !previousDeletedChildrenOperation.getTableName().equalsIgnoreCase(tableName)) {
                            if (previousDeletedChildrenOperation != null) {
                                result.add(previousDeletedChildrenOperation);
                            }
                            previousDeletedChildrenOperation = childrenOperation = new SynchroTableOperation(tableName, context);
                        } else {
                            childrenOperation = previousDeletedChildrenOperation;
                        }
                        this.addChildrenToDelete(table, childrenOperation, (List<List<Object>>)ImmutableList.of((Object)pk), result, context);
                    }
                    if (previousDeletedOperation == null || !previousDeletedOperation.getTableName().equalsIgnoreCase(tableName)) {
                        if (previousDeletedOperation != null) {
                            result.add(previousDeletedOperation);
                        }
                        operation = new SynchroTableOperation(tableName, context);
                        operation.setEnableProgress(true);
                        previousDeletedOperation = operation;
                    } else {
                        operation = previousDeletedOperation;
                    }
                    operation.addMissingDelete(pk);
                    continue;
                }
                tableNamesWithDelete.add(tableName);
            }
            if (previousDeletedChildrenOperation != null) {
                result.add(previousDeletedChildrenOperation);
            }
            if (previousDeletedOperation != null) {
                result.add(previousDeletedOperation);
            }
        }
        catch (Throwable throwable) {
            Daos.closeSilently(dihResultSet);
            throw throwable;
        }
        Daos.closeSilently((ResultSet)dihResultSet);
        if (CollectionUtils.isNotEmpty((Collection)dihIdsToRemove)) {
            SynchroTableOperation operation = new SynchroTableOperation(TABLE_DELETED_ITEM_HISTORY, context);
            operation.addChildrenToDeleteFromOneColumn(TABLE_DELETED_ITEM_HISTORY, "remote_id", (List)dihIdsToRemove);
            result.add(operation);
        }
        if (CollectionUtils.isNotEmpty((Collection)tableNamesWithDelete)) {
            if (!doDelete) {
                this.saveTablesWithDelete(tableNamesWithDelete, sourceDaoFactory, targetDaoFactory, dbMeta, context);
            } else if (doDelete && context.getSource().isMirrorDatabase()) {
                this.addDeletedItemsFromTables(tableNamesWithDelete, result, sourceDaoFactory, targetDaoFactory, dbMeta, context);
            } else if (doDelete) {
                this.saveTablesWithDelete(tableNamesWithDelete, sourceDaoFactory, targetDaoFactory, dbMeta, context);
                this.addDeletedItemsFromTables(tableNamesWithDelete, result, targetDaoFactory, targetDaoFactory, dbMeta, context);
            }
        }
        return result;
    }

    protected final void addChildrenToDelete(SynchroTableMetadata parentTable, SynchroTableOperation childrenOperation, List<List<Object>> parentPks, Deque<SynchroTableOperation> pendingOperations, SynchroContext context) {
        Set pkNames = parentTable.getPkNames();
        if (pkNames.size() > 1) {
            throw new UnsupportedOperationException("Not sure of this implementation: please check before comment out this exception !");
        }
        for (SynchroJoinMetadata join : parentTable.getChildJoins()) {
            SynchroTableMetadata childTable = join.getTargetTable();
            SynchroColumnMetadata childTableColumn = join.getTargetColumn();
            childrenOperation.addChildrenToDeleteFromManyColumns(childTable.getName(), (Set)ImmutableSet.of((Object)childTableColumn.getName()), parentPks);
        }
    }

    protected void saveTablesWithDelete(Set<String> tableNames, DaoFactory sourceDaoFactory, DaoFactory targetDaoFactory, SynchroDatabaseMetadata dbMeta, SynchroContext context) throws SQLException {
        SynchroBaseDao targetBaseDao = targetDaoFactory.getDao();
        targetBaseDao.executeDeleteTempQueryParameter("DELETE#%", true, -1);
        for (String tableName : tableNames) {
            SynchroTableDao sourceDao = sourceDaoFactory.getSourceDao(tableName);
            Set pkStrs = sourceDao.getPksStr();
            targetBaseDao.executeInsertIntoTempQueryParameter((List)ImmutableList.copyOf((Collection)pkStrs), TQP_DELETE_BY_COMPARISON_PREFIX + tableName, -1);
        }
    }

    protected void addDeletedItemsFromTables(Set<String> tableNames, Deque<SynchroTableOperation> operations, DaoFactory sourceDaoFactory, DaoFactory targetDaoFactory, SynchroDatabaseMetadata dbMeta, SynchroContext context) throws SQLException {
        SynchroTableDao tqpDao = sourceDaoFactory.getSourceDao("TEMP_QUERY_PARAMETER");
        int tqpValueColumnIndex = tqpDao.getTable().getColumnIndex("ALPHANUMERICAL_VALUE");
        Preconditions.checkArgument((tqpValueColumnIndex != -1 ? 1 : 0) != 0);
        HashMap emptyBinding = Maps.newHashMap();
        ImmutableSet fkNames = ImmutableSet.of((Object)"PARAMETER_NAME");
        for (String tableName : tableNames) {
            SynchroTableMetadata table = dbMeta.getTable(tableName);
            boolean hasChildTables = table.hasChildJoins();
            Set tablePkNames = table.getPkNames();
            int pkCount = tablePkNames.size();
            ImmutableList fkValue = ImmutableList.of((Object)(TQP_DELETE_BY_COMPARISON_PREFIX + tableName));
            ResultSet rs = tqpDao.getDataByFks((Set)fkNames, (List)ImmutableList.of((Object)fkValue), (Map)emptyBinding);
            ArrayList pks = Lists.newArrayList();
            while (rs.next()) {
                String pkStr = rs.getString(tqpValueColumnIndex + 1);
                List pk = SynchroTableMetadata.fromPkStr((String)pkStr);
                if (pkCount != pk.size()) {
                    String expectedPkStrExample = Joiner.on((String)String.format(">%s<", "~~")).join((Iterable)tablePkNames);
                    throw new SynchroTechnicalException(String.format("Unable to import delete on %s: invalid PK found in the source database (in %s). Should have %s column (e.g. %s).", tableName, "TEMP_QUERY_PARAMETER", pkCount, expectedPkStrExample));
                }
                pks.add(pk);
            }
            rs.close();
            if (pks.size() == 0) {
                throw new SynchroTechnicalException(String.format("Unable to import delete on %s: No PK found in the source database (in %s). Unable to compare and find PKs to delete.", tableName, "TEMP_QUERY_PARAMETER"));
            }
            SynchroTableOperation operation = new SynchroTableOperation(tableName, context);
            operation.setEnableProgress(true);
            SynchroTableDao targetTableDao = targetDaoFactory.getTargetDao(tableName, null, operation);
            List<List<Object>> pksToDelete = targetTableDao.getPksByNotFoundFks(tablePkNames, (List)pks, (Map)emptyBinding);
            if (!CollectionUtils.isNotEmpty(pksToDelete = this.filterExcludeTemporary(table, pksToDelete))) continue;
            operation.addAllMissingDelete(pksToDelete);
            if (hasChildTables) {
                this.addDeleteChildrenToDeque(table, pksToDelete, operations, context);
            }
            operations.add(operation);
        }
        targetDaoFactory.getDao().executeDeleteTempQueryParameter("DELETE#%", true, -1);
    }

    protected List<List<Object>> filterExcludeTemporary(SynchroTableMetadata table, List<List<Object>> pks) {
        Set tablePkNames = table.getPkNames();
        if (tablePkNames.size() > 1) {
            return pks;
        }
        SynchroColumnMetadata pkColumn = table.getColumn((String)tablePkNames.iterator().next());
        Collection result = SynchroMetadataUtils.isNumericType((SynchroColumnMetadata)pkColumn) ? Collections2.filter(pks, (Predicate)new Predicate<List<Object>>(){

            public boolean apply(@Nullable List<Object> input) {
                long pk = Long.parseLong(input.get(0).toString());
                return !TemporaryDataHelper.isTemporaryId((Number)pk);
            }
        }) : Collections2.filter(pks, (Predicate)new Predicate<List<Object>>(){

            public boolean apply(@Nullable List<Object> input) {
                String pk = input.get(0).toString();
                return !TemporaryDataHelper.isTemporaryCode((String)pk);
            }
        });
        return ImmutableList.copyOf((Collection)result);
    }

    protected void fillPersonSessionId(ReferentialSynchroContext referentialSynchroContext, SynchroResult result) {
        Preconditions.checkNotNull((Object)referentialSynchroContext.getPersonId(), (Object)"One of 'personId' or 'personSessionId' must be set in the synchro context");
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.synchro.synchronizeData.initPersonSession", (Object[])new Object[0]));
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"adagio.synchro.synchronizeData.initPersonSession.log", (Object[])new Object[]{referentialSynchroContext.getPersonId()}));
        }
        try {
            int personSessionId = this.personSessionSynchroJdbcDao.initPersonSession(referentialSynchroContext.getSource().getConnectionProperties(), referentialSynchroContext.getPersonId());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Session initialized: id=%s", personSessionId));
            }
            referentialSynchroContext.setPersonSessionId(personSessionId);
        }
        catch (AdagioTechnicalException e) {
            result.setError((Exception)((Object)e));
        }
    }

    protected Map<String, Object> createSelectBindingsForTable(SynchroContext context, String tableName) {
        Map result = super.createSelectBindingsForTable(context, tableName);
        ReferentialSynchroContext referentialSynchroContext = (ReferentialSynchroContext)context;
        if (CollectionUtils.isNotEmpty(referentialSynchroContext.getTableNamesForced()) && referentialSynchroContext.getTableNamesForced().contains(tableName.toUpperCase())) {
            log.debug((Object)String.format("[%s] Forced synchronization (last synchronization date ignored)", tableName));
            result.remove("updateDate");
        }
        return result;
    }
}

