/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.technical.hibernate.ConfigurationHelper;
import fr.ifremer.adagio.synchro.service.AbstractSynchroDatabaseConfiguration;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroContext;
import fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration;
import java.util.Date;
import java.util.Properties;
import java.util.Set;

public class DataSynchroDatabaseConfiguration
extends AbstractSynchroDatabaseConfiguration {
    public static String IS_TEMPORARY_DATABASE = "adagio.synchro.database.isTemporary";
    public static String COLUMN_REMOTE_ID = "synchro.database.column.remoteId";
    public static String COLUMN_SYNCHRONIZATION_STATUS = "synchro.database.column.synchronizationStatus";
    private DataSynchroContext context;
    private String columnRemoteId;
    private String columnSynchronizationStatus;

    public DataSynchroDatabaseConfiguration(DataSynchroContext context, SynchroDatabaseConfiguration otherBean) {
        this.copy(otherBean);
        Preconditions.checkNotNull((Object)((Object)context));
        this.context = context;
    }

    public DataSynchroDatabaseConfiguration(DataSynchroContext context, Properties settings, boolean isTarget) {
        super(settings, isTarget);
        Preconditions.checkNotNull((Object)((Object)context));
        this.context = context;
    }

    public DataSynchroDatabaseConfiguration(Properties settings, boolean isTarget) {
        super(settings, isTarget);
        this.context = null;
    }

    protected void reloadCachedFields() {
        super.reloadCachedFields();
        this.columnRemoteId = ConfigurationHelper.getString((String)COLUMN_REMOTE_ID, (Properties)this.getProperties(), (String)"remote_id");
        this.columnSynchronizationStatus = ConfigurationHelper.getString((String)COLUMN_SYNCHRONIZATION_STATUS, (Properties)this.getProperties(), (String)"synchronization_status");
    }

    public String getColumnRemoteId() {
        return this.columnRemoteId;
    }

    public SynchroDatabaseConfiguration setColumnRemoteId(String columnName) {
        this.columnRemoteId = columnName;
        this.setProperty(COLUMN_REMOTE_ID, columnName);
        return this;
    }

    public String getColumnSynchronizationStatus() {
        return this.columnSynchronizationStatus;
    }

    public SynchroDatabaseConfiguration setColumnSynchronizationStatus(String columnName) {
        this.columnSynchronizationStatus = columnName;
        this.setProperty(COLUMN_SYNCHRONIZATION_STATUS, columnName);
        return this;
    }

    @Override
    public Integer getPersonSessionId() {
        return this.context == null ? null : this.context.getPersonSessionId();
    }

    @Override
    public Integer getPersonId() {
        return this.context == null ? null : this.context.getPersonId();
    }

    public void setIsTemporary(boolean isTemporayDatabase) {
        this.setProperty(IS_TEMPORARY_DATABASE, String.valueOf(isTemporayDatabase));
    }

    public Date getDataStartDate() {
        return this.context == null ? null : this.context.getDataStartDate();
    }

    public Date getDataEndDate() {
        return this.context == null ? null : this.context.getDataEndDate();
    }

    public Multimap<String, String> getPkIncludes() {
        return this.context == null ? null : this.context.getPkIncludes();
    }

    @Override
    public SynchroDirection getDirection() {
        return this.context == null ? null : this.context.getDirection();
    }

    public Set<String> getProgramCodes() {
        return this.context == null ? null : this.context.getProgramCodes();
    }

    public boolean isIntegrityConstraintEnable() {
        return !this.isMirrorDatabase();
    }

    public boolean isForceEditedRowOverride() {
        return this.context == null ? null : Boolean.valueOf(this.context.isForceEditedRowOverride());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n    direction : ").append(this.getDirection() == null ? "" : this.getDirection().name());
        sb.append("\n    person id: ").append(this.getPersonId() == null ? "" : this.getPersonId());
        sb.append("\n    person session id: ").append(this.getPersonSessionId() == null ? "" : this.getPersonSessionId());
        sb.append("\n    start date: ").append(this.getDataStartDate());
        sb.append("\n    end date: ").append(this.getDataEndDate());
        sb.append("\n    program codes: ").append(this.getProgramCodes());
        sb.append("\n    user: ").append(this.getPersonId());
        return sb.toString();
    }

    public void copy(SynchroDatabaseConfiguration otherBean) {
        super.copy(otherBean);
        if (otherBean instanceof DataSynchroDatabaseConfiguration) {
            this.context = ((DataSynchroDatabaseConfiguration)otherBean).context;
        }
    }
}

