/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.referential;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.referential.AbstractReferentialInterceptor;
import fr.ifremer.adagio.synchro.meta.referential.ReferentialSynchroTables;
import fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.LoadJoinEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReferentialTableInterceptor
extends AbstractReferentialInterceptor {
    private static final Log log = LogFactory.getLog(ReferentialTableInterceptor.class);
    protected static Multimap<String, String> childJoinIncludes = ReferentialTableInterceptor.initChildJoinIncludes();
    protected static Multimap<String, String> childJoinExcludes = ReferentialTableInterceptor.initChildJoinExcludes();
    private Timestamp systimestamp = null;

    public ReferentialTableInterceptor() {
        super(ReferentialSynchroTables.getImportTablesIncludes());
    }

    @Override
    public SynchroInterceptorBase clone() {
        ReferentialTableInterceptor result = (ReferentialTableInterceptor)super.clone();
        result.systimestamp = this.systimestamp;
        return result;
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        boolean isRoot;
        SynchroTableMetadata table = e.table;
        String tableName = table.getName();
        boolean hasUpdateDate = this.hasColumns(table, new String[]{((ReferentialSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnUpdateDate()});
        boolean ignoreUpdateDateColumn = "PERSON_SESSION_VESSEL".equals(tableName) || "PERSON_SESSION_ITEM".equals(tableName);
        boolean bl = isRoot = hasUpdateDate && !ignoreUpdateDateColumn;
        if (!table.isRoot() && isRoot) {
            table.setRoot(true);
            return;
        }
        if (ReferentialSynchroTables.STATUS.name().equalsIgnoreCase(table.getName())) {
            table.setRoot(true);
        }
    }

    @Subscribe
    public void handleJoinLoad(LoadJoinEvent e) {
        boolean ignoreFkTableUpdateDateColumn;
        SynchroJoinMetadata join = e.join;
        String fkTableName = join.getFkTable().getName().toUpperCase();
        String fkColumnName = join.getFkColumn().getName().toUpperCase();
        boolean bl = ignoreFkTableUpdateDateColumn = "PERSON_SESSION_VESSEL".equals(fkTableName) || "PERSON_SESSION_ITEM".equals(fkTableName);
        if (join.isChild() && this.hasColumns(join.getFkTable(), new String[]{((ReferentialSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnUpdateDate()}) && !ignoreFkTableUpdateDateColumn) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Disabling %s: child table is a root table", join.toString()));
            }
            join.setIsValid(false);
            return;
        }
        if (join.getFkTable() == join.getPkTable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Disabling %s: recursive link", join.toString()));
            }
            join.setIsValid(false);
            return;
        }
        if (join.isChild()) {
            boolean isColumnExclude;
            Collection columnIncludes = childJoinIncludes.get((Object)fkTableName);
            boolean isColumnInclude = CollectionUtils.isNotEmpty((Collection)columnIncludes) && columnIncludes.contains(fkColumnName);
            Collection columnExcludes = childJoinExcludes.get((Object)fkTableName);
            boolean bl2 = isColumnExclude = CollectionUtils.isNotEmpty((Collection)columnExcludes) && columnExcludes.contains(fkColumnName);
            if (!isColumnInclude || isColumnExclude) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Disabling %s: include=%s, exclude=%s", join.toString(), isColumnInclude, isColumnExclude));
                }
                join.setIsValid(false);
            }
        }
    }

    protected static Multimap<String, String> initChildJoinIncludes() {
        ArrayListMultimap result = ArrayListMultimap.create();
        result.put((Object)"APPLIED_STRATEGY", (Object)"STRATEGY_FK");
        result.put((Object)"APPLIED_PERIOD", (Object)"APPLIED_STRATEGY_FK");
        result.put((Object)"DEPARTMENT_HIERARCHY", (Object)"PARENT_DEPARTMENT_FK");
        result.put((Object)"FRACTION2MATRIX", (Object)"FRACTION_FK");
        result.put((Object)"GROUPING_ITEM", (Object)"GROUPING_FK");
        result.put((Object)"GROUPING_ITEM_HIERARCHY", (Object)"GROUPING_FK");
        result.put((Object)"GROUPING_VESSEL_HIERARCHY", (Object)"GROUPING_FK");
        result.put((Object)"LOCATION_ASSOCIATION", (Object)"PARENT_LOCATION_FK");
        result.put((Object)"GEAR_ASSOCIATION", (Object)"FROM_GEAR_FK");
        result.put((Object)"LOCATION_HIERARCHY", (Object)"PARENT_LOCATION_FK");
        result.put((Object)"LOCATION_HIERARCHY_EXCEPTION", (Object)"PARENT_LOCATION_FK");
        result.put((Object)"LOCATION_HIERARCHY_OVERRIDE", (Object)"PARENT_LOCATION_FK");
        result.put((Object)"QUALITATIVE_VALUE", (Object)"PARAMETER_FK");
        result.put((Object)"PERSON2USER_PROFIL", (Object)"PERSON_FK");
        result.put((Object)"PROGRAM2DEPARTMENT", (Object)"PROGRAM_FK");
        result.put((Object)"PROGRAM2LOCATION", (Object)"PROGRAM_FK");
        result.put((Object)"PROGRAM2LOCATION_CLASSIF", (Object)"PROGRAM_FK");
        result.put((Object)"PROGRAM2PERSON", (Object)"PROGRAM_FK");
        result.put((Object)"PROGRAM2PERSON_EXCEPTION", (Object)"PROGRAM2PERSON_FK");
        result.put((Object)"PMFM_STRATEGY", (Object)"STRATEGY_FK");
        result.put((Object)"PMFM_APPLIED_STRATEGY", (Object)"APPLIED_STRATEGY_FK");
        result.put((Object)"PMFM2QUALITATIVE_VALUE", (Object)"PMFM_FK");
        result.put((Object)"REFERENCE_DOCUMENT2AUTHOR", (Object)"REFERENCE_DOCUMENT_FK");
        result.put((Object)"REFERENCE_TAXON_STRATEGY", (Object)"STRATEGY_FK");
        result.put((Object)"STRATEGY2GEAR", (Object)"STRATEGY_FK");
        result.put((Object)"STRATEGY2MANAGER_PERSON", (Object)"STRATEGY_FK");
        result.put((Object)"SPATIAL_ITEM2LOCATION", (Object)"SPATIAL_ITEM_FK");
        result.put((Object)"SPATIAL_ITEM2LOCATION", (Object)"LOCATION_FK");
        result.put((Object)"TAXON_GROUP2TAXON_HIERARCHY", (Object)"TAXON_GROUP_FK");
        result.put((Object)"TAXON_GROUP_HIERARCHY", (Object)"CHILD_TAXON_GROUP_FK");
        result.put((Object)"VESSEL_REGISTRATION_PERIOD", (Object)"VESSEL_FK");
        result.put((Object)"VESSEL_OWNER_PERIOD", (Object)"VESSEL_FK");
        result.put((Object)"TAXON_INFORMATION_HISTORY", (Object)"DOCUMENT_REFERENCE_FK");
        result.put((Object)"TAXON_GROUP_HISTORICAL_RECORD", (Object)"TAXON_GROUP_FK");
        result.put((Object)"TAXON_GROUP_INFORMATION", (Object)"TAXON_GROUP_FK");
        result.put((Object)"GEAR_CLASSIFICATION_ASSOCIATIO", (Object)"FROM_GEAR_CLASSIFICATION_FK");
        result.put((Object)"PERSON_SESSION_VESSEL", (Object)"PERSON_SESSION_FK");
        result.put((Object)"PERSON_SESSION_ITEM", (Object)"PERSON_SESSION_FK");
        return result;
    }

    protected static Multimap<String, String> initChildJoinExcludes() {
        ArrayListMultimap result = ArrayListMultimap.create();
        result.put((Object)"TAXON_GROUP", (Object)"PARENT_TAXON_GROUP_FK");
        result.put((Object)"DEPARTMENT", (Object)"PARENT_DEPARTMENT_FK");
        return result;
    }
}

