/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.referential;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.referential.AbstractReferentialInterceptor;
import fr.ifremer.adagio.synchro.meta.DatabaseColumns;
import fr.ifremer.adagio.synchro.meta.referential.ReferentialSynchroTables;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import java.util.List;

public class PersonSessionItemInterceptor
extends AbstractReferentialInterceptor {
    public static final List<String> NATURAL_ID_COLUMN_NAMES = ImmutableList.of((Object)DatabaseColumns.PERSON_SESSION_FK.name(), (Object)DatabaseColumns.PROGRAM_FK.name(), (Object)DatabaseColumns.OBJECT_TYPE_FK.name(), (Object)DatabaseColumns.OBJECT_ID.name());

    public PersonSessionItemInterceptor() {
        super(ReferentialSynchroTables.PERSON_SESSION_ITEM.name(), SynchroDirection.IMPORT_SERVER2TEMP, SynchroDirection.IMPORT_NO_TEMP, SynchroDirection.IMPORT_TEMP2LOCAL);
    }

    @Subscribe
    public void handleCreateQuery(CreateQueryEvent e) {
        SynchroDirection direction = ((ReferentialSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection();
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case select: 
            case selectFromUpdateDate: 
            case selectMaxUpdateDate: {
                if (direction != SynchroDirection.IMPORT_SERVER2TEMP && direction != SynchroDirection.IMPORT_NO_TEMP) break;
                int personSessionId = this.checkAndGetPersonSessionId();
                e.sql = SynchroQueryBuilder.newBuilder((String)e.sql).addWhere(SynchroQueryOperator.AND, "t.person_session_fk", String.valueOf(personSessionId)).build();
                break;
            }
        }
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        SynchroTableMetadata table = e.table;
        if (((ReferentialSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.IMPORT_TEMP2LOCAL) {
            table.addUniqueConstraint("NATURAL_ID_UNIQUE_C", NATURAL_ID_COLUMN_NAMES, SynchroTableMetadata.DuplicateKeyStrategy.REPLACE);
        }
    }
}

