/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.referential;

import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.referential.AbstractReferentialInterceptor;
import fr.ifremer.adagio.synchro.meta.referential.ReferentialSynchroTables;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;

public class PersonSessionInterceptor
extends AbstractReferentialInterceptor {
    public PersonSessionInterceptor() {
        super(ReferentialSynchroTables.PERSON_SESSION.name(), SynchroDirection.IMPORT_SERVER2TEMP, SynchroDirection.IMPORT_TEMP2LOCAL, SynchroDirection.IMPORT_NO_TEMP);
    }

    @Subscribe
    public void handleLoadTable(LoadTableEvent e) {
        e.table.setRoot(true);
    }

    @Subscribe
    public void handleCreateQuery(CreateQueryEvent e) {
        SynchroDirection direction = ((ReferentialSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection();
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case select: 
            case selectFromUpdateDate: 
            case selectMaxUpdateDate: {
                if (direction != SynchroDirection.IMPORT_SERVER2TEMP && direction != SynchroDirection.IMPORT_NO_TEMP) break;
                int personSessionId = this.checkAndGetPersonSessionId();
                e.sql = SynchroQueryBuilder.newBuilder((String)e.sql).addWhere(SynchroQueryOperator.AND, "t.id", String.valueOf(personSessionId)).build();
                break;
            }
        }
    }
}

