/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.referential;

import fr.ifremer.adagio.synchro.intercept.referential.AbstractReferentialInterceptor;
import fr.ifremer.common.synchro.dao.SynchroBaseDao;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class LocationInterceptor
extends AbstractReferentialInterceptor {
    public static final String TABLE_LOCATION_ASSOCIATION = "LOCATION_ASSOCIATION";
    public static final String TABLE_LOCATION_HIERARCHY = "LOCATION_HIERARCHY";
    public static final String COLUMN_CHILD_LOCATION_FK = "child_location_fk";
    private PreparedStatement deleteLocationHierarchty = null;
    private PreparedStatement deleteLocationAssociation = null;

    public LocationInterceptor() {
        this.setEnableOnWrite(true);
    }

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return "LOCATION".equalsIgnoreCase(table.getName());
    }

    protected void doOnDelete(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
        Object pkObj = pk.get(0);
        this.deleteLocationHierarchy((SynchroBaseDao)targetDao, pkObj);
        this.deleteLocationAssociation((SynchroBaseDao)targetDao, pkObj);
    }

    protected void deleteLocationHierarchy(SynchroBaseDao targetDao, Object vesselPk) throws SQLException {
        if (this.deleteLocationHierarchty == null || this.deleteLocationHierarchty.isClosed()) {
            this.deleteLocationHierarchty = targetDao.getPreparedStatement(this.getDeleteLocationHierarchyQuery());
        }
        this.deleteLocationHierarchty.setObject(1, vesselPk);
        this.deleteLocationHierarchty.executeUpdate();
    }

    protected void deleteLocationAssociation(SynchroBaseDao targetDao, Object vesselPk) throws SQLException {
        if (this.deleteLocationAssociation == null || this.deleteLocationAssociation.isClosed()) {
            this.deleteLocationAssociation = targetDao.getPreparedStatement(this.getDeleteLocationAssocationQuery());
        }
        this.deleteLocationAssociation.setObject(1, vesselPk);
        this.deleteLocationAssociation.executeUpdate();
    }

    protected String getDeleteLocationHierarchyQuery() {
        return String.format("DELETE FROM %s WHERE %s = ?", TABLE_LOCATION_HIERARCHY, COLUMN_CHILD_LOCATION_FK);
    }

    protected String getDeleteLocationAssocationQuery() {
        return String.format("DELETE FROM %s WHERE %s = ?", TABLE_LOCATION_ASSOCIATION, COLUMN_CHILD_LOCATION_FK);
    }
}

