/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.referential;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.ObjectTypeHelper;
import fr.ifremer.adagio.synchro.intercept.referential.AbstractReferentialInterceptor;
import fr.ifremer.adagio.synchro.meta.DatabaseColumns;
import fr.ifremer.adagio.synchro.meta.referential.ReferentialSynchroTables;
import fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class DeletedItemHistoryInterceptor
extends AbstractReferentialInterceptor {
    private String whereClauseOnTableIncludes = null;

    public DeletedItemHistoryInterceptor() {
        super(ReferentialSynchroTables.DELETED_ITEM_HISTORY.name());
    }

    @Override
    public SynchroInterceptorBase clone() {
        DeletedItemHistoryInterceptor newBean = (DeletedItemHistoryInterceptor)super.clone();
        newBean.whereClauseOnTableIncludes = this.whereClauseOnTableIncludes;
        return newBean;
    }

    @Override
    protected void init(ReferentialSynchroDatabaseConfiguration config) {
        this.whereClauseOnTableIncludes = this.createWhereClauseOnTableIncludes();
    }

    @Subscribe
    public void handleCreateQuery(CreateQueryEvent e) {
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case selectMaxUpdateDate: {
                e.sql = SynchroQueryBuilder.newBuilder((String)e.sql).addWhere(SynchroQueryOperator.AND, this.whereClauseOnTableIncludes).build();
                break;
            }
            case select: 
            case selectFromUpdateDate: {
                e.sql = SynchroQueryBuilder.newBuilder((String)e.sql).addWhere(SynchroQueryOperator.AND, this.whereClauseOnTableIncludes).addOrderByColumn("t." + (Object)((Object)DatabaseColumns.UPDATE_DATE), true).build();
                break;
            }
        }
    }

    private String addRestrictions(String sql) {
        SynchroQueryBuilder query = SynchroQueryBuilder.newBuilder((String)sql);
        query.addWhere(SynchroQueryOperator.AND, this.whereClauseOnTableIncludes);
        return query.build();
    }

    private String createWhereClauseOnTableIncludes() {
        Set<String> tableToIncludes = ReferentialSynchroTables.getImportTablesIncludes();
        if (CollectionUtils.isEmpty(tableToIncludes)) {
            return "1=2";
        }
        HashSet allObjectTypes = Sets.newHashSet();
        for (String tableName : tableToIncludes) {
            Set<String> objectTypes = ObjectTypeHelper.getObjectTypeFromTableName(tableName);
            if (CollectionUtils.isNotEmpty(objectTypes)) {
                allObjectTypes.addAll(objectTypes);
                continue;
            }
            allObjectTypes.add(tableName);
        }
        allObjectTypes.remove(ReferentialSynchroTables.DELETED_ITEM_HISTORY.name());
        allObjectTypes.remove(ReferentialSynchroTables.PERSON_SESSION_VESSEL.name());
        allObjectTypes.remove(ReferentialSynchroTables.PERSON_SESSION_ITEM.name());
        return "OBJECT_TYPE_FK IN ('" + Joiner.on((String)"','").join((Iterable)allObjectTypes) + "')";
    }
}

