/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data.internal;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import java.sql.SQLException;
import java.util.List;

public class ExportRemoveNegativeValueInterceptor
extends SynchroInterceptorBase {
    private final String tableName;
    private final int columnIndex;
    private final DataSynchroDatabaseConfiguration config;

    public ExportRemoveNegativeValueInterceptor(DataSynchroDatabaseConfiguration config, String tableName, int columnIndex) {
        Preconditions.checkArgument((columnIndex >= 0 ? 1 : 0) != 0);
        this.tableName = tableName;
        this.config = config;
        this.columnIndex = columnIndex;
        this.setEnableOnWrite(true);
        this.setEnableOnRead(true);
    }

    public SynchroInterceptorBase clone() {
        return new ExportRemoveNegativeValueInterceptor(this.config, this.tableName, this.columnIndex);
    }

    protected void doOnWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository operationContext, boolean insert) throws SQLException {
        if (data[this.columnIndex] == null) {
            return;
        }
        long value = Long.parseLong(data[this.columnIndex].toString());
        if (value < 0L) {
            data[this.columnIndex] = null;
        }
    }

    protected void doOnRead(Object[] data, SynchroTableDao sourceDao, SynchroTableDao targetDao) throws SQLException {
        if (data[this.columnIndex] == null) {
            return;
        }
        long value = Long.parseLong(data[this.columnIndex].toString());
        if (value < 0L) {
            data[this.columnIndex] = null;
        }
    }
}

