/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data.internal;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.SynchroTechnicalException;
import fr.ifremer.common.synchro.dao.Daos;
import fr.ifremer.common.synchro.dao.SynchroBaseDao;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.nuiton.i18n.I18n;

public class ExportFkRemoteIdInterceptor
extends SynchroInterceptorBase {
    private final String tableName;
    private final String columnName;
    private final int columnIndex;
    private final boolean isNullable;
    private final String selectRemoteIdFromIdQuery;
    private final DataSynchroDatabaseConfiguration config;
    private PreparedStatement selectRemoteIdFromIdStatement = null;

    public ExportFkRemoteIdInterceptor(DataSynchroDatabaseConfiguration config, String tableName, String columnName, int columnIndex, boolean isNullable) {
        Preconditions.checkArgument((columnIndex >= 0 ? 1 : 0) != 0);
        this.config = config;
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnIndex = columnIndex;
        this.isNullable = isNullable;
        this.selectRemoteIdFromIdQuery = this.initSelectRemoteIdFromIdQuery(config, tableName);
        this.setEnableOnWrite(true);
        this.setEnableOnRead(true);
    }

    public SynchroInterceptorBase clone() {
        return new ExportFkRemoteIdInterceptor(this.config, this.tableName, this.columnName, this.columnIndex, this.isNullable);
    }

    protected void doOnWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository operationContext, boolean insert) throws SQLException {
        if (data[this.columnIndex] == null) {
            return;
        }
        long localId = Long.parseLong(data[this.columnIndex].toString());
        Number remoteId = this.getRemoteIdFromId((SynchroBaseDao)sourceDao, localId);
        if (remoteId == null) {
            if (!this.isNullable) {
                throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.synchronizeData.noRemoteIdFromId.error", (Object[])new Object[]{this.config.getColumnRemoteId(), this.tableName.toUpperCase(), this.config.getColumnId(), localId}));
            }
            operationContext.addMissingColumnUpdate(this.columnName, pk, (Object)localId);
            data[this.columnIndex] = null;
        } else {
            data[this.columnIndex] = remoteId;
        }
    }

    protected void doOnRead(Object[] data, SynchroTableDao sourceDao, SynchroTableDao targetDao) throws SQLException {
        if (data[this.columnIndex] == null) {
            return;
        }
        long localId = Long.parseLong(data[this.columnIndex].toString());
        Number remoteId = this.getRemoteIdFromId((SynchroBaseDao)sourceDao, localId);
        if (remoteId == null) {
            data[this.columnIndex] = null;
            return;
        }
        data[this.columnIndex] = remoteId;
    }

    protected Number getRemoteIdFromId(SynchroBaseDao dao, long localId) throws SQLException {
        Number result = (Number)dao.getUniqueTyped(this.selectRemoteIdFromIdQuery, new Object[]{localId});
        return result;
    }

    protected void doClose() throws IOException {
        super.doClose();
        Daos.closeSilently((Statement)this.selectRemoteIdFromIdStatement);
        this.selectRemoteIdFromIdStatement = null;
    }

    protected String initSelectRemoteIdFromIdQuery(DataSynchroDatabaseConfiguration config, String tableName) {
        return String.format("SELECT %s FROM %s where %s=?", config.getColumnRemoteId(), tableName, config.getColumnId());
    }

    public boolean equals(Object obj) {
        if (obj.getClass().isAssignableFrom(ExportFkRemoteIdInterceptor.class)) {
            ExportFkRemoteIdInterceptor exportInterceptor = (ExportFkRemoteIdInterceptor)((Object)obj);
            if (exportInterceptor.getTableName() == null || exportInterceptor.getColumnName() == null || this.tableName == null || this.columnName == null) {
                return false;
            }
            if (exportInterceptor.getTableName().equalsIgnoreCase(this.tableName) && exportInterceptor.getColumnName().equalsIgnoreCase(this.columnName)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.tableName != null ? this.tableName.hashCode() : 0);
        hash = 79 * hash + (this.columnName != null ? this.columnName.hashCode() : 0);
        return hash;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

