/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import java.util.List;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class VesselPersonFeaturesInterceptor
extends AbstractDataInterceptor {
    private static final String UNIQUE_KEY_NAME = "VESSEL_PERSON_FEATU_UNIQUE_KEY";
    private static final List<String> UNIQUE_KEY_COLS = ImmutableList.of((Object)"VESSEL_FK", (Object)"PROGRAM_FK", (Object)"RANK_ORDER", (Object)"START_DATE");

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return "VESSEL_PERSON_FEATURES".equalsIgnoreCase(table.getName());
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_TEMP2SERVER) {
            e.table.addUniqueConstraint(UNIQUE_KEY_NAME, UNIQUE_KEY_COLS, SynchroTableMetadata.DuplicateKeyStrategy.REPLACE);
        }
    }
}

