/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.internal.ExportUpdateDateInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.intercept.SynchroInterceptor;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class TableWithUpdateDateInterceptor
extends AbstractDataInterceptor {
    private static final Log log = LogFactory.getLog(TableWithUpdateDateInterceptor.class);
    private Timestamp systimestamp = null;

    public TableWithUpdateDateInterceptor() {
        super(SynchroDirection.EXPORT_TEMP2SERVER);
    }

    @Override
    public SynchroInterceptorBase clone() {
        TableWithUpdateDateInterceptor result = (TableWithUpdateDateInterceptor)super.clone();
        result.systimestamp = this.systimestamp;
        return result;
    }

    @Override
    public boolean doApply(SynchroDatabaseMetadata dbMeta, TableMetadata table) {
        return this.hasColumns(table, new String[]{((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnUpdateDate()}) && !this.hasColumns(table, new String[]{((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId(), ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId()});
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        int updateDateColumnIndex;
        if (this.systimestamp == null) {
            this.systimestamp = this.checkAndGetSystemTimestamp((SynchroDatabaseConfiguration)this.getConfig());
        }
        if ((updateDateColumnIndex = e.table.getSelectColumnIndex(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnUpdateDate())) <= 0) {
            log.warn((Object)String.format("Unable to find %s column in the select query. %s will be ignore.", ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnUpdateDate(), ((Object)((Object)this)).getClass().getSimpleName()));
        } else {
            ExportUpdateDateInterceptor setUpdateDateInterceptor = new ExportUpdateDateInterceptor(updateDateColumnIndex, this.systimestamp);
            e.table.addInterceptor((SynchroInterceptor)setUpdateDateInterceptor);
        }
    }

    protected Timestamp checkAndGetSystemTimestamp(SynchroDatabaseConfiguration configuration) {
        Timestamp systimestamp = configuration.getSystemTimestamp();
        Preconditions.checkNotNull((Object)systimestamp, (Object)String.format("Could not found system timestamp in database configuration. This is need for %s", ((Object)((Object)this)).getClass().getSimpleName()));
        return systimestamp;
    }
}

