/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.ObjectTypeHelper;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryName;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class ScientificCruiseInterceptor
extends AbstractDataInterceptor {
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_SYNCHRONIZATION_STATUS = "synchronization_status";
    private static final String TABLE = "SCIENTIFIC_CRUISE";

    public ScientificCruiseInterceptor() {
        this.setEnableOnWrite(true);
    }

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return TABLE.equalsIgnoreCase(table.getName());
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        e.table.setRoot(true);
    }

    @Subscribe
    public void handleQuery(CreateQueryEvent e) {
        SynchroDirection direction = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection();
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case select: 
            case selectFromUpdateDate: 
            case selectMaxUpdateDate: {
                if (direction == SynchroDirection.IMPORT_SERVER2TEMP) {
                    e.sql = this.addRestrictionOnImportServer2TempDb(e.source, e.queryName, e.sql);
                    break;
                }
                if (direction == SynchroDirection.IMPORT_TEMP2LOCAL) {
                    e.sql = this.addRestrictionOnImportTemp2LocalDb(e.source, e.queryName, e.sql);
                    break;
                }
                if (direction != SynchroDirection.EXPORT_LOCAL2TEMP) break;
                e.sql = this.addRestrictionOnExport(e.source, e.queryName, e.sql);
                break;
            }
        }
    }

    protected String addRestrictionOnImportServer2TempDb(SynchroTableMetadata table, SynchroQueryName queryName, String sql) {
        String dateColumnName;
        DataSynchroDatabaseConfiguration databaseConfiguration = (DataSynchroDatabaseConfiguration)((Object)this.getConfig());
        boolean enableUpdateDateFilter = SynchroQueryName.withUpdateDate((SynchroQueryName)queryName);
        Set<String> objectTypes = ObjectTypeHelper.getObjectTypeFromTableName(table.getName());
        Preconditions.checkNotNull((Object)CollectionUtils.isNotEmpty(objectTypes));
        String objectTypeList = "'" + Joiner.on((String)"','").join(objectTypes) + "'";
        SynchroQueryBuilder queryBuilder = SynchroQueryBuilder.newBuilder((SynchroQueryName)queryName, (String)sql);
        if (queryName == SynchroQueryName.count || queryName == SynchroQueryName.countFromUpdateDate) {
            queryBuilder.replaceColumn("count(*)", "count(distinct t.ID)");
        } else {
            queryBuilder.setColumnDistinct(true);
        }
        int personId = this.checkAndGetPersonId();
        queryBuilder.addWhere(SynchroQueryOperator.AND, "(EXISTS (SELECT 1 FROM PROGRAM2PERSON WHERE PROGRAM_FK = T.PROGRAM_FK AND PERSON_FK = " + personId + ") OR EXISTS (" + "SELECT 1 FROM PERSON2USER_PROFIL" + " WHERE PERSON_FK = " + personId + " AND USER_PROFIL_FK = 1/*=ADMINISTRATEUR*/" + "))");
        String pkFilter = this.createPkFilter(table.getName(), COLUMN_ID);
        if (StringUtils.isNotBlank((CharSequence)pkFilter)) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, pkFilter);
        } else if (databaseConfiguration.getDataStartDate() != null && databaseConfiguration.getDataEndDate() != null && (dateColumnName = this.getFirstExistingColumnName(table, "return_date_time", "sale_start_date", "landing_date_time", "end_date_time", "start_date_time")) != null) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("t.%s  >= :startDate AND t.%s <= :endDate", dateColumnName, dateColumnName));
        }
        return queryBuilder.build();
    }

    protected String addRestrictionOnImportTemp2LocalDb(SynchroTableMetadata table, SynchroQueryName queryName, String sql) {
        String pkFilter = this.createPkFilter(table.getName(), COLUMN_ID);
        if (StringUtils.isBlank((CharSequence)pkFilter)) {
            return sql;
        }
        SynchroQueryBuilder queryBuilder = SynchroQueryBuilder.newBuilder((SynchroQueryName)queryName, (String)sql);
        queryBuilder.addWhere(SynchroQueryOperator.AND, pkFilter);
        return queryBuilder.build();
    }

    protected String addRestrictionOnExport(SynchroTableMetadata table, SynchroQueryName queryName, String sql) {
        Set<String> objectTypes = ObjectTypeHelper.getObjectTypeFromTableName(table.getName());
        Preconditions.checkNotNull((Object)CollectionUtils.isNotEmpty(objectTypes));
        String objectTypeList = "'" + Joiner.on((String)"','").join(objectTypes) + "'";
        SynchroQueryBuilder queryBuilder = SynchroQueryBuilder.newBuilder((SynchroQueryName)queryName, (String)sql);
        if (queryName == SynchroQueryName.count || queryName == SynchroQueryName.countFromUpdateDate) {
            queryBuilder.replaceColumn("count(*)", "count(distinct t.ID)");
        } else {
            queryBuilder.setColumnDistinct(true);
        }
        String pkFilter = this.createPkFilter(table.getName(), COLUMN_ID);
        if (StringUtils.isNotBlank((CharSequence)pkFilter)) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, pkFilter);
            queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("%s='%s'", COLUMN_SYNCHRONIZATION_STATUS, SynchronizationStatus.READY_TO_SYNCHRONIZE.value()));
        } else {
            int personId = this.checkAndGetPersonId();
            queryBuilder.addWhere(SynchroQueryOperator.AND, "(EXISTS (SELECT 1 FROM PROGRAM2PERSON WHERE PROGRAM_FK = T.PROGRAM_FK AND PERSON_FK = " + personId + ") OR EXISTS (" + "SELECT 1 FROM PERSON2USER_PROFIL" + " WHERE PERSON_FK = " + personId + " AND USER_PROFIL_FK = 1/*=ADMINISTRATEUR*/" + "))");
            queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("%s='%s'", COLUMN_SYNCHRONIZATION_STATUS, SynchronizationStatus.READY_TO_SYNCHRONIZE.value()));
        }
        return queryBuilder.build();
    }

    protected String getFirstExistingColumnName(SynchroTableMetadata table, String ... columnNames) {
        Set delegateColumns = table.getColumnNames();
        for (String columnName : columnNames) {
            if (!delegateColumns.contains(columnName.toLowerCase())) continue;
            return columnName;
        }
        return null;
    }
}

