/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.LoadPkEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import java.util.List;
import java.util.Set;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class ProduceQuantificationMeasurementInterceptor
extends AbstractDataInterceptor {
    public static final String SEQUENCE_NAME = "quantification_measurement_seq";
    public static final String COLUMN_PRODUCE_FK = "produce_fk";

    public ProduceQuantificationMeasurementInterceptor() {
        super(SynchroDirection.EXPORT_TEMP2SERVER, SynchroDirection.IMPORT_TEMP2LOCAL);
    }

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return "QUANTIFICATION_MEASUREMENT_P".equalsIgnoreCase(table.getName());
    }

    @Subscribe
    public void handleLoadTable(LoadTableEvent e) {
        SynchroTableMetadata table = e.table;
        table.setSequenceName(SEQUENCE_NAME);
        if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_TEMP2SERVER) {
            String remoteIdColumn = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId();
            String idColumn = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId();
            e.table.putUniqueConstraint(remoteIdColumn, (List)ImmutableList.of((Object)idColumn, (Object)COLUMN_PRODUCE_FK), SynchroTableMetadata.DuplicateKeyStrategy.REPLACE);
        }
    }

    @Subscribe
    public void handlePkLoad(LoadPkEvent e) {
        Set pk = e.pk;
        if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_TEMP2SERVER && pk != null && !pk.contains(COLUMN_PRODUCE_FK)) {
            pk.add(COLUMN_PRODUCE_FK);
        }
    }
}

