/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.dao.Daos;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class OperationInterceptor
extends AbstractDataInterceptor {
    private int catchBatchFkColumnIndex = -1;
    private boolean enableIntegrityConstraints = true;
    private static final String TABLE_BATCH = "BATCH";
    private static final String TABLE_OPERATION = "OPERATION";
    public static final String COLUMN_CATCH_BATCH = "catch_batch_fk";
    private static final String COLUMN_ID = "id";
    private PreparedStatement selectCatchBatchIdStatement = null;

    public OperationInterceptor() {
        this.setEnableOnWrite(true);
    }

    @Override
    public void init(DataSynchroDatabaseConfiguration config) {
        super.init(config);
        this.enableIntegrityConstraints = config.isIntegrityConstraintEnable();
    }

    @Override
    public SynchroInterceptorBase clone() {
        OperationInterceptor newBean = (OperationInterceptor)super.clone();
        newBean.catchBatchFkColumnIndex = this.catchBatchFkColumnIndex;
        newBean.enableIntegrityConstraints = this.enableIntegrityConstraints;
        return newBean;
    }

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return TABLE_OPERATION.equalsIgnoreCase(table.getName());
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        this.catchBatchFkColumnIndex = e.table.getSelectColumnIndex(COLUMN_CATCH_BATCH);
        e.table.setRoot(false);
    }

    protected void doOnWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer, boolean insert) throws SQLException {
        if (buffer == null) {
            return;
        }
        Object catchBatchFk = data[this.catchBatchFkColumnIndex];
        if (catchBatchFk != null) {
            buffer.addChildToUpdateFromOneColumn(TABLE_BATCH, COLUMN_ID, catchBatchFk);
            if (this.enableIntegrityConstraints) {
                data[this.catchBatchFkColumnIndex] = null;
                buffer.addMissingColumnUpdate(COLUMN_CATCH_BATCH, pk, catchBatchFk);
            }
        }
    }

    protected void doOnDelete(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
        Integer operationId = Integer.parseInt(pk.get(0).toString());
        Integer catchBatchId = this.getCatchBatchId(targetDao.getConnection(), operationId);
        if (catchBatchId != null) {
            buffer.addChildToDeleteFromOneColumn(TABLE_BATCH, COLUMN_ID, (Object)catchBatchId);
        }
    }

    protected void doOnDetach(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
        Integer operationId = Integer.parseInt(pk.get(0).toString());
        Integer catchBatchId = this.getCatchBatchId(targetDao.getConnection(), operationId);
        if (catchBatchId != null) {
            buffer.addChildToDetachFromOneColumn(TABLE_BATCH, COLUMN_ID, (Object)catchBatchId);
        }
    }

    protected void doClose() throws IOException {
        super.doClose();
        Daos.closeSilently((Statement)this.selectCatchBatchIdStatement);
        this.selectCatchBatchIdStatement = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getCatchBatchId(Connection connection, int OperationId) throws SQLException {
        if (this.selectCatchBatchIdStatement == null) {
            this.selectCatchBatchIdStatement = connection.prepareStatement(this.initSelectCatchBatchIdStatement());
        }
        this.selectCatchBatchIdStatement.setInt(1, OperationId);
        ResultSet resultSet = null;
        try {
            resultSet = this.selectCatchBatchIdStatement.executeQuery();
            if (!resultSet.next()) {
                Integer n = null;
                return n;
            }
            if (resultSet.getObject(1) == null) {
                Integer n = null;
                return n;
            }
            Integer n = resultSet.getInt(1);
            return n;
        }
        finally {
            Daos.closeSilently((ResultSet)resultSet);
        }
    }

    protected String initSelectCatchBatchIdStatement() {
        return String.format("SELECT %s FROM %s where %s=?", COLUMN_CATCH_BATCH, TABLE_OPERATION, COLUMN_ID);
    }
}

