/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.ObjectTypeHelper;
import fr.ifremer.adagio.synchro.intercept.data.internal.ExportRemoveNegativeValueInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.intercept.SynchroInterceptor;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryName;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.LockMode;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class ObservedLocationInterceptor
extends AbstractDataInterceptor {
    public static final String COLUMN_PROGRAM_FK = "program_fk";
    public static final String COLUMN_START_DATE_TIME = "start_date_time";
    public static final String COLUMN_LOCATION_FK = "location_fk";
    public static final String COLUMN_RECORDER_PERSON_FK = "recorder_person_fk";
    public static final String COLUMN_SYNCHRONIZATION_STATUS = "synchronization_status";
    public static final List<String> NATURAL_ID_COLUMN_NAMES = ImmutableList.of((Object)"program_fk", (Object)"start_date_time", (Object)"location_fk", (Object)"recorder_person_fk");

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        if (!"OBSERVED_LOCATION".equalsIgnoreCase(table.getName())) {
            return false;
        }
        Map delegateColumns = SynchroTableMetadata.getColumns((TableMetadata)table);
        boolean hasNeedColumns = delegateColumns.containsKey(COLUMN_PROGRAM_FK);
        return hasNeedColumns;
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        SynchroTableMetadata table = e.table;
        SynchroDirection direction = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection();
        table.setRoot(true);
        if (direction == SynchroDirection.EXPORT_LOCAL2TEMP) {
            int remoteIdColumnIndex = table.getSelectColumnIndex(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId());
            ExportRemoveNegativeValueInterceptor remoteIdInterceptor = new ExportRemoveNegativeValueInterceptor((DataSynchroDatabaseConfiguration)((Object)this.getConfig()), table.getName(), remoteIdColumnIndex);
            table.addInterceptor((SynchroInterceptor)remoteIdInterceptor);
        } else if (direction == SynchroDirection.EXPORT_TEMP2SERVER) {
            table.addUniqueConstraint("NATURAL_ID_UNIQUE_C", NATURAL_ID_COLUMN_NAMES, SynchroTableMetadata.DuplicateKeyStrategy.REJECT);
            table.setLockOnUpdate(LockMode.UPGRADE_NOWAIT);
        }
    }

    @Subscribe
    public void handleQuery(CreateQueryEvent e) {
        SynchroDirection direction = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection();
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case select: 
            case selectFromUpdateDate: 
            case selectMaxUpdateDate: {
                if (direction == SynchroDirection.IMPORT_SERVER2TEMP) {
                    e.sql = this.addRestrictionOnImportServer2TempDb(e.source, e.queryName, e.sql);
                    e.sql = this.addDebugRestriction(e.sql, ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId());
                    break;
                }
                if (direction == SynchroDirection.IMPORT_TEMP2LOCAL) {
                    e.sql = this.addRestrictionOnImportTemp2LocalDb(e.source, e.queryName, e.sql);
                    break;
                }
                if (direction != SynchroDirection.EXPORT_LOCAL2TEMP) break;
                e.sql = this.addRestrictionOnExport(e.source, e.queryName, e.sql);
                e.sql = this.addDebugRestriction(e.sql, ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId());
                break;
            }
        }
    }

    protected String addRestrictionOnImportServer2TempDb(SynchroTableMetadata table, SynchroQueryName queryName, String sql) {
        String pkFilter;
        boolean enableUpdateDateFilter = SynchroQueryName.withUpdateDate((SynchroQueryName)queryName);
        Set<String> objectTypes = ObjectTypeHelper.getObjectTypeFromTableName(table.getName());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(objectTypes));
        String objectTypeList = "'" + Joiner.on((String)"','").join(objectTypes) + "'";
        SynchroQueryBuilder queryBuilder = SynchroQueryBuilder.newBuilder((SynchroQueryName)queryName, (String)sql);
        int personSessionId = this.checkAndGetPersonSessionId();
        if (queryName == SynchroQueryName.count || queryName == SynchroQueryName.countFromUpdateDate) {
            queryBuilder.replaceColumn("count(*)", "count(distinct t.ID)");
        } else {
            queryBuilder.setColumnDistinct(true);
        }
        queryBuilder.addJoin(" LEFT OUTER JOIN LANDING l ON l.observed_location_fk=t.id LEFT OUTER JOIN PERSON_SESSION_VESSEL psv ON psv.vessel_fk=l.vessel_fk AND psv.program_fk=t.program_fk AND psv.person_session_fk=" + personSessionId + " LEFT OUTER JOIN PERSON_SESSION_ITEM psi ON psi.object_id=t.id" + " AND psi.person_session_fk=" + personSessionId);
        if (enableUpdateDateFilter) {
            queryBuilder.addWhere(SynchroQueryOperator.OR, "((psv.id IS NOT NULL AND psv.update_date > :updateDate) OR (psi.id IS NOT NULL AND psi.update_date > :updateDate))");
        }
        queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("((psv.object_type_fk IN (%s) AND NOT (t.start_date_time > psv.end_date_time OR t.end_date_time < psv.start_date_time)) OR (psi.object_type_fk IN (%s)))", objectTypeList, objectTypeList));
        String programFilter = this.createProgramCodesFilter("t.program_fk IN (%s)");
        if (StringUtils.isNotBlank((CharSequence)programFilter)) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, programFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)(pkFilter = this.createPkFilter(table.getName(), ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId())))) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, pkFilter);
        } else if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDataStartDate() != null && ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDataEndDate() != null) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, "t.start_date_time >= :startDate AND t.start_date_time <= :endDate");
        }
        return queryBuilder.build();
    }

    protected String addRestrictionOnImportTemp2LocalDb(SynchroTableMetadata table, SynchroQueryName queryName, String sql) {
        String pkFilter = this.createPkFilter(table.getName(), ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId());
        if (StringUtils.isBlank((CharSequence)pkFilter)) {
            return sql;
        }
        SynchroQueryBuilder queryBuilder = SynchroQueryBuilder.newBuilder((SynchroQueryName)queryName, (String)sql);
        queryBuilder.addWhere(SynchroQueryOperator.AND, pkFilter);
        return queryBuilder.build();
    }

    protected String addRestrictionOnExport(SynchroTableMetadata table, SynchroQueryName queryName, String sql) {
        Set<String> objectTypes = ObjectTypeHelper.getObjectTypeFromTableName(table.getName());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(objectTypes));
        String objectTypeList = "'" + Joiner.on((String)"','").join(objectTypes) + "'";
        SynchroQueryBuilder queryBuilder = SynchroQueryBuilder.newBuilder((SynchroQueryName)queryName, (String)sql);
        int personId = this.checkAndGetPersonId();
        if (queryName == SynchroQueryName.count || queryName == SynchroQueryName.countFromUpdateDate) {
            queryBuilder.replaceColumn("count(*)", "count(distinct t.ID)");
        } else {
            queryBuilder.setColumnDistinct(true);
        }
        queryBuilder.addJoin(" INNER JOIN PERSON_SESSION ps ON ps.person_fk=" + personId + " LEFT OUTER JOIN LANDING l ON l.observed_location_fk=t.id" + " LEFT OUTER JOIN PERSON_SESSION_VESSEL psv ON psv.vessel_fk=l.vessel_fk AND psv.program_fk = t.program_fk" + " AND psv.person_session_fk=ps.id" + " LEFT OUTER JOIN PERSON_SESSION_ITEM psi ON psi.object_id=t.remote_id" + " AND psi.person_session_fk=ps.id");
        queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("%s='%s'", COLUMN_SYNCHRONIZATION_STATUS, SynchronizationStatus.READY_TO_SYNCHRONIZE.value()));
        queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("((psv.object_type_fk IN (%s) AND NOT (t.start_date_time > psv.end_date_time OR t.end_date_time < psv.start_date_time)) OR (psi.object_type_fk IN (%s)))", objectTypeList, objectTypeList));
        String programFilter = this.createProgramCodesFilter("t.program_fk IN (%s)");
        if (StringUtils.isNotBlank((CharSequence)programFilter)) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, programFilter);
        }
        return queryBuilder.build();
    }

    protected String addDebugRestriction(String sql, String observedLocationFilterColumnName) {
        String idIncludes = AdagioConfiguration.getInstance().getApplicationConfig().getOption("adagio.synchro.import.observedLocation.includes");
        String vesselIncludesStr = AdagioConfiguration.getInstance().getApplicationConfig().getOption("adagio.synchro.import.vessels.includes");
        if (StringUtils.isBlank((CharSequence)idIncludes) && StringUtils.isBlank((CharSequence)vesselIncludesStr)) {
            return sql;
        }
        SynchroQueryBuilder queryBuilder = SynchroQueryBuilder.newBuilder((String)sql);
        if (StringUtils.isNotBlank((CharSequence)idIncludes)) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("t.%s in (%s)", observedLocationFilterColumnName, idIncludes));
        }
        if (StringUtils.isNotBlank((CharSequence)vesselIncludesStr)) {
            StringBuilder vesselParam = new StringBuilder();
            for (String vesselCode : vesselIncludesStr.split(",")) {
                vesselParam.append(",'").append(vesselCode).append("'");
            }
            queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("t.id in (select distinct l.observed_location_fk from landing l where l.vessel_fk in (%s))", vesselParam.substring(1)));
        }
        return queryBuilder.build();
    }

    protected String createProgramCodesFilter(String stringToFormat) {
        String programCodes = AdagioConfiguration.getInstance().getImportProgramCodes();
        if (StringUtils.isBlank((CharSequence)programCodes)) {
            return "";
        }
        return String.format(stringToFormat, "'" + Joiner.on((String)"','").join(Splitter.on((char)',').split((CharSequence)programCodes)) + "'");
    }
}

