/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class ObjectTypeHelper {
    protected static ObjectTypeHelper instance = null;
    protected static final Map<String, Set<String>> table2objectMap = ObjectTypeHelper.initMap();

    private ObjectTypeHelper() {
    }

    public static Set<String> getObjectTypeFromTableName(String tableName) {
        Preconditions.checkNotNull((Object)tableName);
        Set<String> result = table2objectMap.get(tableName);
        return result;
    }

    public static Set<String> getObjectTypeFromTableName(String tableName, String defaultValue) {
        Preconditions.checkNotNull((Object)tableName);
        Set<String> result = table2objectMap.get(tableName);
        if (CollectionUtils.isEmpty(result) && defaultValue != null) {
            return ImmutableSet.of((Object)defaultValue);
        }
        return result;
    }

    public static String getFirstObjectTypeFromTableName(String tableName, String defaultValue) {
        Set<String> objectTypes = ObjectTypeHelper.getObjectTypeFromTableName(tableName);
        if (CollectionUtils.isEmpty(objectTypes)) {
            return defaultValue;
        }
        return objectTypes.iterator().next();
    }

    public static String getTableNameFromObjectType(String objectType) {
        Preconditions.checkNotNull((Object)objectType);
        for (Map.Entry<String, Set<String>> entry : table2objectMap.entrySet()) {
            String tableName = entry.getKey();
            Set<String> objectTypes = entry.getValue();
            if (!objectTypes.contains(objectType)) continue;
            return tableName;
        }
        return objectType;
    }

    public static final String toDefaultObjectTypeCode(Class<?> aClass) {
        String result = null;
        if (aClass != null) {
            StringBuilder sb = new StringBuilder();
            String name = aClass.getSimpleName();
            if (name != null && name.length() > 0) {
                sb.append(Character.toUpperCase(name.charAt(0)));
                for (int i = 1; i < name.length(); ++i) {
                    char caract = name.charAt(i);
                    if (Character.isUpperCase(caract)) {
                        sb.append("_");
                    } else {
                        caract = Character.toUpperCase(caract);
                    }
                    sb.append(caract);
                }
            }
            result = sb.toString();
        }
        return result;
    }

    protected static Map<String, Set<String>> initMap() {
        HashMap result = Maps.newHashMap();
        result.put("VESSEL_FEATURES", ImmutableSet.of((Object)"VESSEL_FEATURES"));
        result.put("LOCATION", ImmutableSet.of((Object)"LOCATION"));
        result.put("VESSEL", ImmutableSet.of((Object)"VESSEL"));
        result.put("REFERENCE_TAXON", ImmutableSet.of((Object)"REFERENCE_TAXON"));
        result.put("TAXON_GROUP", ImmutableSet.of((Object)"TAXON_GROUP"));
        result.put("GEAR", ImmutableSet.of((Object)"GEAR"));
        result.put("TAXON_GROUP", ImmutableSet.of((Object)"TAXON_GROUP"));
        result.put("METIER", ImmutableSet.of((Object)"METIER"));
        result.put("PMFM", ImmutableSet.of((Object)"PMFM"));
        result.put("LOCATION_ASSOCIATION", ImmutableSet.of((Object)"LOCATION_ASSOCIATION"));
        result.put("TAXON_NAME", ImmutableSet.of((Object)"TAXON_NAME"));
        result.put("PARAMETER", ImmutableSet.of((Object)"PARAMETER"));
        result.put("LOCATION_LEVEL", ImmutableSet.of((Object)"LOCATION_LEVEL"));
        result.put("VESSEL_OWNER", ImmutableSet.of((Object)"VESSEL_OWNER"));
        result.put("ROUND_WEIGHT_CONVERSION", ImmutableSet.of((Object)"ROUND_WEIGHT_CONVERSION"));
        result.put("QUALITATIVE_VALUE", ImmutableSet.of((Object)"QUALITATIVE_VALUE"));
        result.put("PERSON", ImmutableSet.of((Object)"PERSON"));
        result.put("DEPTH_GRADIENT", ImmutableSet.of((Object)"DEPTH_GRADIENT"));
        result.put("DISTANCE_TO_COAST_GRADIENT", ImmutableSet.of((Object)"DISTANCE_TO_COAST_GRADIENT"));
        result.put("NEARBY_SPECIFIC_AREA", ImmutableSet.of((Object)"NEARBY_SPECIFIC_AREA"));
        result.put("PROGRAM", ImmutableSet.of((Object)"PROGRAM"));
        result.put("GEAR_CLASSIFICATION", ImmutableSet.of((Object)"GEAR_CLASSIFICATION"));
        result.put("FISHING_TRIP", ImmutableSet.of((Object)"OBSERVED_FISHING_TRIP", (Object)"FISHING_TRIP"));
        result.put("SALE", ImmutableSet.of((Object)"SALE", (Object)"OBSERVED_SALE"));
        result.put("BATCH", ImmutableSet.of((Object)"CATCH_BATCH", (Object)"BATCH"));
        result.put("LANDING", ImmutableSet.of((Object)"OBSERVED_LANDING", (Object)"LANDING"));
        result.put("OBSERVED_LOCATION", ImmutableSet.of((Object)"OBSERVED_LOCATION", (Object)"OBSERVED_LANDING"));
        result.put("SCIENTIFIC_CRUISE", ImmutableSet.of((Object)"SCIENTIFIC_CRUISE"));
        result.put("ACTIVITY_CALENDAR", ImmutableSet.of((Object)"ACTIVITY_CALENDAR"));
        result.put("DAILY_ACTIVITY_CALENDAR", ImmutableSet.of((Object)"DAILY_ACTIVITY_CALENDAR"));
        result.put("DECLARED_DOCUMENT_REFERENCE", ImmutableSet.of((Object)"DECLARED_DOCUMENT_REFERENCE"));
        result.put("PERSON_SESSION_VESSEL", ImmutableSet.of((Object)"PERSON_SESSION_VESSEL"));
        return result;
    }
}

