/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.dao.Daos;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.meta.event.LoadJoinEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class LandingInterceptor
extends AbstractDataInterceptor {
    public static final String COLUMN_PROGRAM_FK = "program_fk";
    private int fishingTripFkColumnIndex = -1;
    private boolean enableIntegrityConstraints = true;
    private static final String TABLE_LANDING = "LANDING";
    private static final String TABLE_PRODUCE = "PRODUCE";
    private static final String TABLE_FISHING_TRIP = "FISHING_TRIP";
    private static final String TABLE_BATCH = "BATCH";
    private static final String LANDING_COLUMN_ID = "id";
    private static final String LANDING_COLUMN_FISHING_TRIP_FK = "fishing_trip_fk";
    private static final String LANDING_COLUMN_OBSERVED_LOCATION_FK = "observed_location_fk";
    private static final String FISHING_TRIP_COLUMN_ID = "id";
    private static final String FK_COLUMN_NAME = "OBSERVED_LOCATION_FK";
    private static final String SYNCHRONIZATION_STATUS_COLUMN_NAME = "SYNCHRONIZATION_STATUS";
    private static final List<String> LANDING_UNIQUE_KEY = ImmutableList.of((Object)"LANDING_DATE_TIME", (Object)"VESSEL_FK", (Object)"PROGRAM_FK", (Object)"RANK_ORDER");
    private PreparedStatement selectFishingTripIdStatement = null;

    public LandingInterceptor() {
        this.setEnableOnWrite(true);
    }

    @Override
    public void init(DataSynchroDatabaseConfiguration config) {
        super.init(config);
        this.enableIntegrityConstraints = config.getDirection() == SynchroDirection.EXPORT_TEMP2SERVER || config.getDirection() == SynchroDirection.IMPORT_TEMP2LOCAL;
    }

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return TABLE_LANDING.equalsIgnoreCase(table.getName());
    }

    @Override
    public SynchroInterceptorBase clone() {
        LandingInterceptor newBean = (LandingInterceptor)super.clone();
        newBean.fishingTripFkColumnIndex = this.fishingTripFkColumnIndex;
        newBean.enableIntegrityConstraints = this.enableIntegrityConstraints;
        return newBean;
    }

    @Subscribe
    public void handleQuery(CreateQueryEvent e) {
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case select: 
            case selectFromUpdateDate: 
            case selectMaxUpdateDate: {
                e.sql = SynchroQueryBuilder.newBuilder((String)e.sql).addWhere(SynchroQueryOperator.AND, String.format("t.%s is null", LANDING_COLUMN_OBSERVED_LOCATION_FK)).addWhere(SynchroQueryOperator.AND, String.format("t.%s is null", LANDING_COLUMN_FISHING_TRIP_FK)).build();
                break;
            }
        }
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        this.fishingTripFkColumnIndex = e.table.getSelectColumnIndex(LANDING_COLUMN_FISHING_TRIP_FK);
        e.table.setRoot(false);
        if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_TEMP2SERVER) {
            e.table.addUniqueConstraint("LANDING_UNIQUE_KEY", LANDING_UNIQUE_KEY, SynchroTableMetadata.DuplicateKeyStrategy.REPLACE_LOW_PRIORITY);
        } else if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_LOCAL2TEMP) {
            e.table.addSelectByFksWhereClause(FK_COLUMN_NAME, String.format("t.%s<>'%s'", SYNCHRONIZATION_STATUS_COLUMN_NAME, SynchronizationStatus.DELETED.getValue()));
        }
    }

    @Subscribe
    public void handleJoinLoad(LoadJoinEvent e) {
        if (!e.join.isValid()) {
            return;
        }
        String targetTableName = e.join.getTargetTable().getName();
        if (TABLE_BATCH.equalsIgnoreCase(targetTableName)) {
            e.join.setIsValid(false);
        }
        if (TABLE_PRODUCE.equalsIgnoreCase(targetTableName)) {
            e.join.setIsValid(false);
        }
    }

    protected void doOnWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer, boolean insert) throws SQLException {
        if (buffer == null) {
            return;
        }
        Object fishingTripRemoteId = data[this.fishingTripFkColumnIndex];
        if (fishingTripRemoteId != null) {
            buffer.addChildToUpdateFromOneColumn(TABLE_FISHING_TRIP, "id", fishingTripRemoteId);
            if (this.enableIntegrityConstraints) {
                data[this.fishingTripFkColumnIndex] = null;
                buffer.addMissingColumnUpdate(LANDING_COLUMN_FISHING_TRIP_FK, pk, fishingTripRemoteId);
            }
        }
    }

    protected void doOnDelete(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
        Integer landingId = Integer.parseInt(pk.get(0).toString());
        Integer fishingTripId = this.getFishingTripId(targetDao.getConnection(), landingId);
        if (fishingTripId != null) {
            buffer.addChildToDeleteFromOneColumn(TABLE_FISHING_TRIP, "id", (Object)fishingTripId);
        }
    }

    protected void doOnDetach(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
        Integer landingId = Integer.parseInt(pk.get(0).toString());
        Integer fishingTripId = this.getFishingTripId(targetDao.getConnection(), landingId);
        if (fishingTripId != null) {
            buffer.addChildToDetachFromOneColumn(TABLE_FISHING_TRIP, "id", (Object)fishingTripId);
        }
    }

    protected void doClose() throws IOException {
        super.doClose();
        Daos.closeSilently((Statement)this.selectFishingTripIdStatement);
        this.selectFishingTripIdStatement = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getFishingTripId(Connection connection, int landingId) throws SQLException {
        if (this.selectFishingTripIdStatement == null) {
            this.selectFishingTripIdStatement = connection.prepareStatement(this.initSelectFishingTripIdStatement());
        }
        this.selectFishingTripIdStatement.setInt(1, landingId);
        ResultSet resultSet = null;
        try {
            resultSet = this.selectFishingTripIdStatement.executeQuery();
            if (!resultSet.next()) {
                Integer n = null;
                return n;
            }
            if (resultSet.getObject(1) == null) {
                Integer n = null;
                return n;
            }
            Integer n = resultSet.getInt(1);
            return n;
        }
        finally {
            Daos.closeSilently((ResultSet)resultSet);
        }
    }

    protected String initSelectFishingTripIdStatement() {
        return String.format("SELECT %s FROM %s where %s=?", LANDING_COLUMN_FISHING_TRIP_FK, TABLE_LANDING, "id");
    }
}

