/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.LoadJoinEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import java.util.List;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class GearPhysicalFeaturesInterceptor
extends AbstractDataInterceptor {
    public static final String TARGET_TABLE_OPERATION = "OPERATION";
    public static final String TARGET_COLUMN_GEAR_PHYSICAL_FEATURES = "gear_physical_features_fk";
    private static final String UNIQUE_KEY_NAME = "GEAR_PHYS_FEAT_UNIQUE_KEY";
    private static final List<String> UNIQUE_KEY_COLS = ImmutableList.of((Object)"VESSEL_FK", (Object)"PROGRAM_FK", (Object)"GEAR_FK", (Object)"PHYSICAL_GEAR_SURVEY_FK", (Object)"FISHING_TRIP_FK", (Object)"RANK_ORDER", (Object)"START_DATE");

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return "GEAR_PHYSICAL_FEATURES".equalsIgnoreCase(table.getName());
    }

    @Subscribe
    public void handleJoinLoad(LoadJoinEvent e) {
        boolean isJoinToOperationTable;
        if (!e.join.isValid()) {
            return;
        }
        String targetTableName = e.join.getTargetTable().getName();
        String targetColumnName = e.join.getTargetColumn().getName();
        boolean bl = isJoinToOperationTable = TARGET_TABLE_OPERATION.equalsIgnoreCase(targetTableName) && TARGET_COLUMN_GEAR_PHYSICAL_FEATURES.equalsIgnoreCase(targetColumnName);
        if (isJoinToOperationTable) {
            e.join.setIsValid(false);
        }
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_TEMP2SERVER) {
            e.table.addUniqueConstraint(UNIQUE_KEY_NAME, UNIQUE_KEY_COLS, SynchroTableMetadata.DuplicateKeyStrategy.REPLACE_LOW_PRIORITY);
        }
    }
}

