/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.meta.event.LoadJoinEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryName;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class FishingTripOriginInterceptor
extends AbstractDataInterceptor {
    public static final String COLUMN_PROGRAM_FK = "program_fk";
    private final String COLUMN_ORIGIN_FISHING_TRIP_REMOTE_ID = "origin_fishing_trip_remote_id";
    private final String COLUMN_ORIGIN_FISHING_TRIP_FK = "origin_fishing_trip_fk";

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return "FISHING_TRIP_ORIGIN".equalsIgnoreCase(table.getName());
    }

    @Subscribe
    public void handleQuery(CreateQueryEvent e) {
        SynchroDirection direction = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection();
        if (direction == SynchroDirection.IMPORT_SERVER2TEMP) {
            switch (e.queryName) {
                case select: 
                case selectFromUpdateDate: {
                    e.sql = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists("origin_fishing_trip_remote_id").build();
                    break;
                }
                case insert: 
                case update: {
                    e.sql = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists("origin_fishing_trip_remote_id").build();
                    break;
                }
            }
        } else if (direction == SynchroDirection.IMPORT_TEMP2LOCAL) {
            switch (e.queryName) {
                case select: 
                case selectFromUpdateDate: {
                    e.sql = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists("origin_fishing_trip_remote_id").build();
                    break;
                }
                case insert: {
                    e.sql = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists("origin_fishing_trip_remote_id").replaceColumn("origin_fishing_trip_fk", "origin_fishing_trip_remote_id").build();
                    break;
                }
                case update: {
                    e.sql = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists("origin_fishing_trip_remote_id").replaceColumn("origin_fishing_trip_fk", "origin_fishing_trip_remote_id").build();
                    break;
                }
            }
        }
    }

    @Subscribe
    public void handleJoinLoad(LoadJoinEvent e) {
        SynchroJoinMetadata join = e.join;
        if (join.isSourceFk() && !((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).isMirrorDatabase() && "origin_fishing_trip_fk".equalsIgnoreCase(e.join.getSourceColumn().getName())) {
            e.join.setIsValid(false);
        }
    }
}

