/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.dao.Daos;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.meta.event.LoadJoinEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class FishingTripInterceptor
extends AbstractDataInterceptor {
    private static final String TABLE_LANDING = "LANDING";
    private static final String LANDING_COLUMN_FISHING_TRIP_FK = "fishing_trip_fk";
    private static final String FK_COLUMN_NAME = "ID";
    private static final String SYNCHRONIZATION_STATUS_COLUMN_NAME = "SYNCHRONIZATION_STATUS";
    private static final String UNIQUE_KEY_NAME = "FISHING_TRIP_UNIQUE_KEY";
    private static final List<String> UNIQUE_KEY_COLS = ImmutableList.of((Object)"DEPARTURE_DATE_TIME", (Object)"VESSEL_FK", (Object)"PROGRAM_FK", (Object)"DECLARED_DOCUMENT_REFERENCE_FK");
    private PreparedStatement updateLandingFishingTripFkStatement = null;

    public FishingTripInterceptor() {
        this.setEnableOnWrite(true);
    }

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return "FISHING_TRIP".equalsIgnoreCase(table.getName());
    }

    @Subscribe
    public void handleCreateQuery(CreateQueryEvent e) {
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case select: 
            case selectFromUpdateDate: 
            case selectMaxUpdateDate: {
                e.sql = SynchroQueryBuilder.newBuilder((String)e.sql).addWhere(SynchroQueryOperator.AND, "t.scientific_cruise_fk is null").addJoin(" LEFT OUTER JOIN landing la ON la.fishing_trip_fk=t.id ").addWhere(SynchroQueryOperator.AND, "(la.id is null OR la.observed_location_fk is null)").build();
                break;
            }
        }
    }

    @Subscribe
    public void handleLoadJoin(LoadJoinEvent e) {
        boolean isJoinToLandingTable;
        if (!e.join.isValid()) {
            return;
        }
        String targetTableName = e.join.getTargetTable().getName();
        String targetColumnName = e.join.getTargetColumn().getName();
        boolean bl = isJoinToLandingTable = TABLE_LANDING.equalsIgnoreCase(targetTableName) && LANDING_COLUMN_FISHING_TRIP_FK.equalsIgnoreCase(targetColumnName);
        if (isJoinToLandingTable) {
            e.join.setIsValid(false);
        }
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        e.table.setRoot(true);
        if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_TEMP2SERVER) {
            e.table.addUniqueConstraint(UNIQUE_KEY_NAME, UNIQUE_KEY_COLS, SynchroTableMetadata.DuplicateKeyStrategy.REJECT);
        } else if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_LOCAL2TEMP) {
            e.table.addSelectByFksWhereClause(FK_COLUMN_NAME, String.format("t.%s<>'%s'", SYNCHRONIZATION_STATUS_COLUMN_NAME, SynchronizationStatus.DELETED.getValue()));
        }
    }

    protected void doOnDelete(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
        int localId = Integer.parseInt(pk.get(0).toString());
        this.removeLinkToLanding(targetDao.getConnection(), localId);
    }

    protected void doClose() throws IOException {
        super.doClose();
        Daos.closeSilently((Statement)this.updateLandingFishingTripFkStatement);
        this.updateLandingFishingTripFkStatement = null;
    }

    protected void removeLinkToLanding(Connection connection, int fishingTripId) throws SQLException {
        if (this.updateLandingFishingTripFkStatement == null) {
            this.updateLandingFishingTripFkStatement = connection.prepareStatement(this.initUpdateLandingFishingTripFkStatement());
        }
        this.updateLandingFishingTripFkStatement.setInt(1, fishingTripId);
        this.updateLandingFishingTripFkStatement.executeUpdate();
    }

    protected String initUpdateLandingFishingTripFkStatement() {
        return String.format("UPDATE %s SET %s = null WHERE %s = ?", TABLE_LANDING, LANDING_COLUMN_FISHING_TRIP_FK, LANDING_COLUMN_FISHING_TRIP_FK);
    }
}

