/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import java.util.List;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class DailyActivityCalendarInterceptor
extends AbstractDataInterceptor {
    private static final String TABLE = "DAILY_ACTIVITY_CALENDAR";
    private static final String UNIQUE_KEY_NAME = "DAILY_ACTIVITY_CAL_UNIQUE_KEY";
    private static final List<String> UNIQUE_KEY_COLS = ImmutableList.of((Object)"VESSEL_FK", (Object)"PROGRAM_FK", (Object)"START_DATE", (Object)"END_DATE");
    private static final String FK_COLUMN_NAME = "OBSERVED_LOCATION_FK";
    private static final String SYNCHRONIZATION_STATUS_COLUMN_NAME = "SYNCHRONIZATION_STATUS";

    public DailyActivityCalendarInterceptor() {
        super(SynchroDirection.EXPORT_TEMP2SERVER, SynchroDirection.EXPORT_LOCAL2TEMP);
    }

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return TABLE.equalsIgnoreCase(table.getName());
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_TEMP2SERVER) {
            e.table.addUniqueConstraint(UNIQUE_KEY_NAME, UNIQUE_KEY_COLS, SynchroTableMetadata.DuplicateKeyStrategy.REJECT);
        } else if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_LOCAL2TEMP) {
            e.table.addSelectByFksWhereClause(FK_COLUMN_NAME, String.format("t.%s<>'%s'", SYNCHRONIZATION_STATUS_COLUMN_NAME, SynchronizationStatus.DELETED.getValue()));
        }
    }
}

