package fr.ifremer.adagio.synchro.query.internal;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.google.common.base.Preconditions;

import fr.ifremer.adagio.synchro.query.SynchroQueryName;

/**
 * UPDATE Query
 */
public class SynchroUpdateQuery extends SynchroInsertQuery {

	public SynchroUpdateQuery(SynchroQueryName queryName, String tableName, List<String> columnNames) {
		super(queryName, tableName, columnNames);
		setAllowWhereClause(true);
	}

	public SynchroUpdateQuery(SynchroQueryName queryName, String tableName, List<String> columnNames, List<String> columnValues) {
		super(queryName, tableName, columnNames, columnValues);
		setAllowWhereClause(true);
	}

	public SynchroUpdateQuery(SynchroQueryName queryName, String tableName) {
		super(queryName, tableName);
		setAllowWhereClause(true);
	}

	@Override
	public String toSql() {
		Preconditions.checkArgument(CollectionUtils.isNotEmpty(columnNames));
		StringBuilder updateParams = new StringBuilder();

		for (String columnName : columnNames) {
			updateParams.append(", ").append(columnName);
			String value = columnValues.get(columnName);
			if (value != null) {
				updateParams.append(" = ").append(value);
			}
			else {
				updateParams.append(" = ?");
			}
		}

		String sql = String.format("UPDATE %s SET %s%s",
				tableName,
				updateParams.substring(2),
				getSqlWhereClause());

		return sql;
	}

}