package fr.ifremer.adagio.synchro.query.internal;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.google.common.collect.Lists;

import fr.ifremer.adagio.synchro.query.SynchroQueryBuilder;
import fr.ifremer.adagio.synchro.query.SynchroQueryName;

/**
 * SELECT Query
 */
public class SynchroSelectQuery extends SynchroAbstractQuery {
	protected String selectClause;
	protected String fromClause;
	protected List<String> joins = null;
	protected boolean columnDistinct;

	public SynchroSelectQuery(SynchroQueryName queryName, String tableName, List<String> columnNames, String fromClause, String whereClause) {
		super(queryName, tableName, columnNames, true);
		setWhereClause(whereClause);
		this.fromClause = fromClause;
		this.columnDistinct = false;
	}

	public SynchroSelectQuery(SynchroQueryName queryName, String tableName, List<String> columnNames, String whereClause) {
		super(queryName, tableName, columnNames, true);
		setWhereClause(whereClause);
		this.fromClause = null;
		this.columnDistinct = false;
	}

	public String toSql() {
		// Select clause
		StringBuilder selectParams = new StringBuilder();
		if (selectClause != null) {
			selectParams
					.append("  ") // 2 empty char, for the next substring(2)
					.append(selectClause);
		}
		else {
			String tableAliasSubstitute = NO_ALIAS_STR;
			if (StringUtils.isNotBlank(tableAlias)) {
				tableAliasSubstitute = tableAlias + ".";
			}
			for (String columnName : columnNames) {
				if (StringUtils.isNotBlank(tableAlias)) {
					columnName = columnName.replace(ALIAS_VAR, tableAliasSubstitute);
				}
				selectParams.append(", ").append(columnName);
			}
		}

		// From clause
		StringBuilder fromParams = new StringBuilder();
		if (StringUtils.isNotBlank(fromClause)) {
			fromParams.append(fromClause);
		}
		else {
			fromParams.append(tableName);
			if (StringUtils.isNotBlank(tableAlias)) {
				fromParams.append(' ').append(tableAlias);
			}
		}

		// From clause > Join
		StringBuilder joinBuffer = new StringBuilder();
		if (CollectionUtils.isNotEmpty(joins)) {
			for (String join : joins) {
				joinBuffer.append(" ").append(join.trim());
			}
		}

		String sql = String.format("SELECT %s%s FROM %s%s%s",
				columnDistinct ? "DISTINCT " : "",
				selectParams.substring(2),
				fromParams.toString(),
				joinBuffer.toString(),
				getSqlWhereClause()
				);
		return sql;
	}

	@Override
	public SynchroQueryBuilder setColumnDistinct(boolean columnDistinct) {
		this.columnDistinct = columnDistinct;
		return this;
	}

	@Override
	public SynchroQueryBuilder addJoin(String joinClause) {
		if (joins == null) {
			joins = Lists.newArrayList(joinClause);
		}
		else {
			joins.add(joinClause);
		}
		return this;
	}

}