package fr.ifremer.adagio.synchro.intercept;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.sql.Timestamp;
import java.util.List;

import org.nuiton.i18n.I18n;

import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;

public class SynchroBadUpdateDateRowException extends SynchroRejectRowException {

	private static final long serialVersionUID = 1L;

	private final String sourcePkStr;
	private final String targetPkStr;
	private final String tableName;
	private final Timestamp validUpdateDate;

	public SynchroBadUpdateDateRowException(String tableName, List<Object> sourcePk, List<Object> targetPk, Timestamp validUpdateDate) {
		this(tableName,
				SynchroTableMetadata.toPkStr(sourcePk),
				targetPk == null ? "null" : SynchroTableMetadata.toPkStr(targetPk),
				validUpdateDate);
	}

	public SynchroBadUpdateDateRowException(String tableName, String sourcePkStr, String targetPkStr, Timestamp validUpdateDate) {
		super(I18n.t("adagio.synchro.synchronize.reject.badVersion.error", tableName, sourcePkStr));
		this.tableName = tableName;
		this.sourcePkStr = sourcePkStr;
		this.targetPkStr = targetPkStr;
		this.validUpdateDate = validUpdateDate;
	}

	public String getSourcePkStr() {
		return sourcePkStr;
	}

	public String getTargetPkStr() {
		return targetPkStr;
	}

	public String getTableName() {
		return tableName;
	}

	public Timestamp getValidUpdateDate() {
		return validUpdateDate;
	}
}
