package fr.ifremer.adagio.synchro.dao;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Closeable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

/**
 * Basic DAO operation.<br/>
 * An unique object of this class is typically created on DaoFactory, to be used as an unique cache of statements. <br/>
 * (Should be used as a singleton, as possible: subclasses must use a shared delegate instance.)
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.8.0
 * 
 */
public interface SynchroBaseDao extends Closeable {

	static final String TEMP_QUERY_PARAMETER_TABLE = "TEMP_QUERY_PARAMETER";

	static final String TEMP_QUERY_PARAMETER_VALUE_COLUMN = "ALPHANUMERICAL_VALUE";
	static final String TEMP_QUERY_PARAMETER_PARAM_COLUMN = "PARAMETER_NAME";

	static final String TEMP_QUERY_PARAMETER_SEQUENCE = "TEMP_QUERY_PARAMETER_SEQ";

	/**
	 * Constants use as prefix in column PARAMETER_NAME of table TEMP_QUERY_PARAMETER
	 */
	static final String TEMP_QUERY_PARAMETER_PARAM_PREFIX = "SYNC#";

	Connection getConnection();

	DaoFactory getDaoFactory();

	/**
	 * Return a prepared statement, using a pool by SQL.
	 * Is not found, create a new statement (using Connection.prepareStatement) then add it to the pool.<br/>
	 * Statement returned has not to be closed. The DaoFactory will close all opened statement.
	 * 
	 * @param sql
	 *            the SQL query
	 * @return a valid (not closed) PreparedStatement.
	 * @throws SQLException
	 */
	PreparedStatement getPreparedStatement(String sql) throws SQLException;

	/**
	 * Execute a select statement, and return the unique result as the given type
	 * 
	 * @param selectPreparedStatement
	 * @return the unique result
	 * @throws SQLException
	 */
	<T> T getUniqueTyped(String sql, Object[] bindingValues) throws SQLException;

	String getInsertIntoTempQueryParameterQuery();

	/**
	 * Clean rows used by synchro, from TEMP_QUERY_PARAMETER.<br/>
	 * Only rows with the prefix TEMP_QUERY_PARAMETER_PARAM_PREFIX will be deleted.<br/>
	 * This allow to used TEMP_QUERY_PAREMETER to store other data
	 * (e.g. existing PKs on server DB, to compare with local DB and witch PK must be deleted).<br/>
	 * 
	 * @throws SQLException
	 */
	void cleanTempQueryParameter() throws SQLException;

	void executeDeleteTempQueryParameter(String queryParameterName, boolean likeOperatorForParameterName, int queryPersonId) throws SQLException;

	void executeInsertIntoTempQueryParameter(List<Object> parameterValues, String queryParameterName, int queryPersonId)
			throws SQLException;
}
