package fr.ifremer.adagio.synchro.dao;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Closeable;

import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroTableOperation;

public interface DaoFactory extends Closeable {
	public final static int DEFAULT_DAO_CACHE_SIZE = 50;
	public final static int DEFAULT_DAO_CACHE_DURATION_SECONDS = 5 * 60 /* 5min */;
	public final static int DEFAULT_STATEMENT_CACHE_SIZE = 50;
	public final static int DEFAULT_STATEMENT_CACHE_DURATION_SECONDS = DEFAULT_DAO_CACHE_DURATION_SECONDS;
	public final static int DEFAULT_VALUE_CACHE_SIZE = 1000;
	public final static int DEFAULT_VALUE_CACHE_DURATION_SECONDS = 60 /* 1 min */;

	SynchroTableDao getSourceDao(String tableName);

	SynchroTableDao getSourceDao(SynchroTableMetadata table);

	SynchroTableDao getTargetDao(SynchroTableMetadata table, SynchroTableDao sourceDao, SynchroTableOperation currentOperation);

	SynchroBaseDao getDao();
}
