/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.dao;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.dao.Daos;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;

public class SynchroTableDaoUtils {
    private static final Log log = LogFactory.getLog(SynchroTableDaoUtils.class);

    protected SynchroTableDaoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp getLastUpdateDate(SynchroTableMetadata table, Connection connection) throws SQLException {
        if (!table.isWithUpdateDateColumn()) {
            return null;
        }
        String sql = table.getSelectMaxUpdateDateQuery();
        Preconditions.checkNotNull((Object)sql, (Object)"selectMaxUpdateDate not found - make sure fullMetadata has been enable on SynchroDatabaseConfiguration");
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[%s] Execute getLastUpdateDate query: %s", table.getName(), sql));
        }
        PreparedStatement statement = connection.prepareStatement(sql);
        ResultSet resultSet = null;
        try {
            Timestamp result;
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                Timestamp timestamp = null;
                return timestamp;
            }
            Timestamp timestamp = result = resultSet.getTimestamp(1);
            return timestamp;
        }
        finally {
            Daos.closeSilently(resultSet);
            Daos.closeSilently(statement);
        }
    }

    public static int getSequenceNameMaxLength(Dialect dialect) {
        int maxSequenceName = 100;
        if (dialect.getClass().getSimpleName().startsWith("Oracle")) {
            maxSequenceName = 30;
        }
        return maxSequenceName;
    }
}

