package fr.ifremer.adagio.synchro.dao;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;

import com.google.common.base.Preconditions;

import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;

/**
 * Helper class, for dao operation on a table.
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.7.0
 * 
 */
public class SynchroTableDaoUtils {

	/** Logger. */
	private static final Log log =
			LogFactory.getLog(SynchroTableDaoUtils.class);

	protected SynchroTableDaoUtils() {
		// helper class
	}

	/**
	 * Gets the last updateDate for the given {@code table} using
	 * the given datasource.
	 * 
	 * @return the last update date of the given table, or {@code null} if table does not use a updateDate columns or if
	 *         there
	 *         is no data in table.
	 */
	public static Timestamp getLastUpdateDate(SynchroTableMetadata table, Connection connection) throws SQLException {
		if (!table.isWithUpdateDateColumn()) {
			return null;
		}

		String sql = table.getSelectMaxUpdateDateQuery();
		Preconditions.checkNotNull(sql, "selectMaxUpdateDate not found - make sure fullMetadata has been enable on SynchroDatabaseConfiguration");

		if (log.isTraceEnabled()) {
			log.trace(String.format("[%s] Execute getLastUpdateDate query: %s", table.getName(), sql));
		}

		PreparedStatement statement = connection.prepareStatement(sql);
		ResultSet resultSet = null;
		try {
			resultSet = statement.executeQuery();
			if (!resultSet.next()) {
				return null;
			}
			Timestamp result = resultSet.getTimestamp(1);
			return result;
		} finally {
			Daos.closeSilently(resultSet);
			Daos.closeSilently(statement);
		}
	}

	public static int getSequenceNameMaxLength(Dialect dialect) {
		int maxSequenceName = 100;
		if (dialect.getClass().getSimpleName().startsWith("Oracle")) {
			maxSequenceName = 30;
		}
		return maxSequenceName;
	}
}
