package fr.ifremer.adagio.synchro.service;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Properties;

import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;

import com.google.common.base.Preconditions;

import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;

public class SynchroBaseService {

	/** Logger. */
	private static final Log log =
			LogFactory.getLog(SynchroBaseService.class);

	protected final SynchroConfiguration config;

	protected final int batchSize;

	protected final DataSource dataSource;

	public SynchroBaseService(DataSource dataSource, SynchroConfiguration config) {
		Preconditions.checkNotNull(config);

		this.dataSource = dataSource;
		this.config = config;
		this.batchSize = config.getImportJdbcBatchSize();
	}

	public SynchroBaseService() {
		this.config = SynchroConfiguration.getInstance();
		Preconditions.checkNotNull(this.config,
				String.format("%s instance not initialized. Make sure 'setInstance()' is called first.", SynchroConfiguration.class.getName()));
		this.dataSource = null;
		this.batchSize = config.getImportJdbcBatchSize();
	}

	protected void reportProgress(SynchroResult result, SynchroTableDao dao, int countR, String tablePrefix) {
		if (countR % batchSize == 0) {
			result.getProgressionModel().increments(batchSize);
		}

		if (countR % (batchSize * 10) == 0) {
			if (log.isInfoEnabled()) {
				log.info(String.format("%s Done: %s (inserts: %s, updates: %s)", tablePrefix, countR, dao.getInsertCount(), dao.getUpdateCount()));
			}
		}
	}

	protected Dialect getDialect(Properties connectionProperties) {
		return Dialect.getDialect(connectionProperties);
	}

	protected Dialect getTargetDialect(SynchroContext context) {
		return getDialect(context.getTargetConnectionProperties());
	}

	protected Dialect getSourceDialect(SynchroContext context) {
		return getDialect(context.getSourceConnectionProperties());
	}

}
