package fr.ifremer.adagio.synchro.config;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.nuiton.config.ConfigActionDef;

import fr.ifremer.adagio.synchro.action.SynchroHelpAction;
import fr.ifremer.adagio.synchro.action.SynchroImportDataAction;
import fr.ifremer.adagio.synchro.action.SynchroImportReferentialAction;
import fr.ifremer.adagio.synchro.socket.SynchroHttpServer;

public enum SynchroConfigurationAction implements ConfigActionDef {

	HELP(SynchroHelpAction.class.getName() + "#show", "-h", "--help"),

	DB_IMPORT_REF(SynchroImportReferentialAction.class.getName() + "#run", "--import-ref"),

	SERVER_START(SynchroHttpServer.class.getName() + "#start", "--start-server")

	/* DB_IMPORT_DATA(SynchroImportDataAction.class.getName() + "#run", "--import-data") */;

	public String action;
	public String[] aliases;

	private SynchroConfigurationAction(String action, String... aliases) {
		this.action = action;
		this.aliases = aliases;
	}

	@Override
	public String getAction() {
		return action;
	}

	@Override
	public String[] getAliases() {
		return aliases;
	}
}
