/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.runtime.shared;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.internal.RuntimeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandaloneRuntimeSupport
extends RuntimeSupport {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected StandaloneRuntimeSupport(String name, int priority) {
        super(name, StandaloneRuntimeSupport.discoverVersion(), priority, StandaloneRuntimeSupport.discoverMavenVersion());
    }

    private static String discoverVersion() {
        Map version = StandaloneRuntimeSupport.loadClasspathProperties((String)"/eu/maveniverse/maven/mima/runtime/shared/internal/version.properties");
        String result = (String)version.get("version");
        if (result == null || result.trim().isEmpty() || result.startsWith("${")) {
            return "(unknown)";
        }
        return result;
    }

    protected Context buildContext(StandaloneRuntimeSupport runtime, ContextOverrides overrides, RepositorySystem repositorySystem, SettingsBuilder settingsBuilder, SettingsDecrypter settingsDecrypter, ProfileSelector profileSelector, Runnable managedCloser) {
        try {
            Settings settings = this.newEffectiveSettings(overrides, settingsBuilder);
            DefaultRepositorySystemSession session = this.newRepositorySession(overrides, repositorySystem, settings, settingsDecrypter);
            ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
            if (overrides.isAppendRepositories() || overrides.getRepositories().isEmpty()) {
                remoteRepositories.add(ContextOverrides.CENTRAL);
                List<Profile> activeProfiles = this.activeProfilesByActivation(overrides, settings, profileSelector);
                for (Profile profile : activeProfiles) {
                    for (Repository repository : profile.getRepositories()) {
                        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl());
                        if (repository.getReleases() != null) {
                            builder.setReleasePolicy(new RepositoryPolicy(repository.getReleases().isEnabled(), "daily", "warn"));
                        } else {
                            builder.setReleasePolicy(new RepositoryPolicy());
                        }
                        if (repository.getSnapshots() != null) {
                            builder.setSnapshotPolicy(new RepositoryPolicy(repository.getSnapshots().isEnabled(), "daily", "warn"));
                        } else {
                            builder.setSnapshotPolicy(new RepositoryPolicy(false, null, null));
                        }
                        this.addReplace(remoteRepositories, builder.build());
                    }
                }
            }
            if (!overrides.getRepositories().isEmpty()) {
                if (!overrides.isAppendRepositories()) {
                    remoteRepositories.clear();
                }
                overrides.getRepositories().forEach(r -> this.addReplace((List<RemoteRepository>)remoteRepositories, (RemoteRepository)r));
            }
            return new Context((RuntimeSupport)runtime, overrides, repositorySystem, (RepositorySystemSession)session, repositorySystem.newResolutionRepositories((RepositorySystemSession)session, remoteRepositories), managedCloser);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create context from scratch", e);
        }
    }

    protected void addReplace(List<RemoteRepository> remoteRepositories, RemoteRepository repository) {
        remoteRepositories.removeIf(r -> Objects.equals(repository.getId(), r.getId()));
        remoteRepositories.add(repository);
    }

    protected Settings newEffectiveSettings(ContextOverrides overrides, SettingsBuilder settingsBuilder) throws SettingsBuildingException {
        if (!overrides.isWithUserSettings()) {
            return new Settings();
        }
        if (overrides.getEffectiveSettings() != null) {
            return (Settings)overrides.getEffectiveSettings();
        }
        DefaultSettingsBuildingRequest settingsBuilderRequest = new DefaultSettingsBuildingRequest();
        Properties systemProperties = new Properties();
        systemProperties.putAll((Map<?, ?>)overrides.getSystemProperties());
        settingsBuilderRequest.setSystemProperties(systemProperties);
        Properties userProperties = new Properties();
        userProperties.putAll((Map<?, ?>)overrides.getUserProperties());
        settingsBuilderRequest.setUserProperties(userProperties);
        if (overrides.getGlobalSettingsXmlOverride() != null) {
            settingsBuilderRequest.setGlobalSettingsFile(overrides.getGlobalSettingsXmlOverride().toFile());
        } else if (overrides.getMavenSystemHome() != null) {
            settingsBuilderRequest.setGlobalSettingsFile(overrides.getMavenSystemHome().settingsXml().toFile());
        }
        settingsBuilderRequest.setUserSettingsFile(overrides.getMavenUserHome().settingsXml().toFile());
        return settingsBuilder.build((SettingsBuildingRequest)settingsBuilderRequest).getEffectiveSettings();
    }

    protected List<Profile> activeProfilesByActivation(ContextOverrides overrides, Settings settings, ProfileSelector profileSelector) {
        if (profileSelector == null) {
            return this.activeProfiles(settings);
        }
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setProjectDirectory(overrides.getBasedir().toFile());
        context.setActiveProfileIds(Stream.concat(settings.getActiveProfiles().stream(), overrides.getActiveProfileIds().stream()).distinct().collect(Collectors.toList()));
        context.setInactiveProfileIds(overrides.getInactiveProfileIds());
        context.setSystemProperties(overrides.getSystemProperties());
        context.setUserProperties(overrides.getUserProperties());
        ModelProblemCollector collector = new ModelProblemCollector(){

            public void add(ModelProblemCollectorRequest req) {
            }
        };
        return profileSelector.getActiveProfiles((Collection)settings.getProfiles().stream().map(StandaloneRuntimeSupport::convertFromSettingsProfile).collect(Collectors.toList()), (ProfileActivationContext)context, collector).stream().map(StandaloneRuntimeSupport::convertToSettingsProfile).collect(Collectors.toList());
    }

    protected List<Profile> activeProfiles(Settings settings) {
        HashMap<String, Profile> result = new HashMap<String, Profile>();
        Map profileMap = settings.getProfilesAsMap();
        for (String profileId : settings.getActiveProfiles()) {
            Profile profile = (Profile)profileMap.get(profileId);
            if (profile == null) continue;
            result.put(profile.getId(), profile);
        }
        for (Profile profile : settings.getProfiles()) {
            org.apache.maven.settings.Activation activation = profile.getActivation();
            if (activation == null || !activation.isActiveByDefault()) continue;
            result.put(profile.getId(), profile);
        }
        return new ArrayList<Profile>(result.values());
    }

    protected DefaultRepositorySystemSession newRepositorySession(ContextOverrides overrides, RepositorySystem repositorySystem, Settings settings, SettingsDecrypter settingsDecrypter) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setCache((RepositoryCache)new DefaultRepositoryCache());
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>(overrides.getConfigProperties());
        configProps.put("aether.connector.userAgent", this.getUserAgent());
        List<Profile> activeProfiles = this.activeProfiles(settings);
        for (Profile profile : activeProfiles) {
            configProps.putAll(profile.getProperties());
        }
        configProps.put("aether.interactive", false);
        configProps.put("maven.startTime", new Date());
        session.setOffline(overrides.isOffline());
        this.customizeChecksumPolicy(overrides, session);
        this.customizeSnapshotUpdatePolicy(overrides, session);
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(false, false));
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies(settings.getProxies());
        decrypt.setServers(settings.getServers());
        SettingsDecryptionResult decrypted = settingsDecrypter.decrypt((SettingsDecryptionRequest)decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem problem : decrypted.getProblems()) {
                this.logger.debug(problem.getMessage(), (Throwable)problem.getException());
            }
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Object mirror : settings.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.isBlocked(), mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector((MirrorSelector)mirrorSelector);
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy : decrypted.getProxies()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            proxySelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authBuilder.build()), proxy.getNonProxyHosts());
        }
        session.setProxySelector((ProxySelector)proxySelector);
        DefaultAuthenticationSelector authSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            authSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                Xpp3Dom requestTimeoutXml;
                Xpp3Dom connectTimeoutXml;
                Xpp3Dom[] properties;
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                HashMap<String, String> headers = null;
                Integer connectTimeout = null;
                Integer requestTimeout = null;
                Xpp3Dom httpHeaders = dom.getChild("httpHeaders");
                if (httpHeaders != null && (properties = httpHeaders.getChildren("property")) != null && properties.length > 0) {
                    headers = new HashMap<String, String>();
                    for (Xpp3Dom property : properties) {
                        headers.put(property.getChild("name").getValue(), property.getChild("value").getValue());
                    }
                }
                if ((connectTimeoutXml = dom.getChild("connectTimeout")) != null) {
                    connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                }
                if ((requestTimeoutXml = dom.getChild("requestTimeout")) != null) {
                    requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                }
                if (headers != null) {
                    configProps.put("aether.connector.http.headers." + server.getId(), headers);
                }
                if (connectTimeout != null) {
                    configProps.put("aether.connector.connectTimeout." + server.getId(), connectTimeout);
                }
                if (requestTimeout != null) {
                    configProps.put("aether.connector.requestTimeout." + server.getId(), requestTimeout);
                }
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector((AuthenticationSelector)authSelector);
        session.setSystemProperties(overrides.getSystemProperties());
        session.setUserProperties(overrides.getUserProperties());
        session.setConfigProperties(configProps);
        if (overrides.getTransferListener() != null) {
            session.setTransferListener(overrides.getTransferListener());
        }
        if (overrides.getRepositoryListener() != null) {
            session.setRepositoryListener(overrides.getRepositoryListener());
        }
        this.newLocalRepositoryManager(overrides.getMavenUserHome().localRepository(), repositorySystem, session);
        return session;
    }

    protected String getUserAgent() {
        return "Apache-Maven/" + this.mavenVersion() + " (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "; MIMA " + this.version() + ")";
    }

    protected static Profile convertToSettingsProfile(org.apache.maven.model.Profile modelProfile) {
        List pluginRepos;
        Profile profile = new Profile();
        profile.setId(modelProfile.getId());
        Activation modelActivation = modelProfile.getActivation();
        if (modelActivation != null) {
            org.apache.maven.model.ActivationFile modelFile;
            ActivationOS modelOs;
            org.apache.maven.settings.Activation activation = new org.apache.maven.settings.Activation();
            activation.setActiveByDefault(modelActivation.isActiveByDefault());
            activation.setJdk(modelActivation.getJdk());
            ActivationProperty modelProp = modelActivation.getProperty();
            if (modelProp != null) {
                org.apache.maven.settings.ActivationProperty prop = new org.apache.maven.settings.ActivationProperty();
                prop.setName(modelProp.getName());
                prop.setValue(modelProp.getValue());
                activation.setProperty(prop);
            }
            if ((modelOs = modelActivation.getOs()) != null) {
                org.apache.maven.settings.ActivationOS os = new org.apache.maven.settings.ActivationOS();
                os.setArch(modelOs.getArch());
                os.setFamily(modelOs.getFamily());
                os.setName(modelOs.getName());
                os.setVersion(modelOs.getVersion());
                activation.setOs(os);
            }
            if ((modelFile = modelActivation.getFile()) != null) {
                ActivationFile file = new ActivationFile();
                file.setExists(modelFile.getExists());
                file.setMissing(modelFile.getMissing());
                activation.setFile(file);
            }
            profile.setActivation(activation);
        }
        profile.setProperties(modelProfile.getProperties());
        List repos = modelProfile.getRepositories();
        if (repos != null) {
            for (org.apache.maven.model.Repository repo : repos) {
                profile.addRepository(StandaloneRuntimeSupport.convertToSettingsRepository(repo));
            }
        }
        if ((pluginRepos = modelProfile.getPluginRepositories()) != null) {
            for (org.apache.maven.model.Repository pluginRepo : pluginRepos) {
                profile.addPluginRepository(StandaloneRuntimeSupport.convertToSettingsRepository(pluginRepo));
            }
        }
        return profile;
    }

    protected static org.apache.maven.model.Profile convertFromSettingsProfile(Profile settingsProfile) {
        List pluginRepos;
        org.apache.maven.model.Profile profile = new org.apache.maven.model.Profile();
        profile.setId(settingsProfile.getId());
        profile.setSource("settings.xml");
        org.apache.maven.settings.Activation settingsActivation = settingsProfile.getActivation();
        if (settingsActivation != null) {
            ActivationFile settingsFile;
            org.apache.maven.settings.ActivationOS settingsOs;
            Activation activation = new Activation();
            activation.setActiveByDefault(settingsActivation.isActiveByDefault());
            activation.setJdk(settingsActivation.getJdk());
            org.apache.maven.settings.ActivationProperty settingsProp = settingsActivation.getProperty();
            if (settingsProp != null) {
                ActivationProperty prop = new ActivationProperty();
                prop.setName(settingsProp.getName());
                prop.setValue(settingsProp.getValue());
                activation.setProperty(prop);
            }
            if ((settingsOs = settingsActivation.getOs()) != null) {
                ActivationOS os = new ActivationOS();
                os.setArch(settingsOs.getArch());
                os.setFamily(settingsOs.getFamily());
                os.setName(settingsOs.getName());
                os.setVersion(settingsOs.getVersion());
                activation.setOs(os);
            }
            if ((settingsFile = settingsActivation.getFile()) != null) {
                org.apache.maven.model.ActivationFile file = new org.apache.maven.model.ActivationFile();
                file.setExists(settingsFile.getExists());
                file.setMissing(settingsFile.getMissing());
                activation.setFile(file);
            }
            profile.setActivation(activation);
        }
        profile.setProperties(settingsProfile.getProperties());
        List repos = settingsProfile.getRepositories();
        if (repos != null) {
            for (Repository repo : repos) {
                profile.addRepository(StandaloneRuntimeSupport.convertFromSettingsRepository(repo));
            }
        }
        if ((pluginRepos = settingsProfile.getPluginRepositories()) != null) {
            for (Repository pluginRepo : pluginRepos) {
                profile.addPluginRepository(StandaloneRuntimeSupport.convertFromSettingsRepository(pluginRepo));
            }
        }
        return profile;
    }

    protected static org.apache.maven.model.Repository convertFromSettingsRepository(Repository settingsRepo) {
        org.apache.maven.model.Repository repo = new org.apache.maven.model.Repository();
        repo.setId(settingsRepo.getId());
        repo.setLayout(settingsRepo.getLayout());
        repo.setName(settingsRepo.getName());
        repo.setUrl(settingsRepo.getUrl());
        if (settingsRepo.getSnapshots() != null) {
            repo.setSnapshots(StandaloneRuntimeSupport.convertFromSettingsRepositoryPolicy(settingsRepo.getSnapshots()));
        }
        if (settingsRepo.getReleases() != null) {
            repo.setReleases(StandaloneRuntimeSupport.convertFromSettingsRepositoryPolicy(settingsRepo.getReleases()));
        }
        return repo;
    }

    protected static org.apache.maven.model.RepositoryPolicy convertFromSettingsRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy settingsPolicy) {
        org.apache.maven.model.RepositoryPolicy policy = new org.apache.maven.model.RepositoryPolicy();
        policy.setEnabled(settingsPolicy.isEnabled());
        policy.setUpdatePolicy(settingsPolicy.getUpdatePolicy());
        policy.setChecksumPolicy(settingsPolicy.getChecksumPolicy());
        return policy;
    }

    protected static Repository convertToSettingsRepository(org.apache.maven.model.Repository modelRepo) {
        Repository repo = new Repository();
        repo.setId(modelRepo.getId());
        repo.setLayout(modelRepo.getLayout());
        repo.setName(modelRepo.getName());
        repo.setUrl(modelRepo.getUrl());
        if (modelRepo.getSnapshots() != null) {
            repo.setSnapshots(StandaloneRuntimeSupport.convertToSettingsRepositoryPolicy(modelRepo.getSnapshots()));
        }
        if (modelRepo.getReleases() != null) {
            repo.setReleases(StandaloneRuntimeSupport.convertToSettingsRepositoryPolicy(modelRepo.getReleases()));
        }
        return repo;
    }

    protected static org.apache.maven.settings.RepositoryPolicy convertToSettingsRepositoryPolicy(org.apache.maven.model.RepositoryPolicy modelPolicy) {
        org.apache.maven.settings.RepositoryPolicy policy = new org.apache.maven.settings.RepositoryPolicy();
        policy.setEnabled(modelPolicy.isEnabled());
        policy.setUpdatePolicy(modelPolicy.getUpdatePolicy());
        policy.setChecksumPolicy(modelPolicy.getChecksumPolicy());
        return policy;
    }
}

