/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.runtime.maven;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.internal.RuntimeSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.eclipse.aether.RepositorySystem;

@Singleton
@Named
public final class MavenRuntime
extends RuntimeSupport {
    private final RepositorySystem repositorySystem;
    private final Provider<MavenSession> mavenSessionProvider;

    @Inject
    public MavenRuntime(RepositorySystem repositorySystem, Provider<MavenSession> mavenSessionProvider, RuntimeInformation rt) {
        super("embedded-maven", MavenRuntime.discoverArtifactVersion((String)"eu.maveniverse.maven.mima.runtime", (String)"embedded-maven", (String)"(unknown)"), 10, MavenRuntime.mavenVersion(rt));
        this.repositorySystem = repositorySystem;
        this.mavenSessionProvider = mavenSessionProvider;
    }

    private static String mavenVersion(RuntimeInformation runtimeInformation) {
        String mavenVersion = runtimeInformation.getMavenVersion();
        if (mavenVersion == null || mavenVersion.trim().isEmpty()) {
            return "(unknown)";
        }
        return mavenVersion;
    }

    public boolean managedRepositorySystem() {
        return false;
    }

    public Context create(ContextOverrides overrides) {
        MavenSession mavenSession = (MavenSession)this.mavenSessionProvider.get();
        return this.customizeContext(this, overrides, new Context((RuntimeSupport)this, overrides, this.repositorySystem, mavenSession.getRepositorySession(), mavenSession.getCurrentProject().getRemoteProjectRepositories(), null), false);
    }
}

