/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.javabean;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.javabean.BeanProperty;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PropertyDictionary {
    private final Map keyedByPropertyNameCache = Collections.synchronizedMap(new HashMap());

    public Iterator serializablePropertiesFor(Class cls) {
        return this.buildMap(cls).values().iterator();
    }

    public BeanProperty property(Class cls, String name) {
        Map properties = this.buildMap(cls);
        BeanProperty property = (BeanProperty)properties.get(name);
        if (property == null) {
            throw new ObjectAccessException("No such property " + cls.getName() + "." + name);
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildMap(Class cls) {
        String clsName = cls.getName();
        if (!this.keyedByPropertyNameCache.containsKey(clsName)) {
            Map map = this.keyedByPropertyNameCache;
            synchronized (map) {
                if (!this.keyedByPropertyNameCache.containsKey(clsName)) {
                    HashMap propertyMap = new HashMap();
                    Method[] methods = cls.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        BeanProperty property;
                        String propertyName;
                        if (!Modifier.isPublic(methods[i].getModifiers()) || Modifier.isStatic(methods[i].getModifiers())) continue;
                        String methodName = methods[i].getName();
                        Class<?>[] parameters = methods[i].getParameterTypes();
                        Class<?> returnType = methods[i].getReturnType();
                        if ((methodName.startsWith("get") || methodName.startsWith("is")) && parameters.length == 0 && returnType != Void.TYPE) {
                            propertyName = methodName.startsWith("get") ? Introspector.decapitalize(methodName.substring(3)) : Introspector.decapitalize(methodName.substring(2));
                            property = this.getBeanProperty(propertyMap, cls, propertyName, returnType);
                            property.setGetterMethod(methods[i]);
                            continue;
                        }
                        if (!methodName.startsWith("set") || parameters.length != 1 || returnType != Void.TYPE) continue;
                        propertyName = Introspector.decapitalize(methodName.substring(3));
                        property = this.getBeanProperty(propertyMap, cls, propertyName, parameters[0]);
                        property.setSetterMethod(methods[i]);
                    }
                    ArrayList<BeanProperty> serializableProperties = new ArrayList<BeanProperty>();
                    for (BeanProperty property : propertyMap.values()) {
                        if (!property.isReadable() || !property.isWritable()) continue;
                        serializableProperties.add(property);
                    }
                    Collections.sort(serializableProperties, new BeanPropertyComparator());
                    OrderRetainingMap keyedByFieldName = new OrderRetainingMap();
                    for (BeanProperty property : serializableProperties) {
                        keyedByFieldName.put(property.getName(), property);
                    }
                    this.keyedByPropertyNameCache.put(clsName, keyedByFieldName);
                }
            }
        }
        return (Map)this.keyedByPropertyNameCache.get(clsName);
    }

    private BeanProperty getBeanProperty(Map propertyMap, Class cls, String propertyName, Class type) {
        PropertyKey key = new PropertyKey(propertyName, type);
        BeanProperty property = (BeanProperty)propertyMap.get(key);
        if (property == null) {
            property = new BeanProperty(cls, propertyName, type);
            propertyMap.put(key, property);
        }
        return property;
    }

    private static class OrderRetainingMap
    extends HashMap {
        private List valueOrder = new ArrayList();

        private OrderRetainingMap() {
        }

        public Object put(Object key, Object value) {
            this.valueOrder.add(value);
            return super.put(key, value);
        }

        public Collection values() {
            return Collections.unmodifiableList(this.valueOrder);
        }
    }

    private static class BeanPropertyComparator
    implements Comparator {
        private BeanPropertyComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((BeanProperty)o1).getName().compareTo(((BeanProperty)o2).getName());
        }
    }

    private static class PropertyKey {
        private String propertyName;
        private Class propertyType;

        public PropertyKey(String propertyName, Class propertyType) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyKey)) {
                return false;
            }
            PropertyKey propertyKey = (PropertyKey)o;
            if (this.propertyName != null ? !this.propertyName.equals(propertyKey.propertyName) : propertyKey.propertyName != null) {
                return false;
            }
            return !(this.propertyType != null ? !this.propertyType.equals(propertyKey.propertyType) : propertyKey.propertyType != null);
        }

        public int hashCode() {
            int result = this.propertyName != null ? this.propertyName.hashCode() : 0;
            result = 29 * result + (this.propertyType != null ? this.propertyType.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PropertyKey{propertyName='" + this.propertyName + "'" + ", propertyType=" + this.propertyType + "}";
        }
    }
}

