/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetGrouperPrivilegesLiteResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetGrouperPrivilegesLiteRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcGetGrouperPrivilegesLite {
    private String groupName;
    private String privilegeType;
    private String privilegeName;
    private String stemName;
    private WsSubjectLookup subjectLookup = null;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private String clientVersion;

    public GcGetGrouperPrivilegesLite assignPrivilegeType(String thePrivilegeType) {
        this.privilegeType = thePrivilegeType;
        return this;
    }

    public GcGetGrouperPrivilegesLite assignPrivilegeName(String thePrivilegeName) {
        this.privilegeName = thePrivilegeName;
        return this;
    }

    public GcGetGrouperPrivilegesLite assignGroupName(String theGroupName) {
        this.groupName = theGroupName;
        return this;
    }

    public GcGetGrouperPrivilegesLite assignStemName(String theStemName) {
        this.stemName = theStemName;
        return this;
    }

    public GcGetGrouperPrivilegesLite addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetGrouperPrivilegesLite addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetGrouperPrivilegesLite assignSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.subjectLookup = wsSubjectLookup;
        return this;
    }

    public GcGetGrouperPrivilegesLite assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.params) > 2) {
            throw new RuntimeException("Params can only be size 2 for this request");
        }
    }

    public GcGetGrouperPrivilegesLite addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcGetGrouperPrivilegesLite assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcGetGrouperPrivilegesLite assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public GcGetGrouperPrivilegesLite assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsGetGrouperPrivilegesLiteResult execute() {
        this.validate();
        WsGetGrouperPrivilegesLiteResult wsGetGrouperPrivilegesLiteResult = null;
        try {
            WsRestGetGrouperPrivilegesLiteRequest wsGetGrouperPrivilegesLite = new WsRestGetGrouperPrivilegesLiteRequest();
            if (this.actAsSubject != null) {
                wsGetGrouperPrivilegesLite.setActAsSubjectId(this.actAsSubject.getSubjectId());
                wsGetGrouperPrivilegesLite.setActAsSubjectIdentifier(this.actAsSubject.getSubjectIdentifier());
                wsGetGrouperPrivilegesLite.setActAsSubjectSourceId(this.actAsSubject.getSubjectSourceId());
            }
            if (this.includeGroupDetail != null) {
                wsGetGrouperPrivilegesLite.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                wsGetGrouperPrivilegesLite.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            wsGetGrouperPrivilegesLite.setGroupName(this.groupName);
            wsGetGrouperPrivilegesLite.setStemName(this.stemName);
            wsGetGrouperPrivilegesLite.setPrivilegeType(this.privilegeType);
            wsGetGrouperPrivilegesLite.setPrivilegeName(this.privilegeName);
            if (this.subjectAttributeNames.size() > 0) {
                wsGetGrouperPrivilegesLite.setSubjectAttributeNames(GrouperClientUtils.join(this.subjectAttributeNames.iterator(), ','));
            }
            if (this.subjectLookup != null) {
                wsGetGrouperPrivilegesLite.setSubjectId(this.subjectLookup.getSubjectId());
                wsGetGrouperPrivilegesLite.setSubjectIdentifier(this.subjectLookup.getSubjectIdentifier());
                wsGetGrouperPrivilegesLite.setSubjectId(this.subjectLookup.getSubjectId());
            }
            if (this.params.size() > 0) {
                wsGetGrouperPrivilegesLite.setParamName0(this.params.get(0).getParamName());
                wsGetGrouperPrivilegesLite.setParamValue0(this.params.get(0).getParamValue());
            }
            if (this.params.size() > 1) {
                wsGetGrouperPrivilegesLite.setParamName1(this.params.get(1).getParamName());
                wsGetGrouperPrivilegesLite.setParamValue1(this.params.get(1).getParamValue());
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsGetGrouperPrivilegesLiteResult = (WsGetGrouperPrivilegesLiteResult)grouperClientWs.executeService("grouperPrivileges", wsGetGrouperPrivilegesLite, "getGrouperPrivilegesLite", this.clientVersion);
            String resultMessage = wsGetGrouperPrivilegesLiteResult.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetGrouperPrivilegesLiteResult, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetGrouperPrivilegesLiteResult;
    }
}

