/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient;

import edu.internet2.middleware.grouperClient.ClientOperation;
import edu.internet2.middleware.grouperClient.OperationParams;
import edu.internet2.middleware.grouperClient.api.GcAddMember;
import edu.internet2.middleware.grouperClient.api.GcAssignAttributes;
import edu.internet2.middleware.grouperClient.api.GcAssignGrouperPrivileges;
import edu.internet2.middleware.grouperClient.api.GcAssignGrouperPrivilegesLite;
import edu.internet2.middleware.grouperClient.api.GcAssignPermissions;
import edu.internet2.middleware.grouperClient.api.GcDeleteMember;
import edu.internet2.middleware.grouperClient.api.GcFindGroups;
import edu.internet2.middleware.grouperClient.api.GcFindStems;
import edu.internet2.middleware.grouperClient.api.GcGetAttributeAssignments;
import edu.internet2.middleware.grouperClient.api.GcGetGrouperPrivilegesLite;
import edu.internet2.middleware.grouperClient.api.GcGetGroups;
import edu.internet2.middleware.grouperClient.api.GcGetMembers;
import edu.internet2.middleware.grouperClient.api.GcGetMemberships;
import edu.internet2.middleware.grouperClient.api.GcGetPermissionAssignments;
import edu.internet2.middleware.grouperClient.api.GcGetSubjects;
import edu.internet2.middleware.grouperClient.api.GcGroupDelete;
import edu.internet2.middleware.grouperClient.api.GcGroupSave;
import edu.internet2.middleware.grouperClient.api.GcHasMember;
import edu.internet2.middleware.grouperClient.api.GcLdapSearchAttribute;
import edu.internet2.middleware.grouperClient.api.GcMemberChangeSubject;
import edu.internet2.middleware.grouperClient.api.GcStemDelete;
import edu.internet2.middleware.grouperClient.api.GcStemSave;
import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.commandLine.GcLdapSearchAttributeConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientCommonUtils;
import edu.internet2.middleware.grouperClient.util.GrouperClientLog;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.StemScope;
import edu.internet2.middleware.grouperClient.ws.WsMemberFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsAddMemberResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsAddMemberResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignAttributeResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignAttributesResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignGrouperPrivilegesLiteResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignGrouperPrivilegesResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignGrouperPrivilegesResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignPermissionResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignPermissionsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeAssign;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeAssignLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeAssignValue;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDef;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefName;
import edu.internet2.middleware.grouperClient.ws.beans.WsDeleteMemberResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsDeleteMemberResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsFindGroupsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsFindStemsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetAttributeAssignmentsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetGrouperPrivilegesLiteResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetGroupsResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetGroupsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembersResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembersResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembershipsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetPermissionAssignmentsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetSubjectsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupDeleteResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupDeleteResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupDetail;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupSaveResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupSaveResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupToSave;
import edu.internet2.middleware.grouperClient.ws.beans.WsGrouperPrivilegeResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsHasMemberResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsHasMemberResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsMemberChangeSubjectResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsMemberChangeSubjectResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsMembership;
import edu.internet2.middleware.grouperClient.ws.beans.WsMembershipAnyLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsPermissionAssign;
import edu.internet2.middleware.grouperClient.ws.beans.WsQueryFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsStem;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemDeleteResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemDeleteResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemQueryFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemSaveResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemSaveResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemToSave;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubject;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.Crypto;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrouperClient {
    private static long startTime = System.currentTimeMillis();
    static Log log = GrouperClientUtils.retrieveLog(GrouperClient.class);
    private static Map<String, GcLdapSearchAttributeConfig> ldapOperations = null;
    private static Map<String, Class<ClientOperation>> customOperations = null;
    public static boolean exitOnError = true;

    private static Map<String, Class<ClientOperation>> customOperations() {
        if (customOperations == null) {
            customOperations = new LinkedHashMap<String, Class<ClientOperation>>();
            int i = 0;
            String operationName = null;
            while (true) {
                operationName = null;
                operationName = GrouperClientUtils.propertiesValue("customOperation.name." + i, false);
                if (GrouperClientUtils.isBlank(operationName)) break;
                if (customOperations.containsKey(operationName)) {
                    throw new RuntimeException("There is an ldap operation defined twice in grouper.client.properties: '" + operationName + "'");
                }
                try {
                    String operationClassName = GrouperClientUtils.propertiesValue("customOperation.class." + i, true);
                    Class operationClass = GrouperClientUtils.forName(operationClassName);
                    customOperations.put(operationName, operationClass);
                }
                catch (RuntimeException re) {
                    throw new RuntimeException("Problem with custom operation: " + operationName, re);
                }
                ++i;
            }
        }
        return customOperations;
    }

    private static Map<String, GcLdapSearchAttributeConfig> ldapOperations() {
        if (ldapOperations == null) {
            String operationName;
            ldapOperations = new LinkedHashMap<String, GcLdapSearchAttributeConfig>();
            int i = 0;
            while (!GrouperClientUtils.isBlank(operationName = GrouperClientUtils.propertiesValue("ldapSearchAttribute.operationName." + i, false))) {
                if (ldapOperations.containsKey(operationName)) {
                    throw new RuntimeException("There is an ldap operation defined twice in grouper.client.properties: '" + operationName + "'");
                }
                GcLdapSearchAttributeConfig gcLdapSearchAttributeConfig = new GcLdapSearchAttributeConfig();
                gcLdapSearchAttributeConfig.setOperationName(operationName);
                gcLdapSearchAttributeConfig.setLdapName(GrouperClientUtils.propertiesValue("ldapSearchAttribute.ldapName." + i, true));
                String[] matchingAttributeLabels = GrouperClientUtils.splitTrim(GrouperClientUtils.propertiesValue("ldapSearchAttribute.matchingAttributeLabels." + i, true), ",");
                String[] ldapMatchingAttributes = GrouperClientUtils.splitTrim(GrouperClientUtils.propertiesValue("ldapSearchAttribute.matchingAttributes." + i, true), ",");
                if (matchingAttributeLabels.length != ldapMatchingAttributes.length) {
                    throw new RuntimeException("ldapSearchAttribute #" + i + " operation: " + operationName + " should have the same number of matchingAttributeLabels " + matchingAttributeLabels.length + " and matchingAttributes " + ldapMatchingAttributes.length);
                }
                for (int j = 0; j < matchingAttributeLabels.length; ++j) {
                    gcLdapSearchAttributeConfig.addMatchingAttribute(matchingAttributeLabels[j], ldapMatchingAttributes[j]);
                }
                String[] ldapReturningAttributes = GrouperClientUtils.splitTrim(GrouperClientUtils.propertiesValue("ldapSearchAttribute.returningAttributes." + i, true), ",");
                for (int j = 0; j < ldapReturningAttributes.length; ++j) {
                    gcLdapSearchAttributeConfig.addReturningAttribute(ldapReturningAttributes[j]);
                }
                gcLdapSearchAttributeConfig.setOutputTemplate(GrouperClientUtils.propertiesValue("ldapSearchAttribute.outputTemplate." + i, true));
                gcLdapSearchAttributeConfig.setSearchAttributeResultType(GrouperClientUtils.propertiesValue("ldapSearchAttribute.resultType." + i, true));
                ldapOperations.put(operationName, gcLdapSearchAttributeConfig);
                ++i;
            }
        }
        return ldapOperations;
    }

    public static void main(String[] args) {
        String operation = null;
        try {
            boolean shouldSaveResultsToFile;
            if (GrouperClientUtils.length(args) == 0) {
                GrouperClient.usage();
                return;
            }
            Map<String, String> argMap = GrouperClientUtils.argMap(args);
            LinkedHashMap<String, String> argMapNotUsed = new LinkedHashMap<String, String>(argMap);
            boolean debugMode = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "debug", false, false);
            GrouperClientLog.assignDebugToConsole(debugMode);
            GrouperClientUtils.grouperClientProperties();
            StringBuilder callingLog = new StringBuilder();
            GrouperClientUtils.propertiesFromResourceName("grouper.client.properties", false, true, GrouperClientCommonUtils.class, callingLog);
            operation = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "operation", true);
            String saveResultsToFile = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "saveResultsToFile", false);
            boolean bl = shouldSaveResultsToFile = !GrouperClientUtils.isBlank(saveResultsToFile);
            if (shouldSaveResultsToFile) {
                log.debug("Will save results to file: " + GrouperClientUtils.fileCanonicalPath(new File(saveResultsToFile)));
            }
            String result = null;
            if (GrouperClient.customOperations().containsKey(operation)) {
                Class<ClientOperation> operationClass = GrouperClient.customOperations().get(operation);
                ClientOperation clientOperation = GrouperClientUtils.newInstance(operationClass);
                OperationParams operationParams = new OperationParams();
                operationParams.setArgMap(argMap);
                operationParams.setArgMapNotUsed(argMapNotUsed);
                operationParams.setShouldSaveResultsToFile(shouldSaveResultsToFile);
                result = clientOperation.operate(operationParams);
            } else if (GrouperClientUtils.equals(operation, "encryptPassword")) {
                result = GrouperClient.encryptText(argMap, argMapNotUsed, shouldSaveResultsToFile);
            } else if (GrouperClient.ldapOperations().containsKey(operation)) {
                result = GrouperClient.ldapSearchAttribute(argMap, argMapNotUsed, operation);
            } else if (GrouperClientUtils.equals(operation, "addMemberWs")) {
                result = GrouperClient.addMember(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "deleteMemberWs")) {
                result = GrouperClient.deleteMember(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "getMembersWs")) {
                result = GrouperClient.getMembers(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "getMembershipsWs")) {
                result = GrouperClient.getMemberships(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "getAttributeAssignmentsWs")) {
                result = GrouperClient.getAttributeAssignments(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "getPermissionAssignmentsWs")) {
                result = GrouperClient.getPermissionAssignments(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "assignAttributesWs")) {
                result = GrouperClient.assignAttributes(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "assignPermissionsWs")) {
                result = GrouperClient.assignPermissions(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "getSubjectsWs")) {
                result = GrouperClient.getSubjects(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "hasMemberWs")) {
                result = GrouperClient.hasMember(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "getGroupsWs")) {
                result = GrouperClient.getGroups(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "groupSaveWs")) {
                result = GrouperClient.groupSave(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "stemSaveWs")) {
                result = GrouperClient.stemSave(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "groupDeleteWs")) {
                result = GrouperClient.groupDelete(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "stemDeleteWs")) {
                result = GrouperClient.stemDelete(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "getGrouperPrivilegesLiteWs")) {
                result = GrouperClient.getGrouperPrivilegesLite(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "assignGrouperPrivilegesLiteWs")) {
                result = GrouperClient.assignGrouperPrivilegesLite(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "assignGrouperPrivilegesWs")) {
                result = GrouperClient.assignGrouperPrivileges(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "findGroupsWs")) {
                result = GrouperClient.findGroups(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "findStemsWs")) {
                result = GrouperClient.findStems(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "memberChangeSubjectWs")) {
                result = GrouperClient.memberChangeSubject(argMap, argMapNotUsed);
            } else if (GrouperClientUtils.equals(operation, "sendFile")) {
                result = GrouperClient.sendFile(argMap, argMapNotUsed);
            } else {
                System.err.println("Error: invalid operation: '" + operation + "', for usage help, run: java -jar grouperClient.jar");
                if (exitOnError) {
                    System.exit(1);
                }
                throw new RuntimeException("Invalid usage");
            }
            if (shouldSaveResultsToFile) {
                GrouperClientUtils.saveStringIntoFile(new File(saveResultsToFile), result);
            } else {
                System.out.print(result);
            }
            GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        }
        catch (Exception e) {
            System.err.println("Error with grouper client, check the logs: " + e.getMessage());
            log.fatal(e.getMessage(), e);
            if (exitOnError) {
                System.exit(1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                log.debug("Elapsed time: " + (System.currentTimeMillis() - startTime) + "ms");
            }
            catch (Exception e) {}
            GrouperClientLog.assignDebugToConsole(false);
        }
    }

    private static void failOnArgsNotUsed(Map<String, String> argMapNotUsed) {
        if (argMapNotUsed.size() > 0) {
            boolean failOnExtraParams = GrouperClientUtils.propertiesValueBoolean("grouperClient.failOnExtraCommandLineArgs", true, true);
            String error = "Invalid command line arguments: " + argMapNotUsed.keySet();
            if (failOnExtraParams) {
                throw new RuntimeException(error);
            }
            log.error(error);
        }
    }

    private static String encryptText(Map<String, String> argMap, Map<String, String> argMapNotUsed, boolean shouldSaveResultsToFile) {
        boolean dontMask = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "dontMask", false, false);
        String encryptKey = GrouperClientUtils.propertiesValue("encrypt.key", true);
        boolean disableExternalFileLookup = GrouperClientUtils.propertiesValueBoolean("encrypt.disableExternalFileLookup", false, true);
        encryptKey = GrouperClientUtils.readFromFileIfFile(encryptKey, disableExternalFileLookup);
        String password = GrouperClientUtils.retrievePasswordFromStdin(dontMask, "Type the string to encrypt (note: pasting might echo it back): ");
        String encrypted = new Crypto(encryptKey).encrypt(password);
        if (shouldSaveResultsToFile) {
            return encrypted;
        }
        return "Encrypted password: " + encrypted;
    }

    public static String ldapSearchAttribute(Map<String, String> argMap, Map<String, String> argMapNotUsed, String operation) {
        GcLdapSearchAttributeConfig gcLdapSearchAttributeConfig = GrouperClient.ldapOperations().get(operation);
        GcLdapSearchAttribute gcLdapSearchAttribute = new GcLdapSearchAttribute();
        gcLdapSearchAttribute.assignLdapName(gcLdapSearchAttributeConfig.getLdapName());
        for (String matchingAttributeLabel : gcLdapSearchAttributeConfig.getMatchingAttributes().keySet()) {
            String matchingAttributeValue = GrouperClientUtils.argMapString(argMap, argMapNotUsed, matchingAttributeLabel, true);
            gcLdapSearchAttribute.addMatchingAttribute(gcLdapSearchAttributeConfig.getMatchingAttributes().get(matchingAttributeLabel), matchingAttributeValue);
        }
        for (String ldapAttribute : gcLdapSearchAttributeConfig.getReturningAttributes()) {
            gcLdapSearchAttribute.addReturningAttribute(ldapAttribute);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        gcLdapSearchAttribute.execute();
        GcLdapSearchAttributeConfig.SearchAttributeResultType searchAttributeResultType = gcLdapSearchAttributeConfig.getSearchAttributeResultTypeEnum();
        log.debug("LDAP search attribute result type: " + (Object)((Object)searchAttributeResultType));
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = gcLdapSearchAttributeConfig.getOutputTemplate();
        }
        log.debug("Output template: " + outputTemplate);
        String results = searchAttributeResultType.processOutput(gcLdapSearchAttributeConfig, gcLdapSearchAttribute, outputTemplate);
        return results;
    }

    private static String addMember(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName", false);
        String groupUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupUuid", false);
        String fieldName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "fieldName", false);
        String txType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "txType", false);
        Boolean replaceAllExisting = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "replaceAllExisting");
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcAddMember gcAddMember = new GcAddMember();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcAddMember.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcAddMember.addParam(param);
        }
        List<WsSubjectLookup> wsSubjectLookupList = GrouperClient.retrieveSubjectsFromArgs(argMap, argMapNotUsed, true);
        for (WsSubjectLookup wsSubjectLookup : wsSubjectLookupList) {
            gcAddMember.addSubjectLookup(wsSubjectLookup);
        }
        gcAddMember.assignGroupName(groupName);
        gcAddMember.assignGroupUuid(groupUuid);
        Timestamp disabledTime = GrouperClientUtils.argMapTimestamp(argMap, argMapNotUsed, "disabledTime");
        gcAddMember.assignDisabledTime(disabledTime);
        Timestamp enabledTime = GrouperClientUtils.argMapTimestamp(argMap, argMapNotUsed, "enabledTime");
        gcAddMember.assignEnabledTime(enabledTime);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcAddMember.assignActAsSubject(actAsSubject);
        gcAddMember.assignReplaceAllExisting(replaceAllExisting);
        gcAddMember.assignIncludeGroupDetail(includeGroupDetail);
        gcAddMember.assignIncludeSubjectDetail(includeSubjectDetail);
        gcAddMember.assignFieldName(fieldName);
        gcAddMember.assignTxType(GcTransactionType.valueOfIgnoreCase(txType));
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcAddMember.addSubjectAttributeName(subjectAttribute);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsAddMemberResults wsAddMemberResults = gcAddMember.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsAddMemberResults", wsAddMemberResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        substituteMap.put("wsGroupAssigned", wsAddMemberResults.getWsGroupAssigned());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.addMember.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsAddMemberResults, " + "grouperClientUtils, wsGroupAssigned, index, wsAddMemberResult, wsSubject, resultMetadata");
        for (WsAddMemberResult wsAddMemberResult : wsAddMemberResults.getResults()) {
            substituteMap.put("index", index);
            substituteMap.put("wsAddMemberResult", wsAddMemberResult);
            substituteMap.put("wsSubject", wsAddMemberResult.getWsSubject());
            substituteMap.put("resultMetadata", wsAddMemberResult.getResultMetadata());
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String memberChangeSubject(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcMemberChangeSubject gcMemberChangeSubject = new GcMemberChangeSubject();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcMemberChangeSubject.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcMemberChangeSubject.addParam(param);
        }
        Boolean deleteOldMember = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "deleteOldMember");
        if (deleteOldMember != null) {
            gcMemberChangeSubject.assignDeleteOldMember(deleteOldMember);
        }
        WsSubjectLookup oldSubjectLookup = GrouperClient.retrieveSuffixSubjectFromArgs(argMap, argMapNotUsed, "old", true);
        WsSubjectLookup newSubjectLookup = GrouperClient.retrieveSuffixSubjectFromArgs(argMap, argMapNotUsed, "new", true);
        gcMemberChangeSubject.assignOldSubjectLookup(oldSubjectLookup);
        gcMemberChangeSubject.assignNewSubjectLookup(newSubjectLookup);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcMemberChangeSubject.assignActAsSubject(actAsSubject);
        gcMemberChangeSubject.assignIncludeSubjectDetail(includeSubjectDetail);
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcMemberChangeSubject.addSubjectAttributeName(subjectAttribute);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsMemberChangeSubjectResults wsMemberChangeSubjectResults = gcMemberChangeSubject.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsMemberChangeSubjectResults", wsMemberChangeSubjectResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.memberChangeSubject.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsMemberChangeSubjectResults, " + "grouperClientUtils, index, resultMetadata, wsMemberChangeSubjectResult, wsSubjectOld, wsSubjectNew");
        for (WsMemberChangeSubjectResult wsMemberChangeSubjectResult : wsMemberChangeSubjectResults.getResults()) {
            substituteMap.put("index", index);
            substituteMap.put("resultMetadata", wsMemberChangeSubjectResult.getResultMetadata());
            substituteMap.put("wsMemberChangeSubjectResult", wsMemberChangeSubjectResult);
            substituteMap.put("wsSubjectOld", wsMemberChangeSubjectResult.getWsSubjectOld());
            substituteMap.put("wsSubjectNew", wsMemberChangeSubjectResult.getWsSubjectNew());
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String sendFile(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        String fileContents = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "fileContents", false);
        String theFileName = "[contents on command line]";
        if (GrouperClientUtils.isBlank(fileContents)) {
            String fileName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "fileName", true);
            fileContents = GrouperClientUtils.readFileIntoString(new File(fileName));
            theFileName = GrouperClientUtils.fileCanonicalPath(new File(fileName));
        }
        if (fileContents.startsWith("POST") || fileContents.startsWith("GET") || fileContents.startsWith("PUT") || fileContents.startsWith("DELETE") || fileContents.startsWith("Connection:")) {
            throw new RuntimeException("The file is detected as containing HTTP headers, it should only contain the payload (e.g. the XML): " + theFileName);
        }
        String urlSuffix = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "urlSuffix", true);
        String labelForLog = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "labelForLog", false);
        labelForLog = GrouperClientUtils.defaultIfBlank(labelForLog, "sendFile");
        boolean indentOutput = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "indentOutput", false, true);
        String contentType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "contentType", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        GrouperClientWs grouperClientWs = new GrouperClientWs();
        if (GrouperClientUtils.isNotBlank(contentType)) {
            grouperClientWs.assignContentType(contentType);
        }
        try {
            String results = (String)grouperClientWs.executeService(urlSuffix, fileContents, labelForLog, clientVersion);
            if (indentOutput) {
                results = GrouperClientUtils.indent(results, false);
            }
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getGrouperPrivilegesLite(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName", false);
        String stemName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemName", false);
        String privilegeType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "privilegeType", false);
        String privilegeName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "privilegeName", false);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcGetGrouperPrivilegesLite gcGetGrouperPrivilegesLite = new GcGetGrouperPrivilegesLite();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcGetGrouperPrivilegesLite.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcGetGrouperPrivilegesLite.addParam(param);
        }
        WsSubjectLookup wsSubjectLookup = GrouperClient.retrieveSubjectFromArgs(argMap, argMapNotUsed);
        gcGetGrouperPrivilegesLite.assignStemName(stemName);
        gcGetGrouperPrivilegesLite.assignPrivilegeType(privilegeType);
        gcGetGrouperPrivilegesLite.assignPrivilegeName(privilegeName);
        gcGetGrouperPrivilegesLite.assignSubjectLookup(wsSubjectLookup);
        gcGetGrouperPrivilegesLite.assignGroupName(groupName);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcGetGrouperPrivilegesLite.assignActAsSubject(actAsSubject);
        gcGetGrouperPrivilegesLite.assignIncludeGroupDetail(includeGroupDetail);
        gcGetGrouperPrivilegesLite.assignIncludeSubjectDetail(includeSubjectDetail);
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcGetGrouperPrivilegesLite.addSubjectAttributeName(subjectAttribute);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsGetGrouperPrivilegesLiteResult wsGetGrouperPrivilegesLiteResult = gcGetGrouperPrivilegesLite.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsGetGrouperPrivilegesLiteResult", wsGetGrouperPrivilegesLiteResult);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        substituteMap.put("resultMetadata", wsGetGrouperPrivilegesLiteResult.getResultMetadata());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.getGrouperPrivilegesLite.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsGetGrouperPrivilegesLiteResult, " + "grouperClientUtils, resultMetadata, index, wsGrouperPrivilegeResult, wsSubject, wsGroup, wsStem, objectType, objectName");
        for (WsGrouperPrivilegeResult wsGrouperPrivilegeResult : GrouperClientUtils.nonNull(wsGetGrouperPrivilegesLiteResult.getPrivilegeResults(), WsGrouperPrivilegeResult.class)) {
            substituteMap.put("index", index);
            substituteMap.put("wsGrouperPrivilegeResult", wsGrouperPrivilegeResult);
            substituteMap.put("wsSubject", wsGrouperPrivilegeResult.getWsSubject());
            substituteMap.put("wsGroup", wsGrouperPrivilegeResult.getWsGroup());
            substituteMap.put("wsStem", wsGrouperPrivilegeResult.getWsStem());
            substituteMap.put("objectType", wsGrouperPrivilegeResult.getWsStem() == null ? "group" : "stem");
            substituteMap.put("objectName", wsGrouperPrivilegeResult.getWsStem() == null ? wsGrouperPrivilegeResult.getWsGroup().getName() : wsGrouperPrivilegeResult.getWsStem().getName());
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String assignGrouperPrivilegesLite(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName", false);
        String stemName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemName", false);
        String privilegeType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "privilegeType", false);
        String privilegeName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "privilegeName", true);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        boolean allowed = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "allowed", true, true);
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcAssignGrouperPrivilegesLite gcAssignGrouperPrivilegesLite = new GcAssignGrouperPrivilegesLite();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcAssignGrouperPrivilegesLite.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcAssignGrouperPrivilegesLite.addParam(param);
        }
        WsSubjectLookup wsSubjectLookup = GrouperClient.retrieveSubjectFromArgs(argMap, argMapNotUsed);
        gcAssignGrouperPrivilegesLite.assignStemName(stemName);
        gcAssignGrouperPrivilegesLite.assignPrivilegeType(privilegeType);
        gcAssignGrouperPrivilegesLite.assignPrivilegeName(privilegeName);
        gcAssignGrouperPrivilegesLite.assignSubjectLookup(wsSubjectLookup);
        gcAssignGrouperPrivilegesLite.assignAllowed(allowed);
        gcAssignGrouperPrivilegesLite.assignGroupName(groupName);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcAssignGrouperPrivilegesLite.assignActAsSubject(actAsSubject);
        gcAssignGrouperPrivilegesLite.assignIncludeGroupDetail(includeGroupDetail);
        gcAssignGrouperPrivilegesLite.assignIncludeSubjectDetail(includeSubjectDetail);
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcAssignGrouperPrivilegesLite.addSubjectAttributeName(subjectAttribute);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsAssignGrouperPrivilegesLiteResult wsAssignGrouperPrivilegesLiteResult = gcAssignGrouperPrivilegesLite.execute();
        StringBuilder result = new StringBuilder();
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsAssignGrouperPrivilegesLiteResult", wsAssignGrouperPrivilegesLiteResult);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.assignGrouperPrivilegesLite.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsAssignGrouperPrivilegesLiteResult, " + "grouperClientUtils, wsSubject, resultMetadata, wsGroup, wsStem, objectType, objectName");
        substituteMap.put("wsSubject", wsAssignGrouperPrivilegesLiteResult.getWsSubject());
        substituteMap.put("resultMetadata", wsAssignGrouperPrivilegesLiteResult.getResultMetadata());
        substituteMap.put("wsGroup", wsAssignGrouperPrivilegesLiteResult.getWsGroup());
        substituteMap.put("wsStem", wsAssignGrouperPrivilegesLiteResult.getWsStem());
        substituteMap.put("objectType", wsAssignGrouperPrivilegesLiteResult.getWsStem() == null ? "group" : "stem");
        substituteMap.put("objectName", wsAssignGrouperPrivilegesLiteResult.getWsStem() == null ? wsAssignGrouperPrivilegesLiteResult.getWsGroup().getName() : wsAssignGrouperPrivilegesLiteResult.getWsStem().getName());
        String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
        result.append(output);
        return result.toString();
    }

    private static String groupDelete(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        List<String> groupNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "groupNames", true);
        String txType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "txType", false);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcGroupDelete gcGroupDelete = new GcGroupDelete();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcGroupDelete.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcGroupDelete.addParam(param);
        }
        for (String groupName : groupNames) {
            WsGroupLookup wsGroupLookup = new WsGroupLookup(groupName, null);
            gcGroupDelete.addGroupLookup(wsGroupLookup);
        }
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcGroupDelete.assignActAsSubject(actAsSubject);
        gcGroupDelete.assignIncludeGroupDetail(includeGroupDetail);
        gcGroupDelete.assignTxType(GcTransactionType.valueOfIgnoreCase(txType));
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsGroupDeleteResults wsGroupDeleteResults = gcGroupDelete.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsGroupDeleteResults", wsGroupDeleteResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.groupDelete.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsGroupDeleteResults, " + "grouperClientUtils, index, wsGroupDeleteResult, resultMetadata, wsGroup");
        for (WsGroupDeleteResult wsGroupDeleteResult : wsGroupDeleteResults.getResults()) {
            substituteMap.put("index", index);
            substituteMap.put("wsGroupDeleteResult", wsGroupDeleteResult);
            substituteMap.put("resultMetadata", wsGroupDeleteResult.getResultMetadata());
            substituteMap.put("wsGroup", wsGroupDeleteResult.getWsGroup());
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String stemDelete(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        List<String> stemNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "stemNames", true);
        String txType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "txType", false);
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcStemDelete gcStemDelete = new GcStemDelete();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcStemDelete.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcStemDelete.addParam(param);
        }
        for (String stemName : stemNames) {
            WsStemLookup wsStemLookup = new WsStemLookup(stemName, null);
            gcStemDelete.addStemLookup(wsStemLookup);
        }
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcStemDelete.assignActAsSubject(actAsSubject);
        gcStemDelete.assignTxType(GcTransactionType.valueOfIgnoreCase(txType));
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsStemDeleteResults wsStemDeleteResults = gcStemDelete.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsStemDeleteResults", wsStemDeleteResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.stemDelete.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsStemDeleteResults, " + "grouperClientUtils, resultMetadata, index, wsStemDeleteResult, wsStem");
        for (WsStemDeleteResult wsStemDeleteResult : wsStemDeleteResults.getResults()) {
            substituteMap.put("resultMetadata", wsStemDeleteResult.getResultMetadata());
            substituteMap.put("index", index);
            substituteMap.put("wsStemDeleteResult", wsStemDeleteResult);
            substituteMap.put("wsStem", wsStemDeleteResult.getWsStem());
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String groupSave(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String displayExtension;
        String description;
        String txType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "txType", false);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcGroupSave gcGroupSave = new GcGroupSave();
        for (WsParam param : params) {
            gcGroupSave.addParam(param);
        }
        WsGroupToSave wsGroupToSave = new WsGroupToSave();
        gcGroupSave.addGroupToSave(wsGroupToSave);
        WsGroup wsGroup = new WsGroup();
        wsGroupToSave.setWsGroup(wsGroup);
        String groupLookupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupLookupName", false);
        String groupLookupUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupLookupUuid", false);
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcGroupSave.assignClientVersion(clientVersion);
        String name = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "name", true);
        wsGroup.setName(name);
        WsGroupLookup wsGroupLookup = new WsGroupLookup();
        wsGroupToSave.setWsGroupLookup(wsGroupLookup);
        if (!GrouperClientUtils.isBlank(groupLookupName) || !GrouperClientUtils.isBlank(groupLookupUuid)) {
            if (!GrouperClientUtils.isBlank(groupLookupName)) {
                wsGroupLookup.setGroupName(groupLookupName);
            }
            if (!GrouperClientUtils.isBlank(groupLookupUuid)) {
                wsGroupLookup.setUuid(groupLookupUuid);
            }
        } else {
            wsGroupLookup.setGroupName(name);
        }
        String createParentStemsIfNotExist = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "createParentStemsIfNotExist", false);
        wsGroupToSave.setCreateParentStemsIfNotExist(createParentStemsIfNotExist);
        String saveMode = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "saveMode", false);
        if (saveMode != null) {
            wsGroupToSave.setSaveMode(saveMode);
        }
        if (!GrouperClientUtils.isBlank(description = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "description", false))) {
            wsGroup.setDescription(description);
        }
        if (GrouperClientUtils.isBlank(displayExtension = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "displayExtension", false))) {
            displayExtension = GrouperClientUtils.substringAfterLast(name, ":");
        }
        wsGroup.setDisplayExtension(displayExtension);
        boolean hasAttribute0 = GrouperClientUtils.isNotBlank(GrouperClientUtils.argMapString(argMap, argMapNotUsed, "attributeName0", false));
        boolean hasGroupDetailParamName0 = GrouperClientUtils.isNotBlank(GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupDetailParamName0", false));
        boolean hasCompositeType = GrouperClientUtils.isNotBlank(GrouperClientUtils.argMapString(argMap, argMapNotUsed, "compositeType", false));
        boolean hasLeftGroupName = GrouperClientUtils.isNotBlank(GrouperClientUtils.argMapString(argMap, argMapNotUsed, "leftGroupName", false));
        boolean hasRightGroupName = GrouperClientUtils.isNotBlank(GrouperClientUtils.argMapString(argMap, argMapNotUsed, "rightGroupName", false));
        boolean hasTypeNames = GrouperClientUtils.isNotBlank(GrouperClientUtils.argMapString(argMap, argMapNotUsed, "typeNames", false));
        if (hasAttribute0 || hasGroupDetailParamName0 || hasCompositeType || hasLeftGroupName || hasRightGroupName || hasTypeNames) {
            int i;
            WsGroupDetail wsGroupDetail = new WsGroupDetail();
            wsGroup.setDetail(wsGroupDetail);
            if (hasAttribute0) {
                String attributeName;
                i = 0;
                ArrayList<String> attributeNameList = new ArrayList<String>();
                ArrayList<String> attributeValueList = new ArrayList<String>();
                while (!GrouperClientUtils.isBlank(attributeName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "attributeName" + i, false))) {
                    String attributeValue = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "attributeValue" + i, true);
                    attributeNameList.add(attributeName);
                    attributeValueList.add(attributeValue);
                    ++i;
                }
                wsGroupDetail.setAttributeNames(GrouperClientUtils.toArray(attributeNameList, String.class));
                wsGroupDetail.setAttributeValues(GrouperClientUtils.toArray(attributeValueList, String.class));
            }
            if (hasGroupDetailParamName0) {
                String paramName;
                i = 0;
                ArrayList<WsParam> paramList = new ArrayList<WsParam>();
                while (!GrouperClientUtils.isBlank(paramName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupDetailParamName" + i, false))) {
                    String paramValue = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupDetailParamValue" + i, true);
                    paramList.add(new WsParam(paramName, paramValue));
                    ++i;
                }
                wsGroupDetail.setParams(GrouperClientUtils.toArray(paramList, WsParam.class));
            }
            if (hasCompositeType) {
                wsGroupDetail.setHasComposite("T");
                String compositeType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "compositeType", true);
                wsGroupDetail.setCompositeType(compositeType);
                String leftGroupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "leftGroupName", true);
                WsGroup leftGroup = new WsGroup();
                leftGroup.setName(leftGroupName);
                wsGroupDetail.setLeftGroup(leftGroup);
                String rightGroupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "rightGroupName", true);
                WsGroup rightGroup = new WsGroup();
                rightGroup.setName(rightGroupName);
                wsGroupDetail.setRightGroup(rightGroup);
            }
            if (hasTypeNames) {
                List<String> typeNamesList = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "typeNames", true);
                String[] typeNamesArray = GrouperClientUtils.toArray(typeNamesList, String.class);
                wsGroupDetail.setTypeNames(typeNamesArray);
            }
        }
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcGroupSave.assignActAsSubject(actAsSubject);
        gcGroupSave.assignIncludeGroupDetail(includeGroupDetail);
        gcGroupSave.assignTxType(GcTransactionType.valueOfIgnoreCase(txType));
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsGroupSaveResults wsGroupSaveResults = gcGroupSave.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsGroupSaveResults", wsGroupSaveResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.groupSave.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsGroupSaveResults, " + "grouperClientUtils, index, wsGroupSaveResult, resultMetadata");
        for (WsGroupSaveResult wsGroupSaveResult : wsGroupSaveResults.getResults()) {
            substituteMap.put("index", index);
            substituteMap.put("wsGroupSaveResult", wsGroupSaveResult);
            substituteMap.put("resultMetadata", wsGroupSaveResult.getResultMetadata());
            wsGroupSaveResult.getWsGroup();
            substituteMap.put("wsGroup", wsGroup);
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String stemSave(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String displayExtension;
        String description;
        String txType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "txType", false);
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcStemSave gcStemSave = new GcStemSave();
        for (WsParam param : params) {
            gcStemSave.addParam(param);
        }
        WsStemToSave wsStemToSave = new WsStemToSave();
        gcStemSave.addStemToSave(wsStemToSave);
        WsStem wsStem = new WsStem();
        wsStemToSave.setWsStem(wsStem);
        String stemLookupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemLookupName", false);
        String stemLookupUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemLookupUuid", false);
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcStemSave.assignClientVersion(clientVersion);
        String name = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "name", true);
        wsStem.setName(name);
        WsStemLookup wsStemLookup = new WsStemLookup();
        wsStemToSave.setWsStemLookup(wsStemLookup);
        if (!GrouperClientUtils.isBlank(stemLookupName) || !GrouperClientUtils.isBlank(stemLookupUuid)) {
            if (!GrouperClientUtils.isBlank(stemLookupName)) {
                wsStemLookup.setStemName(stemLookupName);
            }
            if (!GrouperClientUtils.isBlank(stemLookupUuid)) {
                wsStemLookup.setUuid(stemLookupUuid);
            }
        } else {
            wsStemLookup.setStemName(name);
        }
        String createParentStemsIfNotExist = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "createParentStemsIfNotExist", false);
        wsStemToSave.setCreateParentStemsIfNotExist(createParentStemsIfNotExist);
        String saveMode = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "saveMode", false);
        if (saveMode != null) {
            wsStemToSave.setSaveMode(saveMode);
        }
        if (!GrouperClientUtils.isBlank(description = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "description", false))) {
            wsStem.setDescription(description);
        }
        if (GrouperClientUtils.isBlank(displayExtension = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "displayExtension", false))) {
            displayExtension = GrouperClientUtils.substringAfterLast(name, ":");
        }
        wsStem.setDisplayExtension(displayExtension);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcStemSave.assignActAsSubject(actAsSubject);
        gcStemSave.assignTxType(GcTransactionType.valueOfIgnoreCase(txType));
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsStemSaveResults wsStemSaveResults = gcStemSave.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsStemSaveResults", wsStemSaveResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.stemSave.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsStemSaveResults, " + "grouperClientUtils, index, wsStemSaveResult, wsStem, resultMetadata");
        for (WsStemSaveResult wsStemSaveResult : wsStemSaveResults.getResults()) {
            substituteMap.put("index", index);
            substituteMap.put("wsStemSaveResult", wsStemSaveResult);
            substituteMap.put("wsStem", wsStemSaveResult.getWsStem());
            substituteMap.put("resultMetadata", wsStemSaveResult.getResultMetadata());
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String hasMember(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName", false);
        String groupUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupUuid", false);
        String fieldName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "fieldName", false);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        String memberFilter = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "memberFilter", false);
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcHasMember gcHasMember = new GcHasMember();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcHasMember.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcHasMember.addParam(param);
        }
        List<WsSubjectLookup> wsSubjectLookupList = GrouperClient.retrieveSubjectsFromArgs(argMap, argMapNotUsed, true);
        for (WsSubjectLookup wsSubjectLookup : wsSubjectLookupList) {
            gcHasMember.addSubjectLookup(wsSubjectLookup);
        }
        gcHasMember.assignGroupName(groupName);
        gcHasMember.assignGroupUuid(groupUuid);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcHasMember.assignActAsSubject(actAsSubject);
        gcHasMember.assignMemberFilter(WsMemberFilter.valueOfIgnoreCase(memberFilter));
        gcHasMember.assignIncludeGroupDetail(includeGroupDetail);
        gcHasMember.assignIncludeSubjectDetail(includeSubjectDetail);
        gcHasMember.assignFieldName(fieldName);
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcHasMember.addSubjectAttributeName(subjectAttribute);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsHasMemberResults wsHasMemberResults = gcHasMember.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsHasMemberResults", wsHasMemberResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        substituteMap.put("wsGroup", wsHasMemberResults.getWsGroup());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.hasMember.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsHasMemberResults, " + "grouperClientUtils, index, wsGroup, wsHasMemberResult, wsSubject, resultMetadata, hasMember");
        for (WsHasMemberResult wsHasMemberResult : wsHasMemberResults.getResults()) {
            substituteMap.put("index", index);
            substituteMap.put("wsHasMemberResult", wsHasMemberResult);
            substituteMap.put("wsSubject", wsHasMemberResult.getWsSubject());
            String resultCode = wsHasMemberResult.getResultMetadata().getResultCode();
            substituteMap.put("hasMember", GrouperClientUtils.equals("IS_MEMBER", resultCode));
            substituteMap.put("resultMetadata", wsHasMemberResult.getResultMetadata());
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String deleteMember(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName", false);
        String groupUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupUuid", false);
        String fieldName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "fieldName", false);
        String txType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "txType", false);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcDeleteMember gcDeleteMember = new GcDeleteMember();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcDeleteMember.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcDeleteMember.addParam(param);
        }
        List<WsSubjectLookup> wsSubjectLookupList = GrouperClient.retrieveSubjectsFromArgs(argMap, argMapNotUsed, true);
        for (WsSubjectLookup wsSubjectLookup : wsSubjectLookupList) {
            gcDeleteMember.addSubjectLookup(wsSubjectLookup);
        }
        gcDeleteMember.assignGroupName(groupName);
        gcDeleteMember.assignGroupUuid(groupUuid);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcDeleteMember.assignActAsSubject(actAsSubject);
        gcDeleteMember.assignIncludeGroupDetail(includeGroupDetail);
        gcDeleteMember.assignIncludeSubjectDetail(includeSubjectDetail);
        gcDeleteMember.assignFieldName(fieldName);
        gcDeleteMember.assignTxType(GcTransactionType.valueOfIgnoreCase(txType));
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcDeleteMember.addSubjectAttributeName(subjectAttribute);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsDeleteMemberResults wsDeleteMemberResults = gcDeleteMember.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsDeleteMemberResults", wsDeleteMemberResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        substituteMap.put("wsGroup", wsDeleteMemberResults.getWsGroup());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.deleteMember.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsDeleteMemberResults, " + "grouperClientUtils, wsGroup, index, wsDeleteMemberResult, wsSubject, resultMetadata");
        for (WsDeleteMemberResult wsDeleteMemberResult : wsDeleteMemberResults.getResults()) {
            substituteMap.put("index", index);
            substituteMap.put("wsDeleteMemberResult", wsDeleteMemberResult);
            substituteMap.put("wsSubject", wsDeleteMemberResult.getWsSubject());
            substituteMap.put("resultMetadata", wsDeleteMemberResult.getResultMetadata());
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static WsQueryFilter retrieveQueryFilterFromArgs(Map<String, String> argMap, Map<String, String> argMapNotUsed, String suffix, boolean required) {
        String queryFilterType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "queryFilterType" + suffix, required);
        if (GrouperClientUtils.isBlank(queryFilterType)) {
            return null;
        }
        WsQueryFilter result = new WsQueryFilter();
        result.setQueryFilterType(queryFilterType);
        String groupAttributeName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupAttributeName" + suffix, false);
        result.setGroupAttributeName(groupAttributeName);
        String groupAttributeValue = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupAttributeValue" + suffix, false);
        result.setGroupAttributeValue(groupAttributeValue);
        String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName" + suffix, false);
        result.setGroupName(groupName);
        String groupTypeName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupTypeName" + suffix, false);
        result.setGroupTypeName(groupTypeName);
        String groupUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupUuid" + suffix, false);
        result.setGroupUuid(groupUuid);
        WsQueryFilter queryFilter0 = GrouperClient.retrieveQueryFilterFromArgs(argMap, argMapNotUsed, suffix + "0", false);
        result.setQueryFilter0(queryFilter0);
        WsQueryFilter queryFilter1 = GrouperClient.retrieveQueryFilterFromArgs(argMap, argMapNotUsed, suffix + "1", false);
        result.setQueryFilter1(queryFilter1);
        String stemName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemName" + suffix, false);
        result.setStemName(stemName);
        String stemNameScope = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemNameScope" + suffix, false);
        result.setStemNameScope(stemNameScope);
        return result;
    }

    private static WsStemQueryFilter retrieveStemQueryFilterFromArgs(Map<String, String> argMap, Map<String, String> argMapNotUsed, String suffix, boolean required) {
        String stemQueryFilterType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemQueryFilterType" + suffix, required);
        if (GrouperClientUtils.isBlank(stemQueryFilterType)) {
            return null;
        }
        WsStemQueryFilter result = new WsStemQueryFilter();
        result.setStemQueryFilterType(stemQueryFilterType);
        String stemAttributeName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemAttributeName" + suffix, false);
        result.setStemAttributeName(stemAttributeName);
        String stemAttributeValue = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemAttributeValue" + suffix, false);
        result.setStemAttributeValue(stemAttributeValue);
        String stemName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemName" + suffix, false);
        result.setStemName(stemName);
        String parentStemName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "parentStemName" + suffix, false);
        result.setParentStemName(parentStemName);
        String parentStemNameScope = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "parentStemNameScope" + suffix, false);
        result.setParentStemNameScope(parentStemNameScope);
        String stemUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemUuid" + suffix, false);
        result.setStemUuid(stemUuid);
        WsStemQueryFilter stemQueryFilter0 = GrouperClient.retrieveStemQueryFilterFromArgs(argMap, argMapNotUsed, suffix + "0", false);
        result.setStemQueryFilter0(stemQueryFilter0);
        WsStemQueryFilter stemQueryFilter1 = GrouperClient.retrieveStemQueryFilterFromArgs(argMap, argMapNotUsed, suffix + "1", false);
        result.setStemQueryFilter1(stemQueryFilter1);
        return result;
    }

    private static String findGroups(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcFindGroups gcFindGroups = new GcFindGroups();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcFindGroups.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcFindGroups.addParam(param);
        }
        List<String> groupNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "groupNames", false);
        List<String> groupUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "groupUuids", false);
        if (GrouperClientUtils.length(groupNames) > 0) {
            for (String groupName : groupNames) {
                gcFindGroups.addGroupName(groupName);
            }
        }
        if (GrouperClientUtils.length(groupUuids) > 0) {
            for (String groupUuid : groupUuids) {
                gcFindGroups.addGroupUuid(groupUuid);
            }
        }
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcFindGroups.assignActAsSubject(actAsSubject);
        gcFindGroups.assignIncludeGroupDetail(includeGroupDetail);
        WsQueryFilter wsQueryFilter = GrouperClient.retrieveQueryFilterFromArgs(argMap, argMapNotUsed, "", false);
        gcFindGroups.assignQueryFilter(wsQueryFilter);
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsFindGroupsResults wsFindGroupsResults = gcFindGroups.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsFindGroupsResults", wsFindGroupsResults);
        substituteMap.put("resultMetadata", wsFindGroupsResults.getResultMetadata());
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.findGroups.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsFindGroupsResults, " + "resultMetadata, grouperClientUtils, index, wsGroup");
        for (WsGroup wsGroup : GrouperClientUtils.nonNull(wsFindGroupsResults.getGroupResults(), WsGroup.class)) {
            substituteMap.put("index", index);
            substituteMap.put("wsGroup", wsGroup);
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String findStems(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcFindStems gcFindStems = new GcFindStems();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcFindStems.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcFindStems.addParam(param);
        }
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcFindStems.assignActAsSubject(actAsSubject);
        WsStemQueryFilter wsStemQueryFilter = GrouperClient.retrieveStemQueryFilterFromArgs(argMap, argMapNotUsed, "", false);
        gcFindStems.assignStemQueryFilter(wsStemQueryFilter);
        List<String> stemNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "stemNames", false);
        List<String> stemUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "stemUuids", false);
        if (GrouperClientUtils.length(stemNames) > 0) {
            for (String stemName : stemNames) {
                gcFindStems.addStemName(stemName);
            }
        }
        if (GrouperClientUtils.length(stemUuids) > 0) {
            for (String stemUuid : stemUuids) {
                gcFindStems.addStemUuid(stemUuid);
            }
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsFindStemsResults wsFindStemsResults = gcFindStems.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsFindStemsResults", wsFindStemsResults);
        substituteMap.put("resultMetadata", wsFindStemsResults.getResultMetadata());
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.findStems.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsFindStemsResults, " + "resultMetadata, grouperClientUtils, index, wsStem");
        for (WsStem wsStem : GrouperClientUtils.nonNull(wsFindStemsResults.getStemResults(), WsStem.class)) {
            substituteMap.put("index", index);
            substituteMap.put("wsStem", wsStem);
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String getMembers(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        List<String> groupNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "groupNames", false);
        List<String> groupUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "groupUuids", false);
        String fieldName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "fieldName", false);
        String memberFilter = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "memberFilter", false);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        String sourceIds = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "sourceIds", false);
        GcGetMembers gcGetMembers = new GcGetMembers();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcGetMembers.assignClientVersion(clientVersion);
        if (GrouperClientUtils.length(groupNames) > 0) {
            for (String groupName : groupNames) {
                gcGetMembers.addGroupName(groupName);
            }
        }
        if (GrouperClientUtils.length(groupUuids) > 0) {
            for (String groupUuid : groupUuids) {
                gcGetMembers.addGroupUuid(groupUuid);
            }
        }
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcGetMembers.assignActAsSubject(actAsSubject);
        gcGetMembers.assignMemberFilter(WsMemberFilter.valueOfIgnoreCase(memberFilter));
        gcGetMembers.assignIncludeGroupDetail(includeGroupDetail);
        gcGetMembers.assignIncludeSubjectDetail(includeSubjectDetail);
        gcGetMembers.assignFieldName(fieldName);
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcGetMembers.addSubjectAttributeName(subjectAttribute);
        }
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        for (WsParam param : params) {
            gcGetMembers.addParam(param);
        }
        if (!GrouperClientUtils.isBlank(sourceIds)) {
            String[] sourceIdsArray;
            for (String sourceId : sourceIdsArray = GrouperClientUtils.splitTrim(sourceIds, ",")) {
                gcGetMembers.addSourceId(sourceId);
            }
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsGetMembersResults wsGetMembersResults = gcGetMembers.execute();
        StringBuilder result = new StringBuilder();
        int groupIndex = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsGetMembersResults", wsGetMembersResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.getMembers.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsGetMembersResults, " + "grouperClientUtils, groupIndex, wsGetMembersResult, wsGroup, resultMetadata, subjectIndex, wsSubject");
        for (WsGetMembersResult wsGetMembersResult : GrouperClientUtils.nonNull(wsGetMembersResults.getResults(), WsGetMembersResult.class)) {
            substituteMap.put("groupIndex", groupIndex);
            substituteMap.put("wsGetMembersResult", wsGetMembersResult);
            substituteMap.put("wsGroup", wsGetMembersResult.getWsGroup());
            substituteMap.put("resultMetadata", wsGetMembersResult.getResultMetadata());
            int subjectIndex = 0;
            for (WsSubject wsSubject : GrouperClientUtils.nonNull(wsGetMembersResult.getWsSubjects(), WsSubject.class)) {
                substituteMap.put("subjectIndex", subjectIndex);
                substituteMap.put("wsSubject", wsSubject);
                String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
                result.append(output);
                ++subjectIndex;
            }
            ++groupIndex;
        }
        return result.toString();
    }

    private static String getGroups(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String memberFilter = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "memberFilter", false);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        String scope = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "scope", false);
        String stemUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemUuid", false);
        String stemName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemName", false);
        WsStemLookup wsStemLookup = null;
        if (!GrouperClientUtils.isBlank(stemName) || !GrouperClientUtils.isBlank(stemUuid)) {
            wsStemLookup = new WsStemLookup(stemName, stemUuid);
        }
        String fieldName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "fieldName", false);
        String stemScope = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemScope", false);
        String enabled = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "enabled", false);
        Integer pageSize = GrouperClientUtils.argMapInteger(argMap, argMapNotUsed, "pageSize", false, null);
        Integer pageNumber = GrouperClientUtils.argMapInteger(argMap, argMapNotUsed, "pageNumber", false, null);
        String sortString = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "sortString", false);
        Boolean ascending = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "ascending");
        GcGetGroups gcGetGroups = new GcGetGroups();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcGetGroups.assignClientVersion(clientVersion);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcGetGroups.assignActAsSubject(actAsSubject);
        gcGetGroups.assignMemberFilter(WsMemberFilter.valueOfIgnoreCase(memberFilter));
        gcGetGroups.assignIncludeGroupDetail(includeGroupDetail);
        gcGetGroups.assignIncludeSubjectDetail(includeSubjectDetail);
        gcGetGroups.assignScope(scope);
        gcGetGroups.assignWsStemLookup(wsStemLookup);
        if (!GrouperClientUtils.isBlank(stemScope)) {
            StemScope theStemScope = StemScope.valueOfIgnoreCase(stemScope);
            gcGetGroups.assignStemScope(theStemScope);
        }
        if (!GrouperClientUtils.isBlank(enabled)) {
            Boolean enabledBoolean = null;
            if (!GrouperClientUtils.equalsIgnoreCase("A", enabled)) {
                enabledBoolean = GrouperClientUtils.booleanValue(enabled);
            }
            gcGetGroups.assignEnabled(enabledBoolean);
        }
        gcGetGroups.assignPageSize(pageSize);
        gcGetGroups.assignPageNumber(pageNumber);
        gcGetGroups.assignSortString(sortString);
        gcGetGroups.assignAscending(ascending);
        gcGetGroups.assignFieldName(fieldName);
        List<WsSubjectLookup> wsSubjectLookupList = GrouperClient.retrieveSubjectsFromArgs(argMap, argMapNotUsed, true);
        for (WsSubjectLookup wsSubjectLookup : wsSubjectLookupList) {
            gcGetGroups.addSubjectLookup(wsSubjectLookup);
        }
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcGetGroups.addSubjectAttributeName(subjectAttribute);
        }
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        for (WsParam param : params) {
            gcGetGroups.addParam(param);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsGetGroupsResults wsGetGroupsResults = gcGetGroups.execute();
        StringBuilder result = new StringBuilder();
        int subjectIndex = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsGetGroupsResults", wsGetGroupsResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.getGroups.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsGetGroupsResults, " + "grouperClientUtils, subjectIndex, wsGetGroupsResult, resultMetadata, wsSubject, groupIndex, wsGroup");
        for (WsGetGroupsResult wsGetGroupsResult : GrouperClientUtils.nonNull(wsGetGroupsResults.getResults(), WsGetGroupsResult.class)) {
            substituteMap.put("subjectIndex", subjectIndex);
            substituteMap.put("wsGetGroupsResult", wsGetGroupsResult);
            substituteMap.put("resultMetadata", wsGetGroupsResult.getResultMetadata());
            substituteMap.put("wsSubject", wsGetGroupsResult.getWsSubject());
            int groupIndex = 0;
            for (WsGroup wsGroup : GrouperClientUtils.nonNull(wsGetGroupsResult.getWsGroups(), WsGroup.class)) {
                substituteMap.put("groupIndex", groupIndex);
                substituteMap.put("wsGroup", wsGroup);
                String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
                result.append(output);
                ++groupIndex;
            }
            ++subjectIndex;
        }
        return result.toString();
    }

    private static WsSubjectLookup retrieveActAsSubjectFromArgs(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        return GrouperClient.retrieveSuffixSubjectFromArgs(argMap, argMapNotUsed, "actAs", false);
    }

    private static WsSubjectLookup retrieveSuffixSubjectFromArgs(Map<String, String> argMap, Map<String, String> argMapNotUsed, String prefix, boolean required) {
        String argMapPrefixSubjectIdKey = prefix + "SubjectId";
        String aliasSubjectId = GrouperClientUtils.propertiesValue("grouperClient.alias.SubjectId", false);
        if (!GrouperClientUtils.isBlank(aliasSubjectId)) {
            String aliasKey = prefix + aliasSubjectId;
            boolean containsAliasKey = argMap.containsKey(aliasKey);
            if (argMap.containsKey(argMapPrefixSubjectIdKey) && containsAliasKey) {
                throw new RuntimeException("You cannot pass both arguments " + prefix + "SubjectId and " + aliasKey + ", choose one or the other");
            }
            argMapPrefixSubjectIdKey = containsAliasKey ? aliasKey : argMapPrefixSubjectIdKey;
        }
        String argMapPrefixSubjectIdentifierKey = prefix + "SubjectIdentifier";
        String aliasSubjectIdentifier = GrouperClientUtils.propertiesValue("grouperClient.alias.SubjectIdentifier", false);
        if (!GrouperClientUtils.isBlank(aliasSubjectIdentifier)) {
            String aliasKey = prefix + aliasSubjectIdentifier;
            boolean containsAliasKey = argMap.containsKey(aliasKey);
            if (argMap.containsKey(argMapPrefixSubjectIdentifierKey) && containsAliasKey) {
                throw new RuntimeException("You cannot pass both arguments " + prefix + "SubjectIdentifier and " + aliasKey + ", choose one or the other");
            }
            argMapPrefixSubjectIdentifierKey = containsAliasKey ? aliasKey : argMapPrefixSubjectIdentifierKey;
        }
        String prefixSubjectId = GrouperClientUtils.argMapString(argMap, argMapNotUsed, argMapPrefixSubjectIdKey, false);
        String prefixSubjectIdentifier = GrouperClientUtils.argMapString(argMap, argMapNotUsed, argMapPrefixSubjectIdentifierKey, false);
        String prefixSubjectSource = GrouperClientUtils.argMapString(argMap, argMapNotUsed, prefix + "SubjectSource", false);
        if (GrouperClientUtils.isBlank(prefixSubjectId) && GrouperClientUtils.isBlank(prefixSubjectIdentifier) && GrouperClientUtils.isBlank(prefixSubjectSource)) {
            if (required) {
                throw new RuntimeException(prefix + "Subject is required");
            }
            return null;
        }
        WsSubjectLookup actAsSubject = new WsSubjectLookup(prefixSubjectId, prefixSubjectSource, prefixSubjectIdentifier);
        return actAsSubject;
    }

    private static List<WsParam> retrieveParamsFromArgs(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String argName;
        ArrayList<WsParam> params = new ArrayList<WsParam>();
        int index = 0;
        while (!GrouperClientUtils.isBlank(argName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "paramName" + index, false))) {
            String argValue = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "paramValue" + index, true);
            params.add(new WsParam(argName, argValue));
            ++index;
        }
        return params;
    }

    private static List<WsSubjectLookup> retrieveSubjectsFromArgs(Map<String, String> argMap, Map<String, String> argMapNotUsed, boolean required) {
        String argMapSubjectIdsKey = "subjectIds";
        String aliasSubjectIds = GrouperClientUtils.propertiesValue("grouperClient.alias.subjectIds", false);
        if (!GrouperClientUtils.isBlank(aliasSubjectIds)) {
            boolean containsAliasKey = argMap.containsKey(aliasSubjectIds);
            if (argMap.containsKey(argMapSubjectIdsKey) && containsAliasKey) {
                throw new RuntimeException("You cannot pass both arguments subjectIds and " + aliasSubjectIds + ", choose one or the other");
            }
            argMapSubjectIdsKey = containsAliasKey ? aliasSubjectIds : argMapSubjectIdsKey;
        }
        String argMapSubjectIdentifiersKey = "subjectIdentifiers";
        String aliasSubjectIdentifiers = GrouperClientUtils.propertiesValue("grouperClient.alias.subjectIdentifiers", false);
        if (!GrouperClientUtils.isBlank(aliasSubjectIdentifiers)) {
            boolean containsAliasKey = argMap.containsKey(aliasSubjectIdentifiers);
            if (argMap.containsKey(argMapSubjectIdentifiersKey) && containsAliasKey) {
                throw new RuntimeException("You cannot pass both arguments subjectIdentifiers and " + aliasSubjectIdentifiers + ", choose one or the other");
            }
            argMapSubjectIdentifiersKey = containsAliasKey ? aliasSubjectIdentifiers : argMapSubjectIdentifiersKey;
        }
        String argMapSubjectIdsFileKey = "subjectIdsFile";
        String aliasSubjectIds2 = GrouperClientUtils.propertiesValue("grouperClient.alias.subjectIds", false);
        if (!GrouperClientUtils.isBlank(aliasSubjectIds2)) {
            String aliasSubjectIdsFile = aliasSubjectIds2 + "File";
            boolean containsAliasKey = argMap.containsKey(aliasSubjectIdsFile);
            if (argMap.containsKey(argMapSubjectIdsFileKey) && containsAliasKey) {
                throw new RuntimeException("You cannot pass both arguments subjectIdsFile and " + aliasSubjectIdsFile + ", choose one or the other");
            }
            argMapSubjectIdsFileKey = containsAliasKey ? aliasSubjectIdsFile : argMapSubjectIdsFileKey;
        }
        String argMapSubjectIdentifiersFileKey = "subjectIdentifiersFile";
        String aliasSubjectIdentifiers2 = GrouperClientUtils.propertiesValue("grouperClient.alias.subjectIdentifiers", false);
        if (!GrouperClientUtils.isBlank(aliasSubjectIdentifiers2)) {
            String aliasSubjectIdentifiersFile = aliasSubjectIdentifiers2 + "File";
            boolean containsAliasKey = argMap.containsKey(aliasSubjectIdentifiersFile);
            if (argMap.containsKey(argMapSubjectIdentifiersFileKey) && containsAliasKey) {
                throw new RuntimeException("You cannot pass both arguments subjectIdentifiersFile and " + aliasSubjectIdentifiersFile + ", choose one or the other");
            }
            argMapSubjectIdentifiersFileKey = containsAliasKey ? aliasSubjectIdentifiersFile : argMapSubjectIdentifiersFileKey;
        }
        List<String> subjectIdsList = GrouperClientUtils.argMapList(argMap, argMapNotUsed, argMapSubjectIdsKey, false);
        List<String> subjectIdentifiersList = GrouperClientUtils.argMapList(argMap, argMapNotUsed, argMapSubjectIdentifiersKey, false);
        List<String> sourceIdsList = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "subjectSources", false);
        String defaultSubjectSource = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "defaultSubjectSource", false);
        int subjectIdLength = GrouperClientUtils.length(subjectIdsList);
        int subjectIdentifierLength = GrouperClientUtils.length(subjectIdentifiersList);
        int sourceIdLength = GrouperClientUtils.length(sourceIdsList);
        if (argMap.containsKey(argMapSubjectIdsFileKey)) {
            if (subjectIdLength > 0) {
                throw new RuntimeException("Cant pass in " + argMapSubjectIdsKey + " and " + argMapSubjectIdsFileKey + ", use one or the other");
            }
            subjectIdsList = GrouperClientUtils.argMapFileList(argMap, argMapNotUsed, argMapSubjectIdsFileKey, true);
            subjectIdLength = GrouperClientUtils.length(subjectIdsList);
        }
        if (argMap.containsKey(argMapSubjectIdentifiersFileKey)) {
            if (subjectIdentifierLength > 0) {
                throw new RuntimeException("Cant pass in " + argMapSubjectIdentifiersKey + " and " + argMapSubjectIdentifiersFileKey + ", use one or the other");
            }
            subjectIdentifiersList = GrouperClientUtils.argMapFileList(argMap, argMapNotUsed, argMapSubjectIdentifiersFileKey, true);
            subjectIdentifierLength = GrouperClientUtils.length(subjectIdentifiersList);
        }
        if (argMap.containsKey("sourceIdsFile")) {
            if (sourceIdLength > 0) {
                throw new RuntimeException("Cant pass in " + argMapSubjectIdsKey + " and sourceIdsFile, use one or the other");
            }
            sourceIdsList = GrouperClientUtils.argMapFileList(argMap, argMapNotUsed, "sourceIdsFile", true);
            sourceIdLength = GrouperClientUtils.length(sourceIdsList);
        }
        if (!GrouperClientUtils.isBlank(defaultSubjectSource) && sourceIdLength > 0) {
            throw new RuntimeException("Cant specify a default subject source, and source ids");
        }
        if (subjectIdLength == 0 && subjectIdentifierLength == 0) {
            if (!required) {
                return null;
            }
            throw new RuntimeException("Cant pass no subject ids and no subject identifiers!");
        }
        if (subjectIdLength != 0 && subjectIdentifierLength != 0) {
            throw new RuntimeException("Cant pass " + argMapSubjectIdsKey + " and " + argMapSubjectIdentifiersKey + "! (pass one of the other)");
        }
        int subjectsLength = Math.max(subjectIdLength, subjectIdentifierLength);
        if (sourceIdLength == 1 && subjectsLength > 1) {
            for (int i = 1; i < subjectsLength; ++i) {
                sourceIdsList.add(sourceIdsList.get(0));
            }
            sourceIdLength = sourceIdsList.size();
        }
        if (sourceIdLength > 0 && sourceIdLength != subjectIdLength && sourceIdLength != subjectIdentifierLength) {
            throw new RuntimeException("If subjectSources are passed in, you must pass the same number as " + argMapSubjectIdsKey + " or " + argMapSubjectIdentifiersKey + ", or pass one for all.");
        }
        ArrayList<WsSubjectLookup> wsSubjectLookupList = new ArrayList<WsSubjectLookup>();
        for (int i = 0; i < subjectsLength; ++i) {
            WsSubjectLookup wsSubjectLookup = new WsSubjectLookup();
            if (subjectIdLength > 0) {
                wsSubjectLookup.setSubjectId(subjectIdsList.get(i));
            }
            if (subjectIdentifierLength > 0) {
                wsSubjectLookup.setSubjectIdentifier(subjectIdentifiersList.get(i));
            }
            if (sourceIdLength > 0) {
                wsSubjectLookup.setSubjectSourceId(sourceIdsList.get(i));
            }
            if (!GrouperClientUtils.isBlank(defaultSubjectSource)) {
                wsSubjectLookup.setSubjectSourceId(defaultSubjectSource);
            }
            wsSubjectLookupList.add(wsSubjectLookup);
        }
        return wsSubjectLookupList;
    }

    private static WsSubjectLookup retrieveSubjectFromArgs(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String argMapSubjectIdKey = "subjectId";
        String aliasSubjectId = GrouperClientUtils.propertiesValue("grouperClient.alias.subjectId", false);
        if (!GrouperClientUtils.isBlank(aliasSubjectId)) {
            boolean containsAliasKey = argMap.containsKey(aliasSubjectId);
            if (argMap.containsKey(argMapSubjectIdKey) && containsAliasKey) {
                throw new RuntimeException("You cannot pass both arguments subjectId and " + aliasSubjectId + ", choose one or the other");
            }
            argMapSubjectIdKey = containsAliasKey ? aliasSubjectId : argMapSubjectIdKey;
        }
        String argMapSubjectIdentifierKey = "subjectIdentifier";
        String aliasSubjectIdentifier = GrouperClientUtils.propertiesValue("grouperClient.alias.subjectIdentifier", false);
        if (!GrouperClientUtils.isBlank(aliasSubjectIdentifier)) {
            boolean containsAliasKey = argMap.containsKey(aliasSubjectIdentifier);
            if (argMap.containsKey(argMapSubjectIdentifierKey) && containsAliasKey) {
                throw new RuntimeException("You cannot pass both arguments subjectIdentifier and " + aliasSubjectIdentifier + ", choose one or the other");
            }
            argMapSubjectIdentifierKey = containsAliasKey ? aliasSubjectIdentifier : argMapSubjectIdentifierKey;
        }
        String subjectId = GrouperClientUtils.argMapString(argMap, argMapNotUsed, argMapSubjectIdKey, false);
        String subjectIdentifier = GrouperClientUtils.argMapString(argMap, argMapNotUsed, argMapSubjectIdentifierKey, false);
        String sourceId = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "sourceId", false);
        boolean hasSubjectId = GrouperClientUtils.isNotBlank(subjectId);
        boolean hasSubjectIdentifier = GrouperClientUtils.isNotBlank(subjectIdentifier);
        if (hasSubjectId && hasSubjectIdentifier) {
            throw new RuntimeException("Cant pass " + argMapSubjectIdKey + " and " + argMapSubjectIdentifierKey + "! (pass one of the other)");
        }
        if (hasSubjectId || hasSubjectIdentifier) {
            return new WsSubjectLookup(subjectId, sourceId, subjectIdentifier);
        }
        return null;
    }

    public static void usage() {
        String usage = GrouperClientUtils.readResourceIntoString("grouper.client.usage.txt", GrouperClientCommonUtils.class);
        System.err.println(usage);
    }

    private static String getMemberships(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        String fieldName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "fieldName", false);
        List<String> groupNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "groupNames", false);
        List<String> groupUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "groupUuids", false);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        String memberFilter = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "memberFilter", false);
        List<String> membershipIds = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "membershipIds", false);
        String scope = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "scope", false);
        String sourceIds = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "sourceIds", false);
        String stemName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemName", false);
        String stemUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemUuid", false);
        WsStemLookup wsStemLookup = null;
        if (!GrouperClientUtils.isBlank(stemName) || !GrouperClientUtils.isBlank(stemUuid)) {
            wsStemLookup = new WsStemLookup(stemName, stemUuid);
        }
        String stemScope = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemScope", false);
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        List<WsSubjectLookup> wsSubjectLookupList = GrouperClient.retrieveSubjectsFromArgs(argMap, argMapNotUsed, false);
        GcGetMemberships gcGetMemberships = new GcGetMemberships();
        gcGetMemberships.assignActAsSubject(actAsSubject);
        gcGetMemberships.assignClientVersion(clientVersion);
        String enabled = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "enabled", false);
        gcGetMemberships.assignEnabled(enabled);
        gcGetMemberships.assignFieldName(fieldName);
        if (GrouperClientUtils.length(groupNames) > 0) {
            for (String groupName : groupNames) {
                gcGetMemberships.addGroupName(groupName);
            }
        }
        if (GrouperClientUtils.length(groupUuids) > 0) {
            for (String groupUuid : groupUuids) {
                gcGetMemberships.addGroupUuid(groupUuid);
            }
        }
        gcGetMemberships.assignIncludeGroupDetail(includeGroupDetail);
        gcGetMemberships.assignIncludeSubjectDetail(includeSubjectDetail);
        gcGetMemberships.assignMemberFilter(WsMemberFilter.valueOfIgnoreCase(memberFilter));
        if (GrouperClientUtils.length(membershipIds) > 0) {
            for (String membershipId : membershipIds) {
                gcGetMemberships.addMembershipId(membershipId);
            }
        }
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcGetMemberships.addSubjectAttributeName(subjectAttribute);
        }
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        for (WsParam param : params) {
            gcGetMemberships.addParam(param);
        }
        if (!GrouperClientUtils.isBlank(sourceIds)) {
            String[] sourceIdsArray;
            for (String sourceId : sourceIdsArray = GrouperClientUtils.splitTrim(sourceIds, ",")) {
                gcGetMemberships.addSourceId(sourceId);
            }
        }
        gcGetMemberships.assignScope(scope);
        gcGetMemberships.assigStemScope(stemScope);
        gcGetMemberships.assignWsStem(wsStemLookup);
        if (GrouperClientUtils.length(wsSubjectLookupList) > 0) {
            for (WsSubjectLookup wsSubjectLookup : wsSubjectLookupList) {
                gcGetMemberships.addWsSubjectLookup(wsSubjectLookup);
            }
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsGetMembershipsResults wsGetMembershipsResults = gcGetMemberships.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsGetMembershipsResults", wsGetMembershipsResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.getMemberships.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsGetMembershipsResults, " + "grouperClientUtils, index, wsMembership");
        HashMap<String, WsGroup> groupLookup = new HashMap<String, WsGroup>();
        for (WsGroup wsGroup : GrouperClientUtils.nonNull(wsGetMembershipsResults.getWsGroups(), WsGroup.class)) {
            groupLookup.put(wsGroup.getUuid(), wsGroup);
        }
        HashMap<MultiKey, WsSubject> subjectLookup = new HashMap<MultiKey, WsSubject>();
        for (WsSubject wsSubject : GrouperClientUtils.nonNull(wsGetMembershipsResults.getWsSubjects(), WsSubject.class)) {
            MultiKey key = new MultiKey(wsSubject.getSourceId(), wsSubject.getId());
            subjectLookup.put(key, wsSubject);
        }
        for (WsMembership wsMembership : GrouperClientUtils.nonNull(wsGetMembershipsResults.getWsMemberships(), WsMembership.class)) {
            WsGroup wsGroup = (WsGroup)groupLookup.get(wsMembership.getGroupId());
            MultiKey subjectKey = new MultiKey(wsMembership.getSubjectSourceId(), wsMembership.getSubjectId());
            WsSubject wsSubject = (WsSubject)subjectLookup.get(subjectKey);
            substituteMap.put("index", index);
            substituteMap.put("wsMembership", wsMembership);
            substituteMap.put("wsSubject", wsSubject);
            substituteMap.put("wsGroup", wsGroup);
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String getSubjects(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        String fieldName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "fieldName", false);
        String searchString = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "searchString", false);
        String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName", false);
        String groupUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupUuid", false);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        String memberFilter = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "memberFilter", false);
        String sourceIds = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "sourceIds", false);
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        List<WsSubjectLookup> wsSubjectLookupList = GrouperClient.retrieveSubjectsFromArgs(argMap, argMapNotUsed, false);
        GcGetSubjects gcGetSubjects = new GcGetSubjects();
        gcGetSubjects.assignActAsSubject(actAsSubject);
        gcGetSubjects.assignClientVersion(clientVersion);
        gcGetSubjects.assignFieldName(fieldName);
        if (!GrouperClientUtils.isBlank(groupName) || !GrouperClientUtils.isBlank(groupUuid)) {
            WsGroupLookup wsGroupLookup = new WsGroupLookup(groupName, groupUuid);
            gcGetSubjects.assignGroupLookup(wsGroupLookup);
        }
        gcGetSubjects.assignIncludeGroupDetail(includeGroupDetail);
        gcGetSubjects.assignIncludeSubjectDetail(includeSubjectDetail);
        gcGetSubjects.assignMemberFilter(WsMemberFilter.valueOfIgnoreCase(memberFilter));
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcGetSubjects.addSubjectAttributeName(subjectAttribute);
        }
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        for (WsParam param : params) {
            gcGetSubjects.addParam(param);
        }
        if (!GrouperClientUtils.isBlank(sourceIds)) {
            String[] sourceIdsArray;
            for (String sourceId : sourceIdsArray = GrouperClientUtils.splitTrim(sourceIds, ",")) {
                gcGetSubjects.addSourceId(sourceId);
            }
        }
        gcGetSubjects.assignSearchString(searchString);
        if (GrouperClientUtils.length(wsSubjectLookupList) > 0) {
            for (WsSubjectLookup wsSubjectLookup : wsSubjectLookupList) {
                gcGetSubjects.addWsSubjectLookup(wsSubjectLookup);
            }
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsGetSubjectsResults wsGetSubjectsResults = gcGetSubjects.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsGetSubjectsResults", wsGetSubjectsResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.getSubjects.output", true);
        }
        substituteMap.put("wsGroup", wsGetSubjectsResults.getWsGroup());
        log.debug("Output template: " + outputTemplate + ", available variables: wsGetSubjectsResults, " + "grouperClientUtils, index, wsSubject, wsGroup, success");
        for (WsSubject wsSubject : GrouperClientUtils.nonNull(wsGetSubjectsResults.getWsSubjects(), WsSubject.class)) {
            substituteMap.put("index", index);
            substituteMap.put("wsSubject", wsSubject);
            String success = "F";
            if ("SUCCESS".equalsIgnoreCase(wsSubject.getResultCode())) {
                success = "T";
            }
            substituteMap.put("success", success);
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String assignGrouperPrivileges(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName", false);
        String groupUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupUuid", false);
        String stemName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemName", false);
        String stemUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "stemUuid", false);
        String privilegeType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "privilegeType", false);
        String txType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "txType", false);
        Boolean replaceAllExisting = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "replaceAllExisting");
        List<String> privilegeNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "privilegeNames", true);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        boolean allowed = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "allowed", true, true);
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        GcAssignGrouperPrivileges gcAssignGrouperPrivileges = new GcAssignGrouperPrivileges();
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcAssignGrouperPrivileges.assignClientVersion(clientVersion);
        for (WsParam param : params) {
            gcAssignGrouperPrivileges.addParam(param);
        }
        List<WsSubjectLookup> wsSubjectLookups = GrouperClient.retrieveSubjectsFromArgs(argMap, argMapNotUsed, false);
        if (!GrouperClientUtils.isBlank(stemName) || !GrouperClientUtils.isBlank(stemUuid)) {
            gcAssignGrouperPrivileges.assignStemLookup(new WsStemLookup(stemName, stemUuid));
        }
        if (!GrouperClientUtils.isBlank(groupName) || !GrouperClientUtils.isBlank(groupUuid)) {
            gcAssignGrouperPrivileges.assignGroupLookup(new WsGroupLookup(groupName, groupUuid));
        }
        gcAssignGrouperPrivileges.assignPrivilegeType(privilegeType);
        gcAssignGrouperPrivileges.assignTxType(GcTransactionType.valueOfIgnoreCase(txType));
        gcAssignGrouperPrivileges.assignReplaceAllExisting(replaceAllExisting);
        for (String privilegeName : privilegeNames) {
            gcAssignGrouperPrivileges.addPrivilegeName(privilegeName);
        }
        for (WsSubjectLookup wsSubjectLookup : GrouperClientUtils.nonNull(wsSubjectLookups)) {
            gcAssignGrouperPrivileges.addSubjectLookup(wsSubjectLookup);
        }
        gcAssignGrouperPrivileges.assignAllowed(allowed);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcAssignGrouperPrivileges.assignActAsSubject(actAsSubject);
        gcAssignGrouperPrivileges.assignIncludeGroupDetail(includeGroupDetail);
        gcAssignGrouperPrivileges.assignIncludeSubjectDetail(includeSubjectDetail);
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcAssignGrouperPrivileges.addSubjectAttributeName(subjectAttribute);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsAssignGrouperPrivilegesResults wsAssignGrouperPrivilegesResults = gcAssignGrouperPrivileges.execute();
        StringBuilder result = new StringBuilder();
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsAssignGrouperPrivilegesResults", wsAssignGrouperPrivilegesResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.assignGrouperPrivileges.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsAssignGrouperPrivilegesResults, wsAssignGrouperPrivilegesResult, " + "grouperClientUtils, wsSubject, resultMetadata, wsGroup, wsStem, objectType, objectName, index");
        substituteMap.put("wsGroup", wsAssignGrouperPrivilegesResults.getWsGroup());
        substituteMap.put("wsStem", wsAssignGrouperPrivilegesResults.getWsStem());
        substituteMap.put("objectType", wsAssignGrouperPrivilegesResults.getWsStem() == null ? "group" : "stem");
        substituteMap.put("objectName", wsAssignGrouperPrivilegesResults.getWsStem() == null ? wsAssignGrouperPrivilegesResults.getWsGroup().getName() : wsAssignGrouperPrivilegesResults.getWsStem().getName());
        int index = 0;
        for (WsAssignGrouperPrivilegesResult wsAssignGrouperPrivilegesResult : wsAssignGrouperPrivilegesResults.getResults()) {
            substituteMap.put("index", index);
            substituteMap.put("wsAssignGrouperPrivilegesResult", wsAssignGrouperPrivilegesResult);
            substituteMap.put("wsSubject", wsAssignGrouperPrivilegesResult.getWsSubject());
            substituteMap.put("resultMetadata", wsAssignGrouperPrivilegesResult.getResultMetadata());
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String getAttributeAssignments(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        Set<String> ownerAttributeDefUuids;
        Set<String> ownerAttributeDefNames;
        Set<String> attributeDefUuids;
        Set<String> attributeDefNames;
        Set<String> attributeDefNameUuids;
        List<String> ownerStemNames;
        List<String> ownerStemUuids;
        List<String> ownerMembershipUuids;
        List<String> ownerGroupNames;
        List<String> ownerGroupUuids;
        int i;
        GcGetAttributeAssignments gcGetAttributeAssignments = new GcGetAttributeAssignments();
        for (i = 0; i < 10; ++i) {
            WsSubjectLookup ownerMembershipAnySubjectLookup = GrouperClient.retrieveSuffixSubjectFromArgs(argMap, argMapNotUsed, "ownerMembershipAny" + i, false);
            String ownerMembershipAnyGroupUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "ownerMembershipAny" + i + "GroupUuid", false);
            String ownerMembershipAnyGroupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "ownerMembershipAny" + i + "GroupName", false);
            if (ownerMembershipAnySubjectLookup == null && GrouperClientUtils.isBlank(ownerMembershipAnyGroupName) && GrouperClientUtils.isBlank(ownerMembershipAnyGroupUuid)) continue;
            WsMembershipAnyLookup wsMembershipAnyLookup = new WsMembershipAnyLookup();
            wsMembershipAnyLookup.setWsGroupLookup(new WsGroupLookup(ownerMembershipAnyGroupName, ownerMembershipAnyGroupUuid));
            wsMembershipAnyLookup.setWsSubjectLookup(ownerMembershipAnySubjectLookup);
            gcGetAttributeAssignments.addOwnerMembershipAnyLookup(wsMembershipAnyLookup);
        }
        for (i = 0; i < 10; ++i) {
            WsSubjectLookup ownerSubjectLookup = GrouperClient.retrieveSuffixSubjectFromArgs(argMap, argMapNotUsed, "owner" + i, false);
            if (ownerSubjectLookup == null) continue;
            gcGetAttributeAssignments.addOwnerSubjectLookup(ownerSubjectLookup);
        }
        Boolean includeAssignmentsOnAssignments = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeAssignmentsOnAssignments");
        gcGetAttributeAssignments.assignIncludeAssignmentsOnAssignments(includeAssignmentsOnAssignments);
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        gcGetAttributeAssignments.assignIncludeSubjectDetail(includeSubjectDetail);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        gcGetAttributeAssignments.assignIncludeGroupDetail(includeGroupDetail);
        Set<String> attributeAssignUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeAssignUuids", false);
        if (GrouperClientUtils.length(attributeAssignUuids) > 0) {
            for (String attributeAssignUuid : attributeAssignUuids) {
                gcGetAttributeAssignments.addAttributeAssignId(attributeAssignUuid);
            }
        }
        if (GrouperClientUtils.length(ownerGroupUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "ownerGroupUuids", false)) > 0) {
            for (String ownerGroupUuid : ownerGroupUuids) {
                gcGetAttributeAssignments.addOwnerGroupUuid(ownerGroupUuid);
            }
        }
        if (GrouperClientUtils.length(ownerGroupNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "ownerGroupNames", false)) > 0) {
            for (String ownerGroupName : ownerGroupNames) {
                gcGetAttributeAssignments.addOwnerGroupName(ownerGroupName);
            }
        }
        if (GrouperClientUtils.length(ownerMembershipUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "ownerMembershipUuids", false)) > 0) {
            for (String ownerMembershipUuid : ownerMembershipUuids) {
                gcGetAttributeAssignments.addOwnerMembershipId(ownerMembershipUuid);
            }
        }
        if (GrouperClientUtils.length(ownerStemUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "ownerStemUuids", false)) > 0) {
            for (String ownerStemUuid : ownerStemUuids) {
                gcGetAttributeAssignments.addOwnerStemUuid(ownerStemUuid);
            }
        }
        if (GrouperClientUtils.length(ownerStemNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "ownerStemNames", false)) > 0) {
            for (String ownerStemName : ownerStemNames) {
                gcGetAttributeAssignments.addOwnerStemName(ownerStemName);
            }
        }
        String enabled = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "enabled", false);
        gcGetAttributeAssignments.assignEnabled(enabled);
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcGetAttributeAssignments.assignClientVersion(clientVersion);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcGetAttributeAssignments.assignActAsSubject(actAsSubject);
        String attributeAssignType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "attributeAssignType", true);
        gcGetAttributeAssignments.assignAttributeAssignType(attributeAssignType);
        Set<String> attributeDefNameNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefNameNames", false);
        if (GrouperClientUtils.length(attributeDefNameNames) > 0) {
            for (String attributeDefNameName : attributeDefNameNames) {
                gcGetAttributeAssignments.addAttributeDefNameName(attributeDefNameName);
            }
        }
        if (GrouperClientUtils.length(attributeDefNameUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefNameUuids", false)) > 0) {
            for (String attributeDefNameUuid : attributeDefNameUuids) {
                gcGetAttributeAssignments.addAttributeDefNameUuid(attributeDefNameUuid);
            }
        }
        if (GrouperClientUtils.length(attributeDefNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefNames", false)) > 0) {
            for (String attributeDefName : attributeDefNames) {
                gcGetAttributeAssignments.addAttributeDefName(attributeDefName);
            }
        }
        if (GrouperClientUtils.length(attributeDefUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefUuids", false)) > 0) {
            for (String attributeDefUuid : attributeDefUuids) {
                gcGetAttributeAssignments.addAttributeDefUuid(attributeDefUuid);
            }
        }
        if (GrouperClientUtils.length(ownerAttributeDefNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "ownerAttributeDefNames", false)) > 0) {
            for (String ownerAttributeDefName : ownerAttributeDefNames) {
                gcGetAttributeAssignments.addOwnerAttributeDefName(ownerAttributeDefName);
            }
        }
        if (GrouperClientUtils.length(ownerAttributeDefUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "ownerAttributeDefUuids", false)) > 0) {
            for (String ownerAttributeDefUuid : ownerAttributeDefUuids) {
                gcGetAttributeAssignments.addOwnerAttributeDefUuid(ownerAttributeDefUuid);
            }
        }
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcGetAttributeAssignments.addSubjectAttributeName(subjectAttribute);
        }
        Set<String> actions = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "actions", false);
        if (GrouperClientUtils.length(actions) > 0) {
            for (String action : actions) {
                gcGetAttributeAssignments.addAction(action);
            }
        }
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        for (WsParam param : params) {
            gcGetAttributeAssignments.addParam(param);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsGetAttributeAssignmentsResults wsAttributeAssignmentsResults = gcGetAttributeAssignments.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsGetAttributeAssignmentsResults", wsAttributeAssignmentsResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.getAttributeAssignments.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsGetAttributeAssignmentsResults, " + "grouperClientUtils, index, wsAttributeAssignment");
        HashMap<String, WsGroup> groupLookup = new HashMap<String, WsGroup>();
        for (WsGroup wsGroupCurrent : GrouperClientUtils.nonNull(wsAttributeAssignmentsResults.getWsGroups(), WsGroup.class)) {
            groupLookup.put(wsGroupCurrent.getUuid(), wsGroupCurrent);
        }
        HashMap<MultiKey, WsSubject> subjectLookup = new HashMap<MultiKey, WsSubject>();
        for (WsSubject wsSubject : GrouperClientUtils.nonNull(wsAttributeAssignmentsResults.getWsSubjects(), WsSubject.class)) {
            MultiKey key = new MultiKey(wsSubject.getSourceId(), wsSubject.getId());
            subjectLookup.put(key, wsSubject);
        }
        HashMap<String, WsStem> stemLookup = new HashMap<String, WsStem>();
        for (WsStem wsStemCurrent : GrouperClientUtils.nonNull(wsAttributeAssignmentsResults.getWsStems(), WsStem.class)) {
            stemLookup.put(wsStemCurrent.getUuid(), wsStemCurrent);
        }
        HashMap<String, WsAttributeDef> attributeDefLookup = new HashMap<String, WsAttributeDef>();
        for (WsAttributeDef wsAttributeDefCurrent : GrouperClientUtils.nonNull(wsAttributeAssignmentsResults.getWsAttributeDefs(), WsAttributeDef.class)) {
            attributeDefLookup.put(wsAttributeDefCurrent.getUuid(), wsAttributeDefCurrent);
        }
        HashMap<String, WsAttributeDefName> attributeDefNameLookup = new HashMap<String, WsAttributeDefName>();
        for (WsAttributeDefName wsAttributeDefNameCurrent : GrouperClientUtils.nonNull(wsAttributeAssignmentsResults.getWsAttributeDefNames(), WsAttributeDefName.class)) {
            attributeDefNameLookup.put(wsAttributeDefNameCurrent.getUuid(), wsAttributeDefNameCurrent);
        }
        HashMap<String, WsMembership> membershipLookup = new HashMap<String, WsMembership>();
        for (WsMembership wsMembershipCurrent : GrouperClientUtils.nonNull(wsAttributeAssignmentsResults.getWsMemberships(), WsMembership.class)) {
            membershipLookup.put(wsMembershipCurrent.getMembershipId(), wsMembershipCurrent);
            if (!"immediate".equals(wsMembershipCurrent.getMembershipType())) continue;
            membershipLookup.put(wsMembershipCurrent.getImmediateMembershipId(), wsMembershipCurrent);
        }
        for (WsAttributeAssign wsAttributeAssign : GrouperClientUtils.nonNull(wsAttributeAssignmentsResults.getWsAttributeAssigns(), WsAttributeAssign.class)) {
            WsAttributeDef wsAttributeDef = (WsAttributeDef)attributeDefLookup.get(wsAttributeAssign.getAttributeDefId());
            WsAttributeDefName wsAttributeDefName = (WsAttributeDefName)attributeDefNameLookup.get(wsAttributeAssign.getAttributeDefNameId());
            WsStem wsOwnerStem = (WsStem)stemLookup.get(wsAttributeAssign.getOwnerStemId());
            WsAttributeDef wsOwnerAttributeDef = (WsAttributeDef)attributeDefLookup.get(wsAttributeAssign.getOwnerAttributeDefId());
            WsMembership wsOwnerMembership = (WsMembership)membershipLookup.get(wsAttributeAssign.getOwnerMembershipId());
            WsGroup wsOwnerGroup = (WsGroup)groupLookup.get(wsAttributeAssign.getOwnerGroupId());
            MultiKey ownerSubjectKey = new MultiKey(wsAttributeAssign.getOwnerMemberSourceId(), wsAttributeAssign.getOwnerMemberSubjectId());
            WsSubject wsOwnerMemberSubject = (WsSubject)subjectLookup.get(ownerSubjectKey);
            String ownerName = null;
            if (GrouperClientUtils.equals("group", wsAttributeAssign.getAttributeAssignType())) {
                ownerName = wsOwnerGroup.getName();
            } else if (GrouperClientUtils.equals("member", wsAttributeAssign.getAttributeAssignType())) {
                ownerName = wsAttributeAssign.getOwnerMemberSourceId() + " - " + wsAttributeAssign.getOwnerMemberSubjectId();
            } else if (GrouperClientUtils.equals("stem", wsAttributeAssign.getAttributeAssignType())) {
                ownerName = wsOwnerStem.getName();
            } else if (GrouperClientUtils.equals("any_mem", wsAttributeAssign.getAttributeAssignType())) {
                ownerName = wsOwnerGroup.getName() + " - " + wsAttributeAssign.getOwnerMemberSourceId() + " - " + wsAttributeAssign.getOwnerMemberSubjectId();
            } else if (GrouperClientUtils.equals("imm_mem", wsAttributeAssign.getAttributeAssignType())) {
                ownerName = wsAttributeAssign.getOwnerMembershipId();
            } else if (GrouperClientUtils.equals("attr_def", wsAttributeAssign.getAttributeAssignType())) {
                ownerName = wsOwnerAttributeDef.getName();
            } else if (wsAttributeAssign.getAttributeAssignType() != null && wsAttributeAssign.getAttributeAssignType().endsWith("_asgn")) {
                ownerName = wsAttributeAssign.getOwnerAttributeAssignId();
            } else {
                throw new RuntimeException("Cant find attribute assign type: " + wsAttributeAssign.getAttributeAssignType());
            }
            String valuesString = "none";
            int valuesLength = GrouperClientUtils.length(wsAttributeAssign.getWsAttributeAssignValues());
            if (valuesLength > 0) {
                StringBuilder valuesResult = new StringBuilder();
                for (int i2 = 0; i2 < valuesLength; ++i2) {
                    WsAttributeAssignValue wsAttributeAssignValue = wsAttributeAssign.getWsAttributeAssignValues()[i2];
                    valuesResult.append(wsAttributeAssignValue.getValueSystem());
                    if (i2 >= valuesLength - 1) continue;
                    valuesResult.append(",");
                }
                valuesString = valuesResult.toString();
            }
            substituteMap.put("index", index);
            substituteMap.put("ownerName", ownerName);
            substituteMap.put("valuesString", valuesString);
            substituteMap.put("wsOwnerAttributeDef", wsOwnerAttributeDef);
            substituteMap.put("wsAttributeAssign", wsAttributeAssign);
            substituteMap.put("wsAttributeDef", wsAttributeDef);
            substituteMap.put("wsAttributeDefName", wsAttributeDefName);
            substituteMap.put("wsOwnerMemberSubject", wsOwnerMemberSubject);
            substituteMap.put("wsOwnerMembership", wsOwnerMembership);
            substituteMap.put("wsOwnerGroup", wsOwnerGroup);
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String assignAttributes(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        Set<String> attributeDefUuidsToReplace;
        Set<String> attributeDefNamesToReplace;
        Set<String> attributeDefTypesToReplace;
        Set<String> actionsToReplace;
        Set<String> ownerAttributeDefUuids;
        Set<String> ownerAttributeDefNames;
        Set<String> attributeDefNameUuids;
        List<String> ownerStemNames;
        List<String> ownerStemUuids;
        List<String> ownerMembershipUuids;
        List<String> ownerGroupNames;
        List<String> ownerGroupUuids;
        int i;
        GcAssignAttributes gcAssignAttributes = new GcAssignAttributes();
        for (i = 0; i < 10; ++i) {
            WsSubjectLookup ownerMembershipAnySubjectLookup = GrouperClient.retrieveSuffixSubjectFromArgs(argMap, argMapNotUsed, "ownerMembershipAny" + i, false);
            String ownerMembershipAnyGroupUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "ownerMembershipAny" + i + "GroupUuid", false);
            String ownerMembershipAnyGroupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "ownerMembershipAny" + i + "GroupName", false);
            if (ownerMembershipAnySubjectLookup == null && GrouperClientUtils.isBlank(ownerMembershipAnyGroupName) && GrouperClientUtils.isBlank(ownerMembershipAnyGroupUuid)) continue;
            WsMembershipAnyLookup wsMembershipAnyLookup = new WsMembershipAnyLookup();
            wsMembershipAnyLookup.setWsGroupLookup(new WsGroupLookup(ownerMembershipAnyGroupName, ownerMembershipAnyGroupUuid));
            wsMembershipAnyLookup.setWsSubjectLookup(ownerMembershipAnySubjectLookup);
            gcAssignAttributes.addOwnerMembershipAnyLookup(wsMembershipAnyLookup);
        }
        for (i = 0; i < 10; ++i) {
            WsSubjectLookup ownerSubjectLookup = GrouperClient.retrieveSuffixSubjectFromArgs(argMap, argMapNotUsed, "owner" + i, false);
            if (ownerSubjectLookup == null) continue;
            gcAssignAttributes.addOwnerSubjectLookup(ownerSubjectLookup);
        }
        for (i = 0; i < 10; ++i) {
            String valuesId = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "values" + i + "Id", false);
            String valuesFormatted = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "values" + i + "Formatted", false);
            String valuesSystem = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "values" + i + "System", false);
            if (GrouperClientUtils.isBlank(valuesId) && GrouperClientUtils.isBlank(valuesFormatted) && GrouperClientUtils.isBlank(valuesSystem)) continue;
            WsAttributeAssignValue wsAttributeAssignValue = new WsAttributeAssignValue();
            wsAttributeAssignValue.setId(valuesId);
            wsAttributeAssignValue.setValueFormatted(valuesFormatted);
            wsAttributeAssignValue.setValueSystem(valuesSystem);
            gcAssignAttributes.addValue(wsAttributeAssignValue);
        }
        Set<String> wsOwnerAttributeAssignUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "ownerAttributeAssignUuids", false);
        if (GrouperClientUtils.length(wsOwnerAttributeAssignUuids) > 0) {
            for (String attributeAssignUuid : wsOwnerAttributeAssignUuids) {
                WsAttributeAssignLookup wsAttributeAssignLookup = new WsAttributeAssignLookup();
                wsAttributeAssignLookup.setUuid(attributeAssignUuid);
                gcAssignAttributes.addOwnerAttributeAssignLookup(wsAttributeAssignLookup);
            }
        }
        Timestamp assignmentDisabledTime = GrouperClientUtils.argMapTimestamp(argMap, argMapNotUsed, "assignmentDisabledTime");
        gcAssignAttributes.assignDisabledTime(assignmentDisabledTime);
        Timestamp assignmentEnabledTime = GrouperClientUtils.argMapTimestamp(argMap, argMapNotUsed, "assignmentEnabledTime");
        gcAssignAttributes.assignEnabledTime(assignmentEnabledTime);
        String assignmentNotes = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "assignmentNotes", false);
        gcAssignAttributes.assignAssignmentNotes(assignmentNotes);
        String delegatable = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "delegatable", false);
        gcAssignAttributes.assignDelegatable(delegatable);
        String attributeAssignOperation = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "attributeAssignOperation", false);
        gcAssignAttributes.assignAttributeAssignOperation(attributeAssignOperation);
        String attributeAssignValueOperation = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "attributeAssignValueOperation", false);
        gcAssignAttributes.assignAttributeAssignValueOperation(attributeAssignValueOperation);
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        gcAssignAttributes.assignIncludeSubjectDetail(includeSubjectDetail);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        gcAssignAttributes.assignIncludeGroupDetail(includeGroupDetail);
        Set<String> attributeAssignUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeAssignUuids", false);
        if (GrouperClientUtils.length(attributeAssignUuids) > 0) {
            for (String attributeAssignUuid : attributeAssignUuids) {
                gcAssignAttributes.addAttributeAssignId(attributeAssignUuid);
            }
        }
        if (GrouperClientUtils.length(ownerGroupUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "ownerGroupUuids", false)) > 0) {
            for (String ownerGroupUuid : ownerGroupUuids) {
                gcAssignAttributes.addOwnerGroupUuid(ownerGroupUuid);
            }
        }
        if (GrouperClientUtils.length(ownerGroupNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "ownerGroupNames", false)) > 0) {
            for (String ownerGroupName : ownerGroupNames) {
                gcAssignAttributes.addOwnerGroupName(ownerGroupName);
            }
        }
        if (GrouperClientUtils.length(ownerMembershipUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "ownerMembershipUuids", false)) > 0) {
            for (String ownerMembershipUuid : ownerMembershipUuids) {
                gcAssignAttributes.addOwnerMembershipId(ownerMembershipUuid);
            }
        }
        if (GrouperClientUtils.length(ownerStemUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "ownerStemUuids", false)) > 0) {
            for (String ownerStemUuid : ownerStemUuids) {
                gcAssignAttributes.addOwnerStemUuid(ownerStemUuid);
            }
        }
        if (GrouperClientUtils.length(ownerStemNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "ownerStemNames", false)) > 0) {
            for (String ownerStemName : ownerStemNames) {
                gcAssignAttributes.addOwnerStemName(ownerStemName);
            }
        }
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcAssignAttributes.assignClientVersion(clientVersion);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcAssignAttributes.assignActAsSubject(actAsSubject);
        String attributeAssignType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "attributeAssignType", true);
        gcAssignAttributes.assignAttributeAssignType(attributeAssignType);
        Set<String> attributeDefNameNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefNameNames", false);
        if (GrouperClientUtils.length(attributeDefNameNames) > 0) {
            for (String attributeDefNameName : attributeDefNameNames) {
                gcAssignAttributes.addAttributeDefNameName(attributeDefNameName);
            }
        }
        if (GrouperClientUtils.length(attributeDefNameUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefNameUuids", false)) > 0) {
            for (String attributeDefNameUuid : attributeDefNameUuids) {
                gcAssignAttributes.addAttributeDefNameUuid(attributeDefNameUuid);
            }
        }
        if (GrouperClientUtils.length(ownerAttributeDefNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "ownerAttributeDefNames", false)) > 0) {
            for (String ownerAttributeDefName : ownerAttributeDefNames) {
                gcAssignAttributes.addOwnerAttributeDefName(ownerAttributeDefName);
            }
        }
        if (GrouperClientUtils.length(ownerAttributeDefUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "ownerAttributeDefUuids", false)) > 0) {
            for (String ownerAttributeDefUuid : ownerAttributeDefUuids) {
                gcAssignAttributes.addOwnerAttributeDefUuid(ownerAttributeDefUuid);
            }
        }
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcAssignAttributes.addSubjectAttributeName(subjectAttribute);
        }
        Set<String> actions = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "actions", false);
        if (GrouperClientUtils.length(actions) > 0) {
            for (String action : actions) {
                gcAssignAttributes.addAction(action);
            }
        }
        if (GrouperClientUtils.length(actionsToReplace = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "actionsToReplace", false)) > 0) {
            for (String actionToReplace : actionsToReplace) {
                gcAssignAttributes.addActionToReplace(actionToReplace);
            }
        }
        if (GrouperClientUtils.length(attributeDefTypesToReplace = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefTypesToReplace", false)) > 0) {
            for (String attributeDefTypeToReplace : attributeDefTypesToReplace) {
                gcAssignAttributes.addAttributeDefTypeToReplace(attributeDefTypeToReplace);
            }
        }
        if (GrouperClientUtils.length(attributeDefNamesToReplace = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefNamesToReplace", false)) > 0) {
            for (String attributeDefNameToReplace : attributeDefNamesToReplace) {
                gcAssignAttributes.addAttributeDefNameToReplace(attributeDefNameToReplace);
            }
        }
        if (GrouperClientUtils.length(attributeDefUuidsToReplace = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefUuidsToReplace", false)) > 0) {
            for (String attributeDefUuidToReplace : attributeDefUuidsToReplace) {
                gcAssignAttributes.addAttributeDefUuidToReplace(attributeDefUuidToReplace);
            }
        }
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        for (WsParam param : params) {
            gcAssignAttributes.addParam(param);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsAssignAttributesResults wsAssignAttributesResults = gcAssignAttributes.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsAssignAttributesResults", wsAssignAttributesResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.assignAttributes.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsAssignAttributesResults, " + "grouperClientUtils, index, wsAttributeAssignment");
        HashMap<String, WsGroup> groupLookup = new HashMap<String, WsGroup>();
        for (WsGroup wsGroupCurrent : GrouperClientUtils.nonNull(wsAssignAttributesResults.getWsGroups(), WsGroup.class)) {
            groupLookup.put(wsGroupCurrent.getUuid(), wsGroupCurrent);
        }
        HashMap<MultiKey, WsSubject> subjectLookup = new HashMap<MultiKey, WsSubject>();
        for (WsSubject wsSubject : GrouperClientUtils.nonNull(wsAssignAttributesResults.getWsSubjects(), WsSubject.class)) {
            MultiKey key = new MultiKey(wsSubject.getSourceId(), wsSubject.getId());
            subjectLookup.put(key, wsSubject);
        }
        HashMap<String, WsStem> stemLookup = new HashMap<String, WsStem>();
        for (WsStem wsStemCurrent : GrouperClientUtils.nonNull(wsAssignAttributesResults.getWsStems(), WsStem.class)) {
            stemLookup.put(wsStemCurrent.getUuid(), wsStemCurrent);
        }
        HashMap<String, WsAttributeDef> attributeDefLookup = new HashMap<String, WsAttributeDef>();
        for (WsAttributeDef wsAttributeDefCurrent : GrouperClientUtils.nonNull(wsAssignAttributesResults.getWsAttributeDefs(), WsAttributeDef.class)) {
            attributeDefLookup.put(wsAttributeDefCurrent.getUuid(), wsAttributeDefCurrent);
        }
        HashMap<String, WsAttributeDefName> attributeDefNameLookup = new HashMap<String, WsAttributeDefName>();
        for (WsAttributeDefName wsAttributeDefNameCurrent : GrouperClientUtils.nonNull(wsAssignAttributesResults.getWsAttributeDefNames(), WsAttributeDefName.class)) {
            attributeDefNameLookup.put(wsAttributeDefNameCurrent.getUuid(), wsAttributeDefNameCurrent);
        }
        HashMap<String, WsMembership> membershipLookup = new HashMap<String, WsMembership>();
        for (WsMembership wsMembershipCurrent : GrouperClientUtils.nonNull(wsAssignAttributesResults.getWsMemberships(), WsMembership.class)) {
            membershipLookup.put(wsMembershipCurrent.getMembershipId(), wsMembershipCurrent);
            if (!"immediate".equals(wsMembershipCurrent.getMembershipType())) continue;
            membershipLookup.put(wsMembershipCurrent.getImmediateMembershipId(), wsMembershipCurrent);
        }
        for (WsAssignAttributeResult wsAssignAttributeResult : GrouperClientUtils.nonNull(wsAssignAttributesResults.getWsAttributeAssignResults(), WsAssignAttributeResult.class)) {
            substituteMap.put("wsAssignAttributeResult", wsAssignAttributeResult);
            for (WsAttributeAssign wsAttributeAssign : GrouperClientUtils.nonNull(wsAssignAttributeResult.getWsAttributeAssigns(), WsAttributeAssign.class)) {
                WsAttributeDef wsAttributeDef = (WsAttributeDef)attributeDefLookup.get(wsAttributeAssign.getAttributeDefId());
                WsAttributeDefName wsAttributeDefName = (WsAttributeDefName)attributeDefNameLookup.get(wsAttributeAssign.getAttributeDefNameId());
                WsStem wsOwnerStem = (WsStem)stemLookup.get(wsAttributeAssign.getOwnerStemId());
                WsAttributeDef wsOwnerAttributeDef = (WsAttributeDef)attributeDefLookup.get(wsAttributeAssign.getOwnerAttributeDefId());
                WsMembership wsOwnerMembership = (WsMembership)membershipLookup.get(wsAttributeAssign.getOwnerMembershipId());
                WsGroup wsOwnerGroup = (WsGroup)groupLookup.get(wsAttributeAssign.getOwnerGroupId());
                MultiKey ownerSubjectKey = new MultiKey(wsAttributeAssign.getOwnerMemberSourceId(), wsAttributeAssign.getOwnerMemberSubjectId());
                WsSubject wsOwnerMemberSubject = (WsSubject)subjectLookup.get(ownerSubjectKey);
                String ownerName = null;
                if (GrouperClientUtils.equals("group", wsAttributeAssign.getAttributeAssignType())) {
                    ownerName = wsOwnerGroup.getName();
                } else if (GrouperClientUtils.equals("member", wsAttributeAssign.getAttributeAssignType())) {
                    ownerName = wsAttributeAssign.getOwnerMemberSourceId() + " - " + wsAttributeAssign.getOwnerMemberSubjectId();
                } else if (GrouperClientUtils.equals("stem", wsAttributeAssign.getAttributeAssignType())) {
                    ownerName = wsOwnerStem.getName();
                } else if (GrouperClientUtils.equals("any_mem", wsAttributeAssign.getAttributeAssignType())) {
                    ownerName = wsOwnerGroup.getName() + " - " + wsAttributeAssign.getOwnerMemberSourceId() + " - " + wsAttributeAssign.getOwnerMemberSubjectId();
                } else if (GrouperClientUtils.equals("imm_mem", wsAttributeAssign.getAttributeAssignType())) {
                    ownerName = wsAttributeAssign.getOwnerMembershipId();
                } else if (GrouperClientUtils.equals("attr_def", wsAttributeAssign.getAttributeAssignType())) {
                    ownerName = wsOwnerAttributeDef.getName();
                } else if (wsAttributeAssign.getAttributeAssignType() != null && wsAttributeAssign.getAttributeAssignType().endsWith("_asgn")) {
                    ownerName = wsAttributeAssign.getOwnerAttributeAssignId();
                } else {
                    throw new RuntimeException("Cant find attribute assign type: " + wsAttributeAssign.getAttributeAssignType());
                }
                String valuesString = "none";
                int valuesLength = GrouperClientUtils.length(wsAttributeAssign.getWsAttributeAssignValues());
                if (valuesLength > 0) {
                    StringBuilder valuesResult = new StringBuilder();
                    for (int i2 = 0; i2 < valuesLength; ++i2) {
                        WsAttributeAssignValue wsAttributeAssignValue = wsAttributeAssign.getWsAttributeAssignValues()[i2];
                        valuesResult.append(wsAttributeAssignValue.getValueSystem());
                        if (i2 >= valuesLength - 1) continue;
                        valuesResult.append(",");
                    }
                    valuesString = valuesResult.toString();
                }
                substituteMap.put("index", index);
                substituteMap.put("ownerName", ownerName);
                substituteMap.put("valuesString", valuesString);
                substituteMap.put("wsOwnerAttributeDef", wsOwnerAttributeDef);
                substituteMap.put("wsAttributeAssign", wsAttributeAssign);
                substituteMap.put("wsAttributeDef", wsAttributeDef);
                substituteMap.put("wsAttributeDefName", wsAttributeDefName);
                substituteMap.put("wsOwnerMemberSubject", wsOwnerMemberSubject);
                substituteMap.put("wsOwnerMembership", wsOwnerMembership);
                substituteMap.put("wsOwnerGroup", wsOwnerGroup);
                String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
                result.append(output);
                ++index;
            }
        }
        return result.toString();
    }

    private static String getPermissionAssignments(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        Set<String> attributeDefUuids;
        Set<String> attributeDefNames;
        Set<String> attributeDefNameUuids;
        List<String> roleNames;
        GcGetPermissionAssignments gcGetPermissionAssignments = new GcGetPermissionAssignments();
        for (int i = 0; i < 10; ++i) {
            WsSubjectLookup subjectLookup = GrouperClient.retrieveSuffixSubjectFromArgs(argMap, argMapNotUsed, "subject" + i, false);
            if (subjectLookup == null) continue;
            gcGetPermissionAssignments.addSubjectLookup(subjectLookup);
        }
        Boolean includeAssignmentsOnAssignments = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeAssignmentsOnAssignments");
        gcGetPermissionAssignments.assignIncludeAssignmentsOnAssignments(includeAssignmentsOnAssignments);
        Boolean includeAttributeAssignments = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeAttributeAssignments");
        gcGetPermissionAssignments.assignIncludeAttributeAssignments(includeAttributeAssignments);
        Boolean includeAttributeDefNames = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeAttributeDefNames");
        gcGetPermissionAssignments.assignIncludeAttributeDefNames(includeAttributeDefNames);
        Boolean includePermissionAssignDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includePermissionAssignDetail");
        gcGetPermissionAssignments.assignIncludePermissionAssignDetail(includePermissionAssignDetail);
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        gcGetPermissionAssignments.assignIncludeSubjectDetail(includeSubjectDetail);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        gcGetPermissionAssignments.assignIncludeGroupDetail(includeGroupDetail);
        List<String> roleUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "roleUuids", false);
        if (GrouperClientUtils.length(roleUuids) > 0) {
            for (String ownerGroupUuid : roleUuids) {
                gcGetPermissionAssignments.addRoleUuid(ownerGroupUuid);
            }
        }
        if (GrouperClientUtils.length(roleNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "roleNames", false)) > 0) {
            for (String ownerGroupName : roleNames) {
                gcGetPermissionAssignments.addRoleName(ownerGroupName);
            }
        }
        String enabled = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "enabled", false);
        gcGetPermissionAssignments.assignEnabled(enabled);
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcGetPermissionAssignments.assignClientVersion(clientVersion);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcGetPermissionAssignments.assignActAsSubject(actAsSubject);
        Set<String> attributeDefNameNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefNameNames", false);
        if (GrouperClientUtils.length(attributeDefNameNames) > 0) {
            for (String attributeDefNameName : attributeDefNameNames) {
                gcGetPermissionAssignments.addAttributeDefNameName(attributeDefNameName);
            }
        }
        if (GrouperClientUtils.length(attributeDefNameUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefNameUuids", false)) > 0) {
            for (String attributeDefNameUuid : attributeDefNameUuids) {
                gcGetPermissionAssignments.addAttributeDefNameUuid(attributeDefNameUuid);
            }
        }
        if (GrouperClientUtils.length(attributeDefNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefNames", false)) > 0) {
            for (String attributeDefName : attributeDefNames) {
                gcGetPermissionAssignments.addAttributeDefName(attributeDefName);
            }
        }
        if (GrouperClientUtils.length(attributeDefUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefUuids", false)) > 0) {
            for (String attributeDefUuid : attributeDefUuids) {
                gcGetPermissionAssignments.addAttributeDefUuid(attributeDefUuid);
            }
        }
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcGetPermissionAssignments.addSubjectAttributeName(subjectAttribute);
        }
        Set<String> actions = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "actions", false);
        if (GrouperClientUtils.length(actions) > 0) {
            for (String action : actions) {
                gcGetPermissionAssignments.addAction(action);
            }
        }
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        for (WsParam param : params) {
            gcGetPermissionAssignments.addParam(param);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsGetPermissionAssignmentsResults wsPermissionAssignmentsResults = gcGetPermissionAssignments.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsPermissionAssignmentsResults", wsPermissionAssignmentsResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.getPermissionAssignments.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsPermissionAssignmentsResults, " + "grouperClientUtils, index, wsAttributeAssignment, wsPermissionAssign, wsAttributeDef, wsAttributeDefName, wsSubject, role");
        HashMap<String, WsGroup> groupLookup = new HashMap<String, WsGroup>();
        for (WsGroup wsGroupCurrent : GrouperClientUtils.nonNull(wsPermissionAssignmentsResults.getWsGroups(), WsGroup.class)) {
            groupLookup.put(wsGroupCurrent.getUuid(), wsGroupCurrent);
        }
        HashMap<MultiKey, WsSubject> subjectLookup = new HashMap<MultiKey, WsSubject>();
        for (WsSubject wsSubject : GrouperClientUtils.nonNull(wsPermissionAssignmentsResults.getWsSubjects(), WsSubject.class)) {
            MultiKey key = new MultiKey(wsSubject.getSourceId(), wsSubject.getId());
            subjectLookup.put(key, wsSubject);
        }
        HashMap<String, WsAttributeDef> attributeDefLookup = new HashMap<String, WsAttributeDef>();
        for (WsAttributeDef wsAttributeDefCurrent : GrouperClientUtils.nonNull(wsPermissionAssignmentsResults.getWsAttributeDefs(), WsAttributeDef.class)) {
            attributeDefLookup.put(wsAttributeDefCurrent.getUuid(), wsAttributeDefCurrent);
        }
        HashMap<String, WsAttributeDefName> attributeDefNameLookup = new HashMap<String, WsAttributeDefName>();
        for (WsAttributeDefName wsAttributeDefNameCurrent : GrouperClientUtils.nonNull(wsPermissionAssignmentsResults.getWsAttributeDefNames(), WsAttributeDefName.class)) {
            attributeDefNameLookup.put(wsAttributeDefNameCurrent.getUuid(), wsAttributeDefNameCurrent);
        }
        HashMap<String, WsAttributeAssign> attributeAssignLookup = new HashMap<String, WsAttributeAssign>();
        for (WsAttributeAssign wsAttributeAssignCurrent : GrouperClientUtils.nonNull(wsPermissionAssignmentsResults.getWsAttributeAssigns(), WsAttributeAssign.class)) {
            attributeAssignLookup.put(wsAttributeAssignCurrent.getId(), wsAttributeAssignCurrent);
        }
        for (WsPermissionAssign wsPermissionAssign : GrouperClientUtils.nonNull(wsPermissionAssignmentsResults.getWsPermissionAssigns(), WsPermissionAssign.class)) {
            WsAttributeAssign wsAttributeAssign = (WsAttributeAssign)attributeAssignLookup.get(wsPermissionAssign.getAttributeDefId());
            WsAttributeDef wsAttributeDef = (WsAttributeDef)attributeDefLookup.get(wsPermissionAssign.getAttributeDefId());
            WsAttributeDefName wsAttributeDefName = (WsAttributeDefName)attributeDefNameLookup.get(wsPermissionAssign.getAttributeDefNameId());
            WsGroup role = (WsGroup)groupLookup.get(wsPermissionAssign.getRoleId());
            MultiKey subjectKey = new MultiKey(wsPermissionAssign.getSourceId(), wsPermissionAssign.getSubjectId());
            WsSubject wsSubject = (WsSubject)subjectLookup.get(subjectKey);
            substituteMap.put("index", index);
            substituteMap.put("wsAttributeAssign", wsAttributeAssign);
            substituteMap.put("wsPermissionAssign", wsPermissionAssign);
            substituteMap.put("wsAttributeDef", wsAttributeDef);
            substituteMap.put("wsAttributeDefName", wsAttributeDefName);
            substituteMap.put("wsSubject", wsSubject);
            substituteMap.put("role", role);
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            result.append(output);
            ++index;
        }
        return result.toString();
    }

    private static String assignPermissions(Map<String, String> argMap, Map<String, String> argMapNotUsed) {
        Set<String> attributeDefUuidsToReplace;
        Set<String> attributeDefNamesToReplace;
        Set<String> actionsToReplace;
        Set<String> permissionDefNameUuids;
        List<String> roleNames;
        List<String> roleUuids;
        GcAssignPermissions gcAssignPermissions = new GcAssignPermissions();
        for (int i = 0; i < 10; ++i) {
            WsSubjectLookup subjectRoleSubjectLookup = GrouperClient.retrieveSuffixSubjectFromArgs(argMap, argMapNotUsed, "subjectRole" + i, false);
            String subjectRoleUuid = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "subjectRole" + i + "RoleUuid", false);
            String subjectRoleName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "subjectRole" + i + "RoleName", false);
            if (subjectRoleSubjectLookup == null && GrouperClientUtils.isBlank(subjectRoleName) && GrouperClientUtils.isBlank(subjectRoleUuid)) continue;
            WsMembershipAnyLookup subjectRoleLookup = new WsMembershipAnyLookup();
            subjectRoleLookup.setWsGroupLookup(new WsGroupLookup(subjectRoleName, subjectRoleUuid));
            subjectRoleLookup.setWsSubjectLookup(subjectRoleSubjectLookup);
            gcAssignPermissions.addSubjectRoleLookup(subjectRoleLookup);
        }
        Timestamp assignmentDisabledTime = GrouperClientUtils.argMapTimestamp(argMap, argMapNotUsed, "assignmentDisabledTime");
        gcAssignPermissions.assignDisabledTime(assignmentDisabledTime);
        Timestamp assignmentEnabledTime = GrouperClientUtils.argMapTimestamp(argMap, argMapNotUsed, "assignmentEnabledTime");
        gcAssignPermissions.assignEnabledTime(assignmentEnabledTime);
        String assignmentNotes = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "assignmentNotes", false);
        gcAssignPermissions.assignAssignmentNotes(assignmentNotes);
        String delegatable = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "delegatable", false);
        gcAssignPermissions.assignDelegatable(delegatable);
        String permissionAssignOperation = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "permissionAssignOperation", false);
        gcAssignPermissions.assignPermissionAssignOperation(permissionAssignOperation);
        Boolean includeSubjectDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeSubjectDetail");
        gcAssignPermissions.assignIncludeSubjectDetail(includeSubjectDetail);
        Boolean includeGroupDetail = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "includeGroupDetail");
        gcAssignPermissions.assignIncludeGroupDetail(includeGroupDetail);
        Set<String> attributeAssignUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeAssignUuids", false);
        if (GrouperClientUtils.length(attributeAssignUuids) > 0) {
            for (String attributeAssignUuid : attributeAssignUuids) {
                gcAssignPermissions.addAttributeAssignId(attributeAssignUuid);
            }
        }
        if (GrouperClientUtils.length(roleUuids = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "roleUuids", false)) > 0) {
            for (String roleUuid : roleUuids) {
                gcAssignPermissions.addRoleUuid(roleUuid);
            }
        }
        if (GrouperClientUtils.length(roleNames = GrouperClientUtils.argMapList(argMap, argMapNotUsed, "roleNames", false)) > 0) {
            for (String roleName : roleNames) {
                gcAssignPermissions.addRoleName(roleName);
            }
        }
        String clientVersion = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "clientVersion", false);
        gcAssignPermissions.assignClientVersion(clientVersion);
        WsSubjectLookup actAsSubject = GrouperClient.retrieveActAsSubjectFromArgs(argMap, argMapNotUsed);
        gcAssignPermissions.assignActAsSubject(actAsSubject);
        String permissionType = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "permissionType", true);
        gcAssignPermissions.assignPermissionType(permissionType);
        Set<String> permissionDefNameNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "permissionDefNameNames", false);
        if (GrouperClientUtils.length(permissionDefNameNames) > 0) {
            for (String permissionDefNameName : permissionDefNameNames) {
                gcAssignPermissions.addPermissionDefNameName(permissionDefNameName);
            }
        }
        if (GrouperClientUtils.length(permissionDefNameUuids = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "permissionDefNameUuids", false)) > 0) {
            for (String permissionDefNameUuid : permissionDefNameUuids) {
                gcAssignPermissions.addPermissionDefNameUuid(permissionDefNameUuid);
            }
        }
        Set<String> subjectAttributeNames = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "subjectAttributeNames", false);
        for (String subjectAttribute : GrouperClientUtils.nonNull(subjectAttributeNames)) {
            gcAssignPermissions.addSubjectAttributeName(subjectAttribute);
        }
        Set<String> actions = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "actions", false);
        if (GrouperClientUtils.length(actions) > 0) {
            for (String action : actions) {
                gcAssignPermissions.addAction(action);
            }
        }
        if (GrouperClientUtils.length(actionsToReplace = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "actionsToReplace", false)) > 0) {
            for (String actionToReplace : actionsToReplace) {
                gcAssignPermissions.addActionToReplace(actionToReplace);
            }
        }
        if (GrouperClientUtils.length(attributeDefNamesToReplace = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefNamesToReplace", false)) > 0) {
            for (String attributeDefNameToReplace : attributeDefNamesToReplace) {
                gcAssignPermissions.addAttributeDefNameToReplace(attributeDefNameToReplace);
            }
        }
        if (GrouperClientUtils.length(attributeDefUuidsToReplace = GrouperClientUtils.argMapSet(argMap, argMapNotUsed, "attributeDefUuidsToReplace", false)) > 0) {
            for (String attributeDefUuidToReplace : attributeDefUuidsToReplace) {
                gcAssignPermissions.addAttributeDefUuidToReplace(attributeDefUuidToReplace);
            }
        }
        List<WsParam> params = GrouperClient.retrieveParamsFromArgs(argMap, argMapNotUsed);
        for (WsParam param : params) {
            gcAssignPermissions.addParam(param);
        }
        GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", false);
        GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        WsAssignPermissionsResults wsAssignPermissionsResults = gcAssignPermissions.execute();
        StringBuilder result = new StringBuilder();
        int index = 0;
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        substituteMap.put("wsAssignPermissionsResults", wsAssignPermissionsResults);
        substituteMap.put("grouperClientUtils", new GrouperClientUtils());
        String outputTemplate = null;
        if (argMap.containsKey("outputTemplate")) {
            outputTemplate = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "outputTemplate", true);
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        } else {
            outputTemplate = GrouperClientUtils.propertiesValue("webService.assignPermissions.output", true);
        }
        log.debug("Output template: " + outputTemplate + ", available variables: wsAssignPermissionsResults, " + "grouperClientUtils, index, wsAssignPermissionResult, ownerName, wsAttributeAssign, " + "wsAttributeDef, wsAttributeDefName, wsOwnerGroup, permissionType");
        HashMap<String, WsGroup> groupLookup = new HashMap<String, WsGroup>();
        for (WsGroup wsGroupCurrent : GrouperClientUtils.nonNull(wsAssignPermissionsResults.getWsGroups(), WsGroup.class)) {
            groupLookup.put(wsGroupCurrent.getUuid(), wsGroupCurrent);
        }
        HashMap<MultiKey, WsSubject> subjectLookup = new HashMap<MultiKey, WsSubject>();
        for (WsSubject wsSubject : GrouperClientUtils.nonNull(wsAssignPermissionsResults.getWsSubjects(), WsSubject.class)) {
            MultiKey key = new MultiKey(wsSubject.getSourceId(), wsSubject.getId());
            subjectLookup.put(key, wsSubject);
        }
        HashMap<String, WsAttributeDef> attributeDefLookup = new HashMap<String, WsAttributeDef>();
        for (WsAttributeDef wsAttributeDefCurrent : GrouperClientUtils.nonNull(wsAssignPermissionsResults.getWsAttributeDefs(), WsAttributeDef.class)) {
            attributeDefLookup.put(wsAttributeDefCurrent.getUuid(), wsAttributeDefCurrent);
        }
        HashMap<String, WsAttributeDefName> attributeDefNameLookup = new HashMap<String, WsAttributeDefName>();
        for (WsAttributeDefName wsAttributeDefNameCurrent : GrouperClientUtils.nonNull(wsAssignPermissionsResults.getWsAttributeDefNames(), WsAttributeDefName.class)) {
            attributeDefNameLookup.put(wsAttributeDefNameCurrent.getUuid(), wsAttributeDefNameCurrent);
        }
        for (WsAssignPermissionResult wsAssignPermissionResult : GrouperClientUtils.nonNull(wsAssignPermissionsResults.getWsAssignPermissionResults(), WsAssignPermissionResult.class)) {
            substituteMap.put("wsAssignPermissionResult", wsAssignPermissionResult);
            for (WsAttributeAssign wsAttributeAssign : GrouperClientUtils.nonNull(wsAssignPermissionResult.getWsAttributeAssigns(), WsAttributeAssign.class)) {
                WsAttributeDef wsAttributeDef = (WsAttributeDef)attributeDefLookup.get(wsAttributeAssign.getAttributeDefId());
                WsAttributeDefName wsAttributeDefName = (WsAttributeDefName)attributeDefNameLookup.get(wsAttributeAssign.getAttributeDefNameId());
                WsGroup wsOwnerGroup = (WsGroup)groupLookup.get(wsAttributeAssign.getOwnerGroupId());
                String ownerName = null;
                String permissionType2 = null;
                if (GrouperClientUtils.equals("group", wsAttributeAssign.getAttributeAssignType())) {
                    ownerName = wsOwnerGroup.getName();
                    permissionType2 = "role";
                } else if (GrouperClientUtils.equals("any_mem", wsAttributeAssign.getAttributeAssignType())) {
                    ownerName = wsOwnerGroup.getName() + " - " + wsAttributeAssign.getOwnerMemberSourceId() + " - " + wsAttributeAssign.getOwnerMemberSubjectId();
                    permissionType2 = "role_subject";
                } else {
                    throw new RuntimeException("Cant find attribute assign type: " + wsAttributeAssign.getAttributeAssignType());
                }
                substituteMap.put("permissionType", permissionType2);
                substituteMap.put("index", index);
                substituteMap.put("ownerName", ownerName);
                substituteMap.put("wsAttributeAssign", wsAttributeAssign);
                substituteMap.put("wsAttributeDef", wsAttributeDef);
                substituteMap.put("wsAttributeDefName", wsAttributeDefName);
                substituteMap.put("wsOwnerGroup", wsOwnerGroup);
                String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
                result.append(output);
                ++index;
            }
        }
        return result.toString();
    }
}

