/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.log4j.xml;

import de.huxhorn.lilith.data.eventsource.EventIdentifier;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.log4j.xml.LoggingEventReader;
import de.huxhorn.sulky.buffers.AppendOperation;
import de.huxhorn.sulky.tasks.AbstractProgressingCallable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.input.CountingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4jImportCallable
extends AbstractProgressingCallable<Long> {
    private final Logger logger = LoggerFactory.getLogger(Log4jImportCallable.class);
    public static final String CLOSING_LOG4J_EVENT_TAG = "</log4j:event>";
    public static final String LOG4J_NAMESPACE = "xmlns:log4j=\"http://jakarta.apache.org/log4j/\"";
    public static final String OPENING_LOG4J_EVENT_TAG_EXCL_NS = "<log4j:event ";
    public static final String OPENING_LOG4J_EVENT_TAG_INCL_NS = "<log4j:event xmlns:log4j=\"http://jakarta.apache.org/log4j/\" ";
    private File inputFile;
    private AppendOperation<EventWrapper<LoggingEvent>> buffer;
    private LoggingEventReader instance;
    private long result;

    public Log4jImportCallable(File inputFile, AppendOperation<EventWrapper<LoggingEvent>> buffer) {
        this.buffer = buffer;
        this.inputFile = inputFile;
        this.instance = new LoggingEventReader();
    }

    public AppendOperation<EventWrapper<LoggingEvent>> getBuffer() {
        return this.buffer;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public Long call() throws Exception {
        if (!this.inputFile.isFile()) {
            throw new IllegalArgumentException("'" + this.inputFile.getAbsolutePath() + "' is not a file!");
        }
        if (!this.inputFile.canRead()) {
            throw new IllegalArgumentException("'" + this.inputFile.getAbsolutePath() + "' is not a readable!");
        }
        long fileSize = this.inputFile.length();
        this.setNumberOfSteps(fileSize);
        FileInputStream fis = new FileInputStream(this.inputFile);
        CountingInputStream cis = new CountingInputStream((InputStream)fis);
        String fileName = this.inputFile.getName().toLowerCase();
        BufferedReader br = fileName.endsWith(".gz") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream((InputStream)cis), "UTF-8")) : new BufferedReader(new InputStreamReader((InputStream)cis, "UTF-8"));
        StringBuilder builder = new StringBuilder();
        this.result = 0L;
        while (true) {
            int closeIndex;
            String line = br.readLine();
            this.setCurrentStep(cis.getByteCount());
            if (line == null) break;
            while ((closeIndex = line.indexOf(CLOSING_LOG4J_EVENT_TAG)) >= 0) {
                int endIndex = closeIndex + CLOSING_LOG4J_EVENT_TAG.length();
                builder.append(line.subSequence(0, endIndex));
                this.evaluate(builder.toString());
                builder.setLength(0);
                line = line.substring(endIndex);
            }
            builder.append(line);
            builder.append("\n");
        }
        this.evaluate(builder.toString());
        return this.result;
    }

    private void evaluate(String eventStr) {
        eventStr = this.prepare(eventStr);
        try {
            LoggingEvent event = this.readEvent(eventStr);
            if (event != null) {
                ++this.result;
                EventWrapper wrapper = new EventWrapper();
                wrapper.setEvent((Serializable)event);
                SourceIdentifier sourceIdentifier = new SourceIdentifier(this.inputFile.getAbsolutePath());
                EventIdentifier eventId = new EventIdentifier(sourceIdentifier, this.result);
                wrapper.setEventIdentifier(eventId);
                this.buffer.add((Object)wrapper);
            }
        }
        catch (XMLStreamException e) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private String prepare(String eventStr) {
        if (!eventStr.contains(LOG4J_NAMESPACE)) {
            eventStr = eventStr.replace(OPENING_LOG4J_EVENT_TAG_EXCL_NS, OPENING_LOG4J_EVENT_TAG_INCL_NS);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("After change: {}", (Object)eventStr);
            }
        }
        return eventStr;
    }

    private LoggingEvent readEvent(String eventStr) throws XMLStreamException, UnsupportedEncodingException {
        byte[] bytes = eventStr.getBytes("UTF-8");
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        inputFactory.setProperty("javax.xml.stream.isValidating", false);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        XMLStreamReader reader = inputFactory.createXMLStreamReader(new InputStreamReader((InputStream)in, "utf-8"));
        return this.instance.read(reader);
    }
}

