/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io.progress;

import de.flapdoodle.embed.process.io.progress.ProgressListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingProgressListener
implements ProgressListener {
    private final Logger _logger;
    private final Level _level;

    public LoggingProgressListener(Logger logger, Level level) {
        this._logger = logger;
        this._level = level;
    }

    @Override
    public void start(String label) {
        this._logger.log(this._level, label + " starting...");
    }

    @Override
    public void progress(String label, int percent) {
        this._logger.log(this._level, label + ": " + percent + "% achieved.");
    }

    @Override
    public void info(String label, String message) {
        this._logger.log(this._level, label + ": " + message);
    }

    @Override
    public void done(String label) {
        this._logger.log(this._level, label + " achieved successfully.");
    }
}

