/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.extract.AbstractExtractor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipExtractor
extends AbstractExtractor {
    @Override
    protected AbstractExtractor.ArchiveWrapper archiveStream(File source) throws IOException {
        ZipFile zipIn = new ZipFile(source);
        return new ZipArchiveWrapper(zipIn);
    }

    protected static class ZipArchiveWrapper
    implements AbstractExtractor.ArchiveWrapper {
        private final Enumeration<ZipArchiveEntry> entries;
        private final ZipFile zFile;

        public ZipArchiveWrapper(ZipFile source) {
            this.zFile = source;
            this.entries = source.getEntries();
        }

        @Override
        public ArchiveEntry getNextEntry() throws IOException {
            return this.entries.hasMoreElements() ? this.entries.nextElement() : null;
        }

        @Override
        public boolean canReadEntryData(ArchiveEntry entry) {
            return this.zFile.canReadEntryData(this.zFile.getEntry(entry.getName()));
        }

        @Override
        public void close() throws IOException {
            this.zFile.close();
        }

        @Override
        public InputStream asStream(ArchiveEntry entry) throws IOException {
            return this.zFile.getInputStream(this.zFile.getEntry(entry.getName()));
        }
    }
}

